/*
 * $Id: test.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [Description ]
 * 
 * Test
 */

#define NB_ITERATION 1024
#define CYCLE_MAX    1024*NB_ITERATION

#include "Behavioural/Generic/Counter/SelfTest/include/test.h"
#include "Common/include/Test.h"

void test (string name,
	   morpheo::behavioural::generic::counter::Parameters param)
{
  cout << "<" << name << "> : Simulation SystemC" << endl;

  try 
    {
      cout << param.print(1);
      param.test();
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      cout << "<" << name << "> : " <<  error.what ();
      return;
    }
  catch (...)
    {
      cerr << "<" << name << "> : This test must generate a error" << endl;
      exit (EXIT_FAILURE);
    }
#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * param_stat = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Counter * _Counter = new Counter (name.c_str(),
#ifdef STATISTICS
				    param_stat,
#endif
				    param,
				    _usage);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  sc_clock                                 CLOCK ("clock", 1.0, 0.5);
  sc_signal<Tcontrol_t>                    RESET;
  sc_signal<Tdata_t>                       DATA_IN  [param._nb_port];
  sc_signal<Tcontrol_t>                    ADDSUB   [param._nb_port];
  sc_signal<Tdata_t>                       DATA_OUT [param._nb_port];

  /********************************************************
   * Instanciation
   ********************************************************/
  
  cout << "<" << name << "> Instanciation of _Counter" << endl;
 
  (*(_Counter->in_CLOCK))        (CLOCK);
  (*(_Counter->in_NRESET))       (RESET);

  for (uint32_t i=0; i<param._nb_port; i++)
    {
      (*(_Counter-> in_COUNTER_DATA  [i]))        (DATA_IN  [i]);
      (*(_Counter-> in_COUNTER_ADDSUB[i]))        (ADDSUB   [i]);
      (*(_Counter->out_COUNTER_DATA  [i]))        (DATA_OUT [i]);
    }

  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  cout << "<" << name << "> Start Simulation ............" << endl;
  // Initialisation

  srand(0);
  //srand(TIME(NULL));

  Tdata_t    data_in  [param._nb_port];
  Tdata_t    data_out [param._nb_port];
  Tcontrol_t addsub   [param._nb_port];

  sc_start(0);

  RESET.write(1);

  cout << "{"+toString(static_cast<uint32_t>(sc_simulation_time()))+"} Initialisation" << endl;

  cout << "{"+toString(static_cast<uint32_t>(sc_simulation_time()))+"} Loop of Test" << endl;

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      cout << "{" << static_cast<uint32_t>(sc_simulation_time()) << "} Itration " << iteration << endl;
      for (uint32_t i=0; i<param._nb_port; i++)
	{
	  Tdata_t data = rand()%param._data_max;
	  data_in  [i] = data;
	  addsub   [i] = (rand()%2)==1; 
	  
	  DATA_IN  [i].write(data      );
	  ADDSUB   [i].write(addsub [i]);

	  data_out [i] = (addsub[i]==1)?((data<param._data_max)?data+1:data):((data>0)?data-1:data);
	}

      sc_start(0);
      
      for (uint32_t i=0; i<param._nb_port; i++)
	{
	  cout << hex 
	       << "    [" << i << "] "
	       << data_in [i];

	  if (addsub[i] == 1)
	    cout << " ++";
	  else
	    cout << " --";

	  cout << " = " 
	       << DATA_OUT [i].read();

	  TEST(Tdata_t,DATA_OUT [i].read(),data_out [i]);
	   
	  cout << std::dec << endl;
	}
      
      sc_start(1);
    }

  sc_start(1);

  /********************************************************
   * Simulation - End
   ********************************************************/

  delete _time;

  cout << "<" << name << "> ............ Stop Simulation" << endl;

#endif

  delete _Counter;
#ifdef STATISTICS
  delete param_stat;
#endif

}
