/*
 * $Id: Counter_allocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Counter/include/Counter.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace counter {

  void Counter::allocation (void)
  {
    log_printf(FUNC,Counter,"allocation","Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name     
					     ,"Counter"  
#ifdef POSITION
					     ,COMBINATORY
#endif
					      );
    
    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 , IN  
							 , SOUTH
							 , _("Generalist interface")
#endif
							 );
      
      in_CLOCK              = interface->set_signal_clk              ("clock" ,1,CLOCK_VHDL_NO);
      in_NRESET             = interface->set_signal_in  <Tcontrol_t> ("nreset",1,RESET_VHDL_NO);
    }

    // ~~~~~[ Interface : "counter" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("counter", IN, SOUTH, _("Counter interface"), _param._nb_port);
	   
      ALLOC1_SIGNAL_IN ( in_COUNTER_DATA  ,"data"  ,Tdata_t   ,_param._size_data);
      ALLOC1_SIGNAL_IN ( in_COUNTER_ADDSUB,"addsub",Tcontrol_t,1                );
      ALLOC1_SIGNAL_OUT(out_COUNTER_DATA  ,"data"  ,Tdata_t   ,_param._size_data);

      ALLOC1_INTERFACE_END(_param._nb_port);
    }
    
#ifdef POSITION
     if (usage_is_set(_usage,USE_POSITION))
       _component->generate_file();
#endif

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    log_printf(FUNC,Counter,"allocation","End");
  };

}; // end namespace counter
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
