#ifndef morpheo_behavioural_core_multi_front_end_front_end_context_state_Types_h
#define morpheo_behavioural_core_multi_front_end_front_end_context_state_Types_h

/*
 * $Id: Types.h 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace context_state {

//   NOTES :
//   - MSYNC : memory model is weakly order. MSYNC can be sequentialize memory access
//   - PSYNC : Finalize all instruction, to enter in a critic zone
//   - CSYNC : to flush all structure in the CPU, to change a thread

  typedef enum
    {
      CONTEXT_STATE_OK                                 , // none event
      CONTEXT_STATE_KO_EXCEP                           , // wait end of event (exception)
      CONTEXT_STATE_KO_EXCEP_ADDR                      , // update address manager
      CONTEXT_STATE_KO_EXCEP_SPR                       , // update spr (epc, esr, sr[DSX])
      CONTEXT_STATE_KO_MISS_BRANCH_WAIT_UPDATE         , // branch is complete, wait update by update_prediction_table
      CONTEXT_STATE_KO_MISS_BRANCH_ADDR                , // update address manager
      CONTEXT_STATE_KO_MISS_BRANCH_WAITEND             , // wait end of event (miss branch)
      CONTEXT_STATE_KO_MISS_LOAD_ADDR                  , // update address manager
      CONTEXT_STATE_KO_MISS_LOAD_WAITEND               , // wait end of event (miss load))
      CONTEXT_STATE_KO_MISS_LOAD_AND_BRANCH_WAIT_UPDATE, // branch is complete, wait update by update_prediction_table
      CONTEXT_STATE_KO_MISS_LOAD_AND_BRANCH_ADDR       , // update address manager
      CONTEXT_STATE_KO_MISS_LOAD_AND_BRANCH_WAITEND    , // wait end of event (miss branch)
//    CONTEXT_STATE_KO_MSYNC                           , // wait completion of all memory operation
//    CONTEXT_STATE_KO_MSYNC_ISSUE                     , // issue msync operation
      CONTEXT_STATE_KO_MSYNC_EXEC                      , // wait completion of     msync  operation
//    CONTEXT_STATE_KO_PSYNC                           , // wait completion of all        operation and after flush pipeline
      CONTEXT_STATE_KO_PSYNC_FLUSH                     , // wait completion of all 
      CONTEXT_STATE_KO_PSYNC_ADDR                      , // wait completion of all 
//    CONTEXT_STATE_KO_CSYNC                           , // wait completion of all        operation and after flush pipeline and flush ALL units (MMU, cache ...)
      CONTEXT_STATE_KO_CSYNC_FLUSH                     ,
      CONTEXT_STATE_KO_CSYNC_ADDR                      ,
//    CONTEXT_STATE_KO_SPR                             , // wait completion of all        operation
//    CONTEXT_STATE_KO_SPR_ISSUE                       , // issue spr's access
      CONTEXT_STATE_KO_SPR_EXEC                          // wait completion of all        operation (spr access)
    } context_state_t;


}; // end namespace context_state
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core
}; // end namespace behavioural

  template<> inline std::string toString<morpheo::behavioural::core::multi_front_end::front_end::context_state::context_state_t>(const morpheo::behavioural::core::multi_front_end::front_end::context_state::context_state_t& x)
  {
    switch (x)
      {
      case morpheo::behavioural::core::multi_front_end::front_end::context_state::CONTEXT_STATE_OK                                  : return "context_state_ok"                                 ; break;
      case morpheo::behavioural::core::multi_front_end::front_end::context_state::CONTEXT_STATE_KO_EXCEP                            : return "context_state_ko_excep"                           ; break;
      case morpheo::behavioural::core::multi_front_end::front_end::context_state::CONTEXT_STATE_KO_EXCEP_ADDR                       : return "context_state_ko_excep_addr"                      ; break;
      case morpheo::behavioural::core::multi_front_end::front_end::context_state::CONTEXT_STATE_KO_EXCEP_SPR                        : return "context_state_ko_excep_spr"                       ; break;
      case morpheo::behavioural::core::multi_front_end::front_end::context_state::CONTEXT_STATE_KO_MISS_BRANCH_WAIT_UPDATE          : return "context_state_ko_miss_branch_wait_update"         ; break;
      case morpheo::behavioural::core::multi_front_end::front_end::context_state::CONTEXT_STATE_KO_MISS_BRANCH_ADDR                 : return "context_state_ko_miss_branch_addr"                ; break;
      case morpheo::behavioural::core::multi_front_end::front_end::context_state::CONTEXT_STATE_KO_MISS_BRANCH_WAITEND              : return "context_state_ko_miss_branch_waitend"             ; break;
      case morpheo::behavioural::core::multi_front_end::front_end::context_state::CONTEXT_STATE_KO_MISS_LOAD_AND_BRANCH_WAIT_UPDATE : return "context_state_ko_miss_load_and_branch_wait_update"; break;
      case morpheo::behavioural::core::multi_front_end::front_end::context_state::CONTEXT_STATE_KO_MISS_LOAD_AND_BRANCH_ADDR        : return "context_state_ko_miss_load_and_branch_addr"       ; break;
      case morpheo::behavioural::core::multi_front_end::front_end::context_state::CONTEXT_STATE_KO_MISS_LOAD_AND_BRANCH_WAITEND     : return "context_state_ko_miss_load_and_branch_waitend"    ; break;
      case morpheo::behavioural::core::multi_front_end::front_end::context_state::CONTEXT_STATE_KO_MISS_LOAD_ADDR                   : return "context_state_ko_miss_load_addr"                  ; break;
      case morpheo::behavioural::core::multi_front_end::front_end::context_state::CONTEXT_STATE_KO_MISS_LOAD_WAITEND                : return "context_state_ko_miss_load_waitend"               ; break;
//    case morpheo::behavioural::core::multi_front_end::front_end::context_state::CONTEXT_STATE_KO_MSYNC                            : return "context_state_ko_msync"                           ; break;
//    case morpheo::behavioural::core::multi_front_end::front_end::context_state::CONTEXT_STATE_KO_MSYNC_ISSUE                      : return "context_state_ko_msync_issue"                     ; break;
      case morpheo::behavioural::core::multi_front_end::front_end::context_state::CONTEXT_STATE_KO_MSYNC_EXEC                       : return "context_state_ko_msync_exec"                      ; break;
//    case morpheo::behavioural::core::multi_front_end::front_end::context_state::CONTEXT_STATE_KO_PSYNC                            : return "context_state_ko_psync"                           ; break;
      case morpheo::behavioural::core::multi_front_end::front_end::context_state::CONTEXT_STATE_KO_PSYNC_FLUSH                      : return "context_state_ko_psync_flush"                     ; break;
      case morpheo::behavioural::core::multi_front_end::front_end::context_state::CONTEXT_STATE_KO_PSYNC_ADDR                       : return "context_state_ko_psync_addr"                      ; break;
//    case morpheo::behavioural::core::multi_front_end::front_end::context_state::CONTEXT_STATE_KO_CSYNC                            : return "context_state_ko_csync"                           ; break;
      case morpheo::behavioural::core::multi_front_end::front_end::context_state::CONTEXT_STATE_KO_CSYNC_FLUSH                      : return "context_state_ko_csync_flush"                     ; break;
      case morpheo::behavioural::core::multi_front_end::front_end::context_state::CONTEXT_STATE_KO_CSYNC_ADDR                       : return "context_state_ko_csync_addr"                      ; break;
//    case morpheo::behavioural::core::multi_front_end::front_end::context_state::CONTEXT_STATE_KO_SPR                              : return "context_state_ko_spr"                             ; break;
//    case morpheo::behavioural::core::multi_front_end::front_end::context_state::CONTEXT_STATE_KO_SPR_ISSUE                        : return "context_state_ko_spr_issue"                       ; break;
      case morpheo::behavioural::core::multi_front_end::front_end::context_state::CONTEXT_STATE_KO_SPR_EXEC                         : return "context_state_ko_spr_exec"                        ; break;
      default    : return ""      ; break;
      }
  };

}; // end namespace morpheo              

#endif
