#ifndef ENVIRONMENT_SIM2OS_H
#define ENVIRONMENT_SIM2OS_H

#include <iostream>
#include <map>
#include <stdarg.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "Sim2OS_Parameters.h"
#include "Service_conversion.h"
#include "../../Endianness/include/Endianness.h"
namespace environment {
namespace sim2os {

  class Sim2OS
  {
  private : std::string               name;
  private : Parameters *              param;
  private : service_t                 num_service;    // number of service
  private : std::map<uint32_t,void *> arguments;
  private : uint32_t                  nb_cycle;
  public  : void *                    result;
  public  : int                       error; // It's errno
    
  public  :  Sim2OS (std::string  name,
		     Parameters * param);
  public  : ~Sim2OS (void);

  public  : void                 reset              (void);

  private : bool                 have_all_arguments (uint32_t);
  private : void *               convert_address    (void *);
    
  private : void *               service_open       (void);
  private : void *               service_close      (void);
  private : void *               service_read       (void);
  private : void *               service_write      (void);
  private : void *               service_time       (void);
  private : void *               service_clock      (void);
  private : void *               service_lseek      (void);

  public  : void *               execute            (void);
  public  : void *               execute            (service_t);
  public  : void *               execute            (service_t, void *, ...);
  public  : void                 parameter          (uint32_t, void *);
  public  : void                 transition         (void);
  public  : friend std::ostream& operator<<         (std::ostream&, Sim2OS&);
  };

};
};
#endif
