#ifdef SYSTEMC
/*
 * $Id: Core_Glue_genMealy_issue.cpp 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Core_Glue/include/Core_Glue.h"
#include "Common/include/Max.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace core_glue {


#undef  FUNCTION
#define FUNCTION "Core_Glue::genMealy_issue"
  void Core_Glue::genMealy_issue (void)
  {
    log_begin(Core_Glue,FUNCTION);
    log_function(Core_Glue,FUNCTION,_name.c_str());

    Tcontrol_t ISSUE_OOO_ENGINE_ACK   [_param->_nb_ooo_engine  ][_param->_max_nb_inst_issue];
    Tcontrol_t ISSUE_EXECUTE_LOOP_VAL [_param->_nb_execute_loop][_param->_max_nb_read_unit ];
    bool       READ_UNIT_ENABLE       [_param->_nb_execute_loop][_param->_max_nb_read_unit ];

    for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
      for (uint32_t j=0; j<_param->_nb_inst_issue[i]; ++j)
        ISSUE_OOO_ENGINE_ACK [i][j] = 0;
    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_param->_nb_read_unit[i]; ++j)
        {
          ISSUE_EXECUTE_LOOP_VAL [i][j] = 0;
          // Read unit is enable is signal ack is set
          READ_UNIT_ENABLE       [i][j] = (PORT_READ(in_ISSUE_EXECUTE_LOOP_ACK [i][j]) == 1);
        }

    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
      {
        log_printf(TRACE,Core_Glue,FUNCTION,"  * execute_loop [%d]",i);

        std::list<generic::priority::select_t> * select_ooo_engine = _priority_ooo_engine[i]->select();
        for (std::list<generic::priority::select_t>::iterator it_ooo_engine=select_ooo_engine->begin();
             it_ooo_engine!=select_ooo_engine->end();
             ++it_ooo_engine)
          {
            const uint32_t ooo_engine_id  = it_ooo_engine->grp;
            const uint32_t num_ooo_engine = _param->_translate_execute_loop_num_ooo_engine [i][ooo_engine_id];
            const uint32_t num_inst_issue = it_ooo_engine->elt;

            log_printf(TRACE,Core_Glue,FUNCTION,"    * num_ooo_engine [%d] (id : %d)",num_ooo_engine, ooo_engine_id);
            log_printf(TRACE,Core_Glue,FUNCTION,"    * num_inst_issue          : %d",num_inst_issue);
            log_printf(TRACE,Core_Glue,FUNCTION,"    * ISSUE_OOO_ENGINE_VAL    : %d",PORT_READ(in_ISSUE_OOO_ENGINE_VAL [num_ooo_engine][num_inst_issue]));

            // have request ?
            Tcontrol_t ooo_engine_val = PORT_READ(in_ISSUE_OOO_ENGINE_VAL [num_ooo_engine][num_inst_issue]);

//             if (ooo_engine_val)
              {
//              // If ooo_engine can issue instruction on multiple execute_loop
//              if (not ISSUE_OOO_ENGINE_ACK [num_ooo_engine][num_inst_issue])

                std::list<generic::priority::select_t> * select_read_unit = _priority_read_unit[i]->select();
                for (std::list<generic::priority::select_t>::iterator it_read_unit=select_read_unit->begin();
                     it_read_unit!=select_read_unit->end();
                     ++it_read_unit)
                  {
                    uint32_t num_read_unit = it_read_unit->grp;

                  // Test if have an link and read unit is enable
                  log_printf(TRACE,Core_Glue,FUNCTION,"    * read_unit               : %d",num_read_unit);
                  log_printf(TRACE,Core_Glue,FUNCTION,"      * READ_UNIT_ENABLE      : %d",READ_UNIT_ENABLE [i][num_read_unit]);
                  log_printf(TRACE,Core_Glue,FUNCTION,"      * table_dispatch        : %d",_param->_table_dispatch [num_ooo_engine][num_inst_issue][i][num_read_unit]);

                  Tcontrol_t read_unit_enable = READ_UNIT_ENABLE [i][num_read_unit];
                  if (read_unit_enable and 
                      _param->_table_dispatch [num_ooo_engine][num_inst_issue][i][num_read_unit])
                    {
                      // Transaction
                      ISSUE_EXECUTE_LOOP_VAL [i][num_read_unit] = ooo_engine_val;
                      ISSUE_OOO_ENGINE_ACK   [num_ooo_engine][num_inst_issue] = read_unit_enable; // = 1
                      READ_UNIT_ENABLE       [i][num_read_unit] = false; // now, this read_unit is busy

                      if (_param->_have_port_context_id)
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_CONTEXT_ID            [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_CONTEXT_ID            [num_ooo_engine][num_inst_issue]));
                      if (_param->_have_port_front_end_id)
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_FRONT_END_ID          [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_FRONT_END_ID          [num_ooo_engine][num_inst_issue]));
                      if (_param->_have_port_ooo_engine_id)
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_OOO_ENGINE_ID         [i][num_read_unit],ooo_engine_id);
                      if (_param->_have_port_rob_ptr)
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_PACKET_ID             [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_PACKET_ID             [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_OPERATION             [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_OPERATION             [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_TYPE                  [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_TYPE                  [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_STORE_QUEUE_PTR_WRITE [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_STORE_QUEUE_PTR_WRITE [num_ooo_engine][num_inst_issue]));
                      if (_param->_have_port_load_queue_ptr)
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_LOAD_QUEUE_PTR_WRITE  [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_LOAD_QUEUE_PTR_WRITE  [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_HAS_IMMEDIAT          [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_HAS_IMMEDIAT          [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_IMMEDIAT              [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_IMMEDIAT              [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_READ_RA               [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_READ_RA               [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_NUM_REG_RA            [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_NUM_REG_RA            [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_READ_RB               [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_READ_RB               [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_NUM_REG_RB            [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_NUM_REG_RB            [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_READ_RC               [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_READ_RC               [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_NUM_REG_RC            [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_NUM_REG_RC            [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_WRITE_RD              [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_WRITE_RD              [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_NUM_REG_RD            [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_NUM_REG_RD            [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_WRITE_RE              [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_WRITE_RE              [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_NUM_REG_RE            [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_NUM_REG_RE            [num_ooo_engine][num_inst_issue]));
                    }            
                  }
              }
          }
      }

    // Write output
    for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
      for (uint32_t j=0; j<_param->_nb_inst_issue[i]; ++j)
        PORT_WRITE(out_ISSUE_OOO_ENGINE_ACK [i][j], ISSUE_OOO_ENGINE_ACK [i][j]);
    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_param->_nb_read_unit[i]; ++j)
        PORT_WRITE(out_ISSUE_EXECUTE_LOOP_VAL [i][j], ISSUE_EXECUTE_LOOP_VAL [i][j]);

    log_end(Core_Glue,FUNCTION);
  };

}; // end namespace core_glue
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
