/*
 * $Id: Parameters.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Direction_Glue/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {
namespace direction_glue {

#undef  FUNCTION
#define FUNCTION "Direction_Glue::Parameters"
  Parameters::Parameters (Tpredictor_t predictor_scheme,
			  uint32_t     nb_inst_predict ,
			  uint32_t     nb_inst_update  ,
			  uint32_t     size_address    ,
			  uint32_t     size_history    ,
                          bool         is_toplevel     )
  {
    log_printf(FUNC,Direction_Glue,FUNCTION,"Begin");

    _predictor_scheme = predictor_scheme;
    _nb_inst_predict  = nb_inst_predict ;
    _nb_inst_update   = nb_inst_update  ;

    switch (predictor_scheme)
      {
      case PREDICTOR_NEVER_TAKE  :
      case PREDICTOR_ALWAYS_TAKE :
      case PREDICTOR_STATIC      :
      case PREDICTOR_LAST_TAKE   :
	{
	  _have_component_meta_predictor = false;
	  break;
	}
      case PREDICTOR_COUNTER     :
      case PREDICTOR_LOCAL       :
      case PREDICTOR_GLOBAL      :
      case PREDICTOR_META        :
      case PREDICTOR_CUSTOM      :
	{
	  _have_component_meta_predictor = true;
	  break;
	}
      }

    _size_history      = (_have_component_meta_predictor)?size_history:0;

    _have_port_history = (_size_history>0);

    test();

    if (is_toplevel)
      {
        _size_instruction_address = size_address;

        copy();
      }

    log_printf(FUNC,Direction_Glue,FUNCTION,"End");
  };
  
// #undef  FUNCTION
// #define FUNCTION "Direction_Glue::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_printf(FUNC,Direction_Glue,FUNCTION,"Begin");
//     test();
//     log_printf(FUNC,Direction_Glue,FUNCTION,"End");
//   };

#undef  FUNCTION
#define FUNCTION "Direction_Glue::~Parameters"
  Parameters::~Parameters () 
  {
    log_printf(FUNC,Direction_Glue,FUNCTION,"Begin");
    log_printf(FUNC,Direction_Glue,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Direction_Glue::copy"
  void Parameters::copy (void) 
  {
    log_printf(FUNC,Direction_Glue,FUNCTION,"Begin");
    log_printf(FUNC,Direction_Glue,FUNCTION,"End");
  };



}; // end namespace direction_glue
}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
