#ifndef morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_direction_meta_predictor_two_level_branch_predictor_Two_Level_Branch_Predictor_h
#define morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_direction_meta_predictor_two_level_branch_predictor_Two_Level_Branch_Predictor_h

/*
 * $Id: Two_Level_Branch_Predictor.h 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif


#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/include/Parameters.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include <iostream>

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {
namespace meta_predictor {
namespace two_level_branch_predictor {


  class Two_Level_Branch_Predictor 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_VAL          ;//[nb_inst_predict]
  public    : SC_OUT(Tcontrol_t)           ** out_PREDICT_ACK          ;//[nb_inst_predict]
  public    : SC_IN (Taddress_t)           **  in_PREDICT_ADDRESS      ;//[nb_inst_predict]
  public    : SC_OUT(Tcontrol_t)           ** out_PREDICT_DIRECTION    ;//[nb_inst_predict] // = MSB[history]
  public    : SC_OUT(Thistory_t)           ** out_PREDICT_HISTORY      ;//[nb_inst_predict]
  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_DIRECTION_VAL;//[nb_inst_predict] // if update_on_prediction
  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_DIRECTION    ;//[nb_inst_predict] // if update_on_prediction

    // ~~~~~[ Interface : "update" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t)           **  in_UPDATE_VAL           ;//[nb_inst_update]
  public    : SC_OUT(Tcontrol_t)           ** out_UPDATE_ACK           ;//[nb_inst_update]
  public    : SC_IN (Taddress_t)           **  in_UPDATE_ADDRESS       ;//[nb_inst_update]
  public    : SC_IN (Thistory_t)           **  in_UPDATE_HISTORY       ;//[nb_inst_update]
  public    : SC_IN (Tcontrol_t)           **  in_UPDATE_HISTORY_VAL   ;//[nb_inst_update]
  public    : SC_IN (Tcontrol_t)           **  in_UPDATE_DIRECTION     ;//[nb_inst_update]
  public    : SC_IN (Tcontrol_t)           **  in_UPDATE_MISS          ;//[nb_inst_update] // if update_on_prediction

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    
    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : Thistory_t                    * reg_BHT                       ;//[bht_nb_shifter]
  private   : Thistory_t                   ** reg_PHT                       ;//[pht_nb_counter][pht_nb_bank]

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  private   : Tcontrol_t                    * internal_PREDICT_ACK          ;//[nb_inst_predict]
  private   : Thistory_t                    * internal_PREDICT_BHT_NUM_REG  ;//[nb_inst_predict] // if update_on_prediction
  private   : Thistory_t                    * internal_PREDICT_PHT_NUM_BANK ;//[nb_inst_predict] // if update_on_prediction
  private   : Thistory_t                    * internal_PREDICT_PHT_NUM_REG  ;//[nb_inst_predict] // if update_on_prediction

  private   : Tcontrol_t                    * internal_UPDATE_ACK           ;//[nb_inst_update]
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Two_Level_Branch_Predictor);
#endif
  public  :          Two_Level_Branch_Predictor              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Two_Level_Branch_Predictor             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        transition                (void);
  public  : void        genMealy_predict          (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
