#ifdef SYSTEMC
/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Update_Prediction_Table/include/Update_Prediction_Table.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace update_prediction_table {


#undef  FUNCTION
#define FUNCTION "Update_Prediction_Table::genMealy_decod"
  void Update_Prediction_Table::genMealy_decod (void)
  {
    log_begin(Update_Prediction_Table,FUNCTION);
    log_function(Update_Prediction_Table,FUNCTION,_name.c_str());
    
    // WARNING : One branch per context per cycle
    if (PORT_READ(in_NRESET) != 0)
      {
    for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
      {
        log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * DECOD [%d]",i);

        Tcontext_t    context     = (_param->_have_port_context_id)?PORT_READ(in_DECOD_CONTEXT_ID [i]):0;
        bool          is_accurate = reg_IS_ACCURATE [context];
        event_state_t event_state = reg_EVENT_STATE [context];
        uint32_t      ptr_write   = reg_UPT_TOP     [context];
        // can continue if next slot is empty
        Tcontrol_t    can_continue= ((reg_UPDATE_PREDICTION_TABLE [context][(reg_UPT_TOP [context]+1)%_param->_size_upt_queue[context]]._state == UPDATE_PREDICTION_STATE_EMPTY) and 
                                     (reg_EVENT_STATE [context] == EVENT_STATE_OK));

        log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * context     : %d",context    );
        log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * is_accurate : %d",is_accurate);
        log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * event_state : %s",toString(event_state).c_str());
        log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * ptr_write   : %d",ptr_write  );
        log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * upt_state   : %s",toString(reg_UPDATE_PREDICTION_TABLE [context][ptr_write]._state).c_str());
        log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * can_continue: %d",can_continue);

        // ack :
        //   * in all case (miss or hit), need empty slot
        //   * is_accurate
        //   * event_state : don't update upt
        internal_DECOD_ACK           [i] = ((reg_UPDATE_PREDICTION_TABLE [context][ptr_write]._state == UPDATE_PREDICTION_STATE_EMPTY) and
                                            is_accurate and
//                                             (
                                             (event_state == EVENT_STATE_OK)//  or
//                                              (event_state == EVENT_STATE_MISS_FLUSH_UFPT    ) or
//                                              (event_state == EVENT_STATE_UPDATE_CONTEXT))
                                            );
        internal_DECOD_UPT_PTR_WRITE [i] = ptr_write;

        log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * ack         : %d",internal_DECOD_ACK [i]);

	PORT_WRITE(out_DECOD_ACK          [i], internal_DECOD_ACK [i]);
	PORT_WRITE(out_DECOD_CAN_CONTINUE [i], can_continue);
      }
      }
    log_end(Update_Prediction_Table,FUNCTION);
  };

}; // end namespace update_prediction_table
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
