/*
 * $Id: Dependency_checking_unit_allocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Dependency_checking_unit/include/Dependency_checking_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace dependency_checking_unit {



#undef  FUNCTION
#define FUNCTION "Dependency_checking_unit::allocation"
  void Dependency_checking_unit::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_printf(FUNC,Dependency_checking_unit,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Dependency_checking_unit"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 _("Generalist interface")
#endif
							 );

     in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
     in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);

    // ~~~~~[ Interface "rename_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE_BEGIN("rename_in", IN, EAST, _("Registers before near dependency checking"), _param->_nb_inst_insert);
       
//     ALLOC1_VALACK_IN ( in_RENAME_IN_VAL               ,VAL);
//     ALLOC1_VALACK_OUT(out_RENAME_IN_ACK               ,ACK);
       ALLOC1_SIGNAL_IN ( in_RENAME_IN_FRONT_END_ID      ,"front_end_id"      ,Tcontext_t        ,_param->_size_front_end_id          );
       ALLOC1_SIGNAL_IN ( in_RENAME_IN_CONTEXT_ID        ,"context_id"        ,Tcontext_t        ,_param->_size_context_id            );
       ALLOC1_SIGNAL_IN ( in_RENAME_IN_READ_RA           ,"read_ra"           ,Tcontrol_t        ,1                                   );
       ALLOC1_SIGNAL_IN ( in_RENAME_IN_NUM_REG_RA_LOG    ,"num_reg_ra_log"    ,Tgeneral_address_t,_param->_size_general_register_logic);
       ALLOC1_SIGNAL_IN ( in_RENAME_IN_NUM_REG_RA_PHY    ,"num_reg_ra_phy"    ,Tgeneral_address_t,_param->_size_general_register      );
       ALLOC1_SIGNAL_IN ( in_RENAME_IN_READ_RB           ,"read_rb"           ,Tcontrol_t        ,1                                   );
       ALLOC1_SIGNAL_IN ( in_RENAME_IN_NUM_REG_RB_LOG    ,"num_reg_rb_log"    ,Tgeneral_address_t,_param->_size_general_register_logic);
       ALLOC1_SIGNAL_IN ( in_RENAME_IN_NUM_REG_RB_PHY    ,"num_reg_rb_phy"    ,Tgeneral_address_t,_param->_size_general_register      );
       ALLOC1_SIGNAL_IN ( in_RENAME_IN_READ_RC           ,"read_rc"           ,Tcontrol_t        ,1                                   );
       ALLOC1_SIGNAL_IN ( in_RENAME_IN_NUM_REG_RC_LOG    ,"num_reg_rc_log"    ,Tspecial_address_t,_param->_size_special_register_logic);
       ALLOC1_SIGNAL_IN ( in_RENAME_IN_NUM_REG_RC_PHY    ,"num_reg_rc_phy"    ,Tspecial_address_t,_param->_size_special_register      );
       ALLOC1_SIGNAL_IN ( in_RENAME_IN_WRITE_RD          ,"write_rd"          ,Tcontrol_t        ,1                                   );
       ALLOC1_SIGNAL_IN ( in_RENAME_IN_NUM_REG_RD_LOG    ,"num_reg_rd_log"    ,Tgeneral_address_t,_param->_size_general_register_logic);
       ALLOC1_SIGNAL_IN ( in_RENAME_IN_NUM_REG_RD_PHY_OLD,"num_reg_rd_phy_old",Tgeneral_address_t,_param->_size_general_register      );
       ALLOC1_SIGNAL_IN ( in_RENAME_IN_NUM_REG_RD_PHY_NEW,"num_reg_rd_phy_new",Tgeneral_address_t,_param->_size_general_register      );
       ALLOC1_SIGNAL_IN ( in_RENAME_IN_WRITE_RE          ,"write_re"          ,Tcontrol_t        ,1                                   );
       ALLOC1_SIGNAL_IN ( in_RENAME_IN_NUM_REG_RE_LOG    ,"num_reg_re_log"    ,Tspecial_address_t,_param->_size_special_register_logic);
       ALLOC1_SIGNAL_IN ( in_RENAME_IN_NUM_REG_RE_PHY_OLD,"num_reg_re_phy_old",Tspecial_address_t,_param->_size_special_register      );
       ALLOC1_SIGNAL_IN ( in_RENAME_IN_NUM_REG_RE_PHY_NEW,"num_reg_re_phy_new",Tspecial_address_t,_param->_size_special_register      );

       ALLOC1_INTERFACE_END(_param->_nb_inst_insert);
     }

    // ~~~~~[ Interface "rename_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE_BEGIN("rename_out", OUT, WEST, _("Registers after near dependency checking"), _param->_nb_inst_insert);
       
//     ALLOC1_VALACK_OUT(out_RENAME_OUT_VAL               ,VAL);
//     ALLOC1_VALACK_IN ( in_RENAME_OUT_ACK               ,ACK);
       ALLOC1_SIGNAL_OUT(out_RENAME_OUT_FRONT_END_ID      ,"front_end_id"      ,Tcontext_t        ,_param->_size_front_end_id          );
       ALLOC1_SIGNAL_OUT(out_RENAME_OUT_CONTEXT_ID        ,"context_id"        ,Tcontext_t        ,_param->_size_context_id            );
       ALLOC1_SIGNAL_OUT(out_RENAME_OUT_READ_RA           ,"read_ra"           ,Tcontrol_t        ,1                                   );
       ALLOC1_SIGNAL_OUT(out_RENAME_OUT_NUM_REG_RA_LOG    ,"num_reg_ra_log"    ,Tgeneral_address_t,_param->_size_general_register_logic);
       ALLOC1_SIGNAL_OUT(out_RENAME_OUT_NUM_REG_RA_PHY    ,"num_reg_ra_phy"    ,Tgeneral_address_t,_param->_size_general_register      );
       ALLOC1_SIGNAL_OUT(out_RENAME_OUT_READ_RB           ,"read_rb"           ,Tcontrol_t        ,1                                   );
       ALLOC1_SIGNAL_OUT(out_RENAME_OUT_NUM_REG_RB_LOG    ,"num_reg_rb_log"    ,Tgeneral_address_t,_param->_size_general_register_logic);
       ALLOC1_SIGNAL_OUT(out_RENAME_OUT_NUM_REG_RB_PHY    ,"num_reg_rb_phy"    ,Tgeneral_address_t,_param->_size_general_register      );
       ALLOC1_SIGNAL_OUT(out_RENAME_OUT_READ_RC           ,"read_rc"           ,Tcontrol_t        ,1                                   );
       ALLOC1_SIGNAL_OUT(out_RENAME_OUT_NUM_REG_RC_LOG    ,"num_reg_rc_log"    ,Tspecial_address_t,_param->_size_special_register_logic);
       ALLOC1_SIGNAL_OUT(out_RENAME_OUT_NUM_REG_RC_PHY    ,"num_reg_rc_phy"    ,Tspecial_address_t,_param->_size_special_register      );
       ALLOC1_SIGNAL_OUT(out_RENAME_OUT_WRITE_RD          ,"write_rd"          ,Tcontrol_t        ,1                                   );
       ALLOC1_SIGNAL_OUT(out_RENAME_OUT_NUM_REG_RD_LOG    ,"num_reg_rd_log"    ,Tgeneral_address_t,_param->_size_general_register_logic);
       ALLOC1_SIGNAL_OUT(out_RENAME_OUT_NUM_REG_RD_PHY_OLD,"num_reg_rd_phy_old",Tgeneral_address_t,_param->_size_general_register      );
       ALLOC1_SIGNAL_OUT(out_RENAME_OUT_NUM_REG_RD_PHY_NEW,"num_reg_rd_phy_new",Tgeneral_address_t,_param->_size_general_register      );
       ALLOC1_SIGNAL_OUT(out_RENAME_OUT_WRITE_RE          ,"write_re"          ,Tcontrol_t        ,1                                   );
       ALLOC1_SIGNAL_OUT(out_RENAME_OUT_NUM_REG_RE_LOG    ,"num_reg_re_log"    ,Tspecial_address_t,_param->_size_special_register_logic);
       ALLOC1_SIGNAL_OUT(out_RENAME_OUT_NUM_REG_RE_PHY_OLD,"num_reg_re_phy_old",Tspecial_address_t,_param->_size_special_register      );
       ALLOC1_SIGNAL_OUT(out_RENAME_OUT_NUM_REG_RE_PHY_NEW,"num_reg_re_phy_new",Tspecial_address_t,_param->_size_special_register      );

       ALLOC1_INTERFACE_END(_param->_nb_inst_insert);
     }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
     if (usage_is_set(_usage,USE_POSITION))
       _component->generate_file();
#endif

    log_printf(FUNC,Dependency_checking_unit,FUNCTION,"End");
  };

}; // end namespace dependency_checking_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
