/*
 * $Id: Core_allocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/include/Core.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {



#undef  FUNCTION
#define FUNCTION "Core::allocation"
  void Core::allocation 
  (
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
   void
#endif
   )
  {
    log_begin(Core,FUNCTION);

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Core"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();
    
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface "icache_req" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("icache_req",WEST,OUT,_("Request to instruction cache"),_param->_nb_icache_port);

      ALLOC1_VALACK_OUT(out_ICACHE_REQ_VAL         ,VAL);
      ALLOC1_VALACK_IN ( in_ICACHE_REQ_ACK         ,ACK);
      ALLOC1_SIGNAL_OUT(out_ICACHE_REQ_THREAD_ID   ,"thread_id",Tcontext_t           ,_param->_size_icache_thread_id);
      ALLOC1_SIGNAL_OUT(out_ICACHE_REQ_PACKET_ID   ,"packet_id",Tpacket_t            ,_param->_size_icache_packet_id);
      ALLOC1_SIGNAL_OUT(out_ICACHE_REQ_ADDRESS     ,"address"  ,Ticache_address_t    ,_param->_size_icache_address  );
      ALLOC1_SIGNAL_OUT(out_ICACHE_REQ_TYPE        ,"type"     ,Ticache_type_t       ,_param->_size_icache_type     );

      ALLOC1_INTERFACE_END(_param->_nb_icache_port);
    }
									    
    // ~~~~~[ Interface "icache_rsp" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("icache_rsp",WEST,IN ,_("Respons from instruction cache"),_param->_nb_icache_port);
      
      ALLOC1_VALACK_IN ( in_ICACHE_RSP_VAL         ,VAL);
      ALLOC1_VALACK_OUT(out_ICACHE_RSP_ACK         ,ACK);
      ALLOC1_SIGNAL_IN ( in_ICACHE_RSP_THREAD_ID   ,"thread_id"  ,Tcontext_t           ,_param->_size_icache_thread_id);
      ALLOC1_SIGNAL_IN ( in_ICACHE_RSP_PACKET_ID   ,"packet_id"  ,Tpacket_t            ,_param->_size_icache_packet_id);
      ALLOC1_SIGNAL_IN ( in_ICACHE_RSP_ERROR       ,"error"      ,Ticache_error_t      ,_param->_size_icache_error);

      ALLOC1_INTERFACE_END(_param->_nb_icache_port);
    }
    {
      ALLOC2_INTERFACE_BEGIN("icache_rsp",WEST,IN ,_("Respons from instruction cache"),_param->_nb_icache_port,_param->_icache_nb_instruction[it1]);
      
      _ALLOC2_SIGNAL_IN ( in_ICACHE_RSP_INSTRUCTION ,"instruction",Ticache_instruction_t,_param->_size_instruction,_param->_nb_icache_port,_param->_icache_nb_instruction[it1]);

      ALLOC2_INTERFACE_END(_param->_nb_icache_port,_param->_icache_nb_instruction[it1]);
    }

    // ~~~~~[ Interface "dcache_req" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("dcache_req", OUT, NORTH, _("Request to data cache"),_param->_nb_dcache_port);
      
      ALLOC1_VALACK_OUT(out_DCACHE_REQ_VAL         ,VAL);
      ALLOC1_VALACK_IN ( in_DCACHE_REQ_ACK         ,ACK);
      ALLOC1_SIGNAL_OUT(out_DCACHE_REQ_THREAD_ID   ,"thread_id",Tcontext_t           ,_param->_size_dcache_thread_id);
      ALLOC1_SIGNAL_OUT(out_DCACHE_REQ_PACKET_ID   ,"packet_id",Tpacket_t            ,_param->_size_dcache_packet_id);
      ALLOC1_SIGNAL_OUT(out_DCACHE_REQ_ADDRESS     ,"address"  ,Tdcache_address_t    ,_param->_size_dcache_address);
      ALLOC1_SIGNAL_OUT(out_DCACHE_REQ_WDATA       ,"wdata"    ,Tdcache_data_t       ,_param->_size_dcache_data);
      ALLOC1_SIGNAL_OUT(out_DCACHE_REQ_TYPE        ,"type"     ,Tdcache_type_t       ,_param->_size_dcache_type);

      ALLOC1_INTERFACE_END(_param->_nb_dcache_port);
    }
									    
    // ~~~~~[ Interface "dcache_rsp" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  
    {
      ALLOC1_INTERFACE_BEGIN("dcache_rsp", IN , NORTH, _("Respons from data cache"),_param->_nb_dcache_port);

      ALLOC1_VALACK_IN ( in_DCACHE_RSP_VAL         ,VAL);
      ALLOC1_VALACK_OUT(out_DCACHE_RSP_ACK         ,ACK);
      ALLOC1_SIGNAL_IN ( in_DCACHE_RSP_THREAD_ID   ,"thread_id",Tcontext_t           ,_param->_size_dcache_thread_id);
      ALLOC1_SIGNAL_IN ( in_DCACHE_RSP_PACKET_ID   ,"packet_id",Tpacket_t            ,_param->_size_dcache_packet_id);
      ALLOC1_SIGNAL_IN ( in_DCACHE_RSP_RDATA       ,"rdata"    ,Tdcache_data_t       ,_param->_size_dcache_data);
      ALLOC1_SIGNAL_IN ( in_DCACHE_RSP_ERROR       ,"error"    ,Tdcache_error_t      ,_param->_size_dcache_error);

      ALLOC1_INTERFACE_END(_param->_nb_dcache_port);
    }

    // ~~~~~[ Interface : "interrupt" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("interrupt", IN , NORTH, _("Interruption line"),_param->_nb_thread);

      ALLOC1_SIGNAL_IN ( in_INTERRUPT_ENABLE      ,"enable",Tcontrol_t           ,1);

      ALLOC1_INTERFACE_END(_param->_nb_thread);
    }
    
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    std::string name;

    _component_front_end = new core::multi_front_end::front_end::Front_end * [_param->_nb_front_end];
    for (uint32_t i=0; i<_param->_nb_front_end; ++i)
      {
        name = _name+"_front_end_"+toString(i);
        log_printf(INFO,Core,FUNCTION,_("Create   : %s"),name.c_str());
      
        _component_front_end [i] = new core::multi_front_end::front_end::Front_end
          (name.c_str()
#ifdef STATISTICS
           ,param_statistics
#endif
           ,_param->_param_front_end [i]
           ,_usage);
        
        _component->set_component (_component_front_end[i]->_component
#ifdef POSITION
                                   , 50, 50, 10, 10
#endif
                                   );
      }

    _component_ooo_engine = new core::multi_ooo_engine::ooo_engine::OOO_Engine * [_param->_nb_ooo_engine];
    for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
      {
        name = _name+"_ooo_engine_"+toString(i);
        log_printf(INFO,Core,FUNCTION,_("Create   : %s"),name.c_str());
      
        _component_ooo_engine [i] = new core::multi_ooo_engine::ooo_engine::OOO_Engine
          (name.c_str()
#ifdef STATISTICS
           ,param_statistics
#endif
           ,_param->_param_ooo_engine [i]
           ,_usage);
        
        _component->set_component (_component_ooo_engine[i]->_component
#ifdef POSITION
                                   , 50, 50, 10, 10
#endif
                                   );
      }

    _component_execute_loop = new core::multi_execute_loop::execute_loop::Execute_loop * [_param->_nb_execute_loop];
    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
      {
        name = _name+"_execute_loop_"+toString(i);
        log_printf(INFO,Core,FUNCTION,_("Create   : %s"),name.c_str());
      
        _component_execute_loop [i] = new core::multi_execute_loop::execute_loop::Execute_loop
          (name.c_str()
#ifdef STATISTICS
           ,param_statistics
#endif
           ,_param->_param_execute_loop [i]
           ,_usage);
        
        _component->set_component (_component_execute_loop[i]->_component
#ifdef POSITION
                                   , 50, 50, 10, 10
#endif
                                   );
      }

    {
      name = _name+"_icache_access";
      log_printf(INFO,Core,FUNCTION,_("Create   : %s"),name.c_str());
      
      _component_icache_access = new morpheo::behavioural::core::icache_access::Icache_Access
        (name.c_str()
#ifdef STATISTICS
         ,param_statistics
#endif
         ,_param->_param_icache_access
         ,_usage);
      
      _component->set_component (_component_icache_access->_component
#ifdef POSITION
                                 , 50, 50, 10, 10
#endif
                                 );
    }

    {
      name = _name+"_dcache_access";
      log_printf(INFO,Core,FUNCTION,_("Create   : %s"),name.c_str());
      
      _component_dcache_access = new morpheo::behavioural::core::dcache_access::Dcache_Access
        (name.c_str()
#ifdef STATISTICS
         ,param_statistics
#endif
         ,_param->_param_dcache_access
         ,_usage);
      
      _component->set_component (_component_dcache_access->_component
#ifdef POSITION
                                 , 50, 50, 10, 10
#endif
                                 );
    }


    {
      name = _name+"_glue";
      log_printf(INFO,Core,FUNCTION,_("Create   : %s"),name.c_str());
      
      _component_glue = new morpheo::behavioural::core::core_glue::Core_Glue
        (name.c_str()
#ifdef STATISTICS
         ,param_statistics
#endif
         ,_param->_param_glue
         ,_usage);
      
      _component->set_component (_component_glue->_component
#ifdef POSITION
                                 , 50, 50, 10, 10
#endif
                                 );
    }
    
    // ~~~~~[ Instanciation ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    std::string src,dest;
    
    
    // ===================================================================
    // =====[ front_end ]=================================================
    // ===================================================================
    for (uint32_t i=0; i<_param->_nb_front_end; ++i)
      {
        src = _name+"_front_end_"+toString(i);
        log_printf(INFO,Core,FUNCTION,_("Instance : %s"),src.c_str());
        
        // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        {
          dest = _name;
#ifdef POSITION
          _component->interface_map (src ,"",
                                     dest,"");
#endif
          PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
          PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
        }

        // ~~~~~[ Interface "icache_req" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        // out_ICACHE_REQ_VAL       - icache_access. in_CONTEXT_REQ_VAL      
        //  in_ICACHE_REQ_ACK       - icache_access.out_CONTEXT_REQ_ACK      
//      // out_ICACHE_REQ_THREAD_ID - icache_access. in_CONTEXT_REQ_THREAD_ID
        // out_ICACHE_REQ_PACKET_ID - icache_access. in_CONTEXT_REQ_PACKET_ID
        // out_ICACHE_REQ_ADDRESS   - icache_access. in_CONTEXT_REQ_ADDRESS  
        // out_ICACHE_REQ_TYPE      - icache_access. in_CONTEXT_REQ_TYPE     
        
        // ~~~~~[ Interface "icache_rsp" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        //  in_ICACHE_RSP_VAL         - icache_access.out_CONTEXT_RSP_VAL        
        // out_ICACHE_RSP_ACK         - icache_access. in_CONTEXT_RSP_ACK        
//      //  in_ICACHE_RSP_THREAD_ID   - icache_access.out_CONTEXT_RSP_THREAD_ID  
        //  in_ICACHE_RSP_PACKET_ID   - icache_access.out_CONTEXT_RSP_PACKET_ID  
        //  in_ICACHE_RSP_INSTRUCTION - icache_access.out_CONTEXT_RSP_INSTRUCTION
        //  in_ICACHE_RSP_ERROR       - icache_access.out_CONTEXT_RSP_ERROR      

        // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        // out_DECOD_VAL           - ooo_engine. in_RENAME_VAL          
        //  in_DECOD_ACK           - ooo_engine.out_RENAME_ACK          
        // out_DECOD_CONTEXT_ID    - ooo_engine. in_RENAME_CONTEXT_ID   
        // out_DECOD_DEPTH         - ooo_engine. in_RENAME_DEPTH        
        // out_DECOD_TYPE          - ooo_engine. in_RENAME_TYPE         
        // out_DECOD_OPERATION     - ooo_engine. in_RENAME_OPERATION    
        // out_DECOD_NO_EXECUTE    - ooo_engine. in_RENAME_NO_EXECUTE   
        // out_DECOD_IS_DELAY_SLOT - ooo_engine. in_RENAME_IS_DELAY_SLOT
        // out_DECOD_ADDRESS       - ooo_engine. in_RENAME_ADDRESS      
        // out_DECOD_ADDRESS_NEXT  - ooo_engine. in_RENAME_ADDRESS_NEXT 
        // out_DECOD_HAS_IMMEDIAT  - ooo_engine. in_RENAME_HAS_IMMEDIAT 
        // out_DECOD_IMMEDIAT      - ooo_engine. in_RENAME_IMMEDIAT     
        // out_DECOD_READ_RA       - ooo_engine. in_RENAME_READ_RA      
        // out_DECOD_NUM_REG_RA    - ooo_engine. in_RENAME_NUM_REG_RA   
        // out_DECOD_READ_RB       - ooo_engine. in_RENAME_READ_RB      
        // out_DECOD_NUM_REG_RB    - ooo_engine. in_RENAME_NUM_REG_RB   
        // out_DECOD_READ_RC       - ooo_engine. in_RENAME_READ_RC      
        // out_DECOD_NUM_REG_RC    - ooo_engine. in_RENAME_NUM_REG_RC   
        // out_DECOD_WRITE_RD      - ooo_engine. in_RENAME_WRITE_RD     
        // out_DECOD_NUM_REG_RD    - ooo_engine. in_RENAME_NUM_REG_RD   
        // out_DECOD_WRITE_RE      - ooo_engine. in_RENAME_WRITE_RE     
        // out_DECOD_NUM_REG_RE    - ooo_engine. in_RENAME_NUM_REG_RE   
        // out_DECOD_EXCEPTION_USE - ooo_engine. in_RENAME_EXCEPTION_USE
        // out_DECOD_EXCEPTION     - ooo_engine. in_RENAME_EXCEPTION    

        // ~~~~~[ Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~
        for (uint32_t j=0; j<_param->_front_end_nb_inst_branch_complete[i]; ++j)
          {
            dest = _name+"_glue";
#ifdef POSITION
            _component->interface_map (src ,"branch_complete_"                          +toString(j),
                                       dest,"branch_complete_front_end_"+toString(i)+"_"+toString(j));
#endif

            COMPONENT_MAP(_component,src , "in_BRANCH_COMPLETE_"                          +toString(j)+"_VAL"            ,
                                     dest,"out_BRANCH_COMPLETE_FRONT_END_"+toString(i)+"_"+toString(j)+"_VAL"            );
            COMPONENT_MAP(_component,src ,"out_BRANCH_COMPLETE_"                          +toString(j)+"_ACK"            ,
                                     dest, "in_BRANCH_COMPLETE_FRONT_END_"+toString(i)+"_"+toString(j)+"_ACK"            );
            if (_param->_have_port_context_id)
            COMPONENT_MAP(_component,src , "in_BRANCH_COMPLETE_"                          +toString(j)+"_CONTEXT_ID"     ,
                                     dest,"out_BRANCH_COMPLETE_FRONT_END_"+toString(i)+"_"+toString(j)+"_CONTEXT_ID"     );
            if (_param->_have_port_depth)
            COMPONENT_MAP(_component,src , "in_BRANCH_COMPLETE_"                          +toString(j)+"_DEPTH"          ,
                                     dest,"out_BRANCH_COMPLETE_FRONT_END_"+toString(i)+"_"+toString(j)+"_DEPTH"          );
            COMPONENT_MAP(_component,src , "in_BRANCH_COMPLETE_"                          +toString(j)+"_ADDRESS"        ,
                                     dest,"out_BRANCH_COMPLETE_FRONT_END_"+toString(i)+"_"+toString(j)+"_ADDRESS"        );
            COMPONENT_MAP(_component,src , "in_BRANCH_COMPLETE_"                          +toString(j)+"_NO_SEQUENCE"    ,
                                     dest,"out_BRANCH_COMPLETE_FRONT_END_"+toString(i)+"_"+toString(j)+"_NO_SEQUENCE"    );
            COMPONENT_MAP(_component,src ,"out_BRANCH_COMPLETE_"                          +toString(j)+"_MISS_PREDICTION",
                                     dest, "in_BRANCH_COMPLETE_FRONT_END_"+toString(i)+"_"+toString(j)+"_MISS_PREDICTION");
          }

        // ~~~~~[ Interface : "commit_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        {
          dest = _name+"_glue";
#ifdef POSITION
          _component->interface_map (src ,"commit_event"                       ,
                                     dest,"commit_event_front_end_"+toString(i));
#endif

          COMPONENT_MAP(_component,src , "in_COMMIT_EVENT_VAL"             ,
                                   dest,"out_COMMIT_EVENT_FRONT_END_"+toString(i)+"_VAL"             );
          COMPONENT_MAP(_component,src ,"out_COMMIT_EVENT_ACK"             ,
                                   dest, "in_COMMIT_EVENT_FRONT_END_"+toString(i)+"_ACK"             );
          if (_param->_have_port_context_id)
          COMPONENT_MAP(_component,src , "in_COMMIT_EVENT_CONTEXT_ID"      ,
                                   dest,"out_COMMIT_EVENT_FRONT_END_"+toString(i)+"_CONTEXT_ID"      );
          if (_param->_have_port_depth)
          COMPONENT_MAP(_component,src , "in_COMMIT_EVENT_DEPTH"           ,
                                   dest,"out_COMMIT_EVENT_FRONT_END_"+toString(i)+"_DEPTH"           );
          COMPONENT_MAP(_component,src , "in_COMMIT_EVENT_TYPE"            ,
                                   dest,"out_COMMIT_EVENT_FRONT_END_"+toString(i)+"_TYPE"            );
          COMPONENT_MAP(_component,src , "in_COMMIT_EVENT_IS_DELAY_SLOT"   ,
                                   dest,"out_COMMIT_EVENT_FRONT_END_"+toString(i)+"_IS_DELAY_SLOT"   );
          COMPONENT_MAP(_component,src , "in_COMMIT_EVENT_ADDRESS"         ,
                                   dest,"out_COMMIT_EVENT_FRONT_END_"+toString(i)+"_ADDRESS"         );
          COMPONENT_MAP(_component,src , "in_COMMIT_EVENT_ADDRESS_EPCR_VAL",
                                   dest,"out_COMMIT_EVENT_FRONT_END_"+toString(i)+"_ADDRESS_EPCR_VAL");
          COMPONENT_MAP(_component,src , "in_COMMIT_EVENT_ADDRESS_EPCR"    ,
                                   dest,"out_COMMIT_EVENT_FRONT_END_"+toString(i)+"_ADDRESS_EPCR"    );
          COMPONENT_MAP(_component,src , "in_COMMIT_EVENT_ADDRESS_EEAR_VAL",
                                   dest,"out_COMMIT_EVENT_FRONT_END_"+toString(i)+"_ADDRESS_EEAR_VAL");
          COMPONENT_MAP(_component,src , "in_COMMIT_EVENT_ADDRESS_EEAR"    ,
                                   dest,"out_COMMIT_EVENT_FRONT_END_"+toString(i)+"_ADDRESS_EEAR"    );
        }

        // ~~~~~[ Interface "event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        // out_EVENT_VAL              - ooo_engine. in_EVENT_VAL             
        //  in_EVENT_ACK              - ooo_engine.out_EVENT_ACK             
        // out_EVENT_ADDRESS          - ooo_engine. in_EVENT_ADDRESS         
        // out_EVENT_ADDRESS_NEXT     - ooo_engine. in_EVENT_ADDRESS_NEXT     
        // out_EVENT_ADDRESS_NEXT_VAL - ooo_engine. in_EVENT_ADDRESS_NEXT_VAL
        // out_EVENT_IS_DS_TAKE       - ooo_engine. in_EVENT_IS_DS_TAKE      

        // ~~~~~[ Interface "spr_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        //out_SPR_EVENT_VAL       - ooo_engine. in_SPR_EVENT_VAL      
        // in_SPR_EVENT_ACK       - ooo_engine.out_SPR_EVENT_ACK      
        //out_SPR_EVENT_EPCR      - ooo_engine. in_SPR_EVENT_EPCR     
        //out_SPR_EVENT_EEAR_WEN  - ooo_engine. in_SPR_EVENT_EEAR_WEN 
        //out_SPR_EVENT_EEAR      - ooo_engine. in_SPR_EVENT_EEAR     
        //out_SPR_EVENT_SR_DSX    - ooo_engine. in_SPR_EVENT_SR_DSX   
        //out_SPR_EVENT_SR_TO_ESR - ooo_engine. in_SPR_EVENT_SR_TO_ESR
        
        // ~~~~~[ Interface : "nb_inst" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        // in_NB_INST_COMMIT_ALL - ooo_engine.out_NB_INST_COMMIT_ALL
        // in_NB_INST_COMMIT_MEM - ooo_engine.out_NB_INST_COMMIT_MEM
        
        // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        // out_DEPTH_MIN  - ooo_engine. in_DEPTH_MIN      
        // out_DEPTH_MAX  - ooo_engine. in_DEPTH_MAX
        // out_DEPTH_FULL - ooo_engine. in_DEPTH_FULL
        
        // ~~~~~[ Interface : "spr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        //  in_SPR_SR_IEE - ooo_engine.out_SPR_SR_IEE
        //  in_SPR_SR_EPH - ooo_engine.out_SPR_SR_EPH
        
        // ~~~~~[ Interface : "interrupt" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        for (uint32_t j=0; j<_param->_nb_context [i]; ++j)
          {
            uint32_t x = _param->_link_thread_with_context [i][j];

            dest = _name;
#ifdef POSITION
            _component->interface_map (src ,"interrupt_"+toString(j),
                                       dest,"interrupt_"+toString(x));
#endif
            
            PORT_MAP(_component,src , "in_INTERRUPT_"+toString(j)+"_ENABLE",
                                dest, "in_INTERRUPT_"+toString(x)+"_ENABLE");
          }
      }
    
    // ===================================================================
    // =====[ ooo_engine ]================================================
    // ===================================================================
    for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
      {
        src = _name+"_ooo_engine_"+toString(i);
        log_printf(INFO,Core,FUNCTION,_("Instance : %s"),src.c_str());
        
        // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        {
          dest = _name;
#ifdef POSITION
          _component->interface_map (src ,"",
                                     dest,"");
#endif
          PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
          PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
        }

        // ~~~~~[ Interface : "rename" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        for (uint32_t j=0; j<_param->_ooo_engine_nb_front_end [i]; ++j)
          for (uint32_t k=0; k<_param->_ooo_engine_nb_inst_decod[i][j]; ++k)
            {
              uint32_t x = _param->_translate_ooo_engine_num_front_end [i][j];
              dest = _name+"_front_end_"+toString(x);
#ifdef POSITION
              _component->interface_map (src ,"rename_"+toString(j)+"_"+toString(k),
                                         dest,"decod_"                 +toString(k));
#endif
              
              COMPONENT_MAP(_component,src , "in_RENAME_"+toString(j)+"_"+toString(k)+"_VAL"          ,
                                       dest,"out_DECOD_"                 +toString(k)+"_VAL"          );
              COMPONENT_MAP(_component,src ,"out_RENAME_"+toString(j)+"_"+toString(k)+"_ACK"          ,
                                       dest, "in_DECOD_"                 +toString(k)+"_ACK"          );
              if (_param->_have_port_context_id)
              COMPONENT_MAP(_component,src , "in_RENAME_"+toString(j)+"_"+toString(k)+"_CONTEXT_ID"   ,
                                       dest,"out_DECOD_"                 +toString(k)+"_CONTEXT_ID"   );
              if (_param->_have_port_depth)
              COMPONENT_MAP(_component,src , "in_RENAME_"+toString(j)+"_"+toString(k)+"_DEPTH"        ,
                                       dest,"out_DECOD_"                 +toString(k)+"_DEPTH"        );
              COMPONENT_MAP(_component,src , "in_RENAME_"+toString(j)+"_"+toString(k)+"_TYPE"         ,
                                       dest,"out_DECOD_"                 +toString(k)+"_TYPE"         );
              COMPONENT_MAP(_component,src , "in_RENAME_"+toString(j)+"_"+toString(k)+"_OPERATION"    ,
                                       dest,"out_DECOD_"                 +toString(k)+"_OPERATION"    );
              COMPONENT_MAP(_component,src , "in_RENAME_"+toString(j)+"_"+toString(k)+"_NO_EXECUTE"   ,
                                       dest,"out_DECOD_"                 +toString(k)+"_NO_EXECUTE"   );
              COMPONENT_MAP(_component,src , "in_RENAME_"+toString(j)+"_"+toString(k)+"_IS_DELAY_SLOT",
                                       dest,"out_DECOD_"                 +toString(k)+"_IS_DELAY_SLOT");
#ifdef DEBUG
              COMPONENT_MAP(_component,src , "in_RENAME_"+toString(j)+"_"+toString(k)+"_ADDRESS"      ,
                                       dest,"out_DECOD_"                 +toString(k)+"_ADDRESS"      );
#endif
              COMPONENT_MAP(_component,src , "in_RENAME_"+toString(j)+"_"+toString(k)+"_ADDRESS_NEXT" ,
                                       dest,"out_DECOD_"                 +toString(k)+"_ADDRESS_NEXT" );
              COMPONENT_MAP(_component,src , "in_RENAME_"+toString(j)+"_"+toString(k)+"_HAS_IMMEDIAT" ,
                                       dest,"out_DECOD_"                 +toString(k)+"_HAS_IMMEDIAT" );
              COMPONENT_MAP(_component,src , "in_RENAME_"+toString(j)+"_"+toString(k)+"_IMMEDIAT"     ,
                                       dest,"out_DECOD_"                 +toString(k)+"_IMMEDIAT"     );
              COMPONENT_MAP(_component,src , "in_RENAME_"+toString(j)+"_"+toString(k)+"_READ_RA"      ,
                                       dest,"out_DECOD_"                 +toString(k)+"_READ_RA"      );
              COMPONENT_MAP(_component,src , "in_RENAME_"+toString(j)+"_"+toString(k)+"_NUM_REG_RA"   ,
                                       dest,"out_DECOD_"                 +toString(k)+"_NUM_REG_RA"   );
              COMPONENT_MAP(_component,src , "in_RENAME_"+toString(j)+"_"+toString(k)+"_READ_RB"      ,
                                       dest,"out_DECOD_"                 +toString(k)+"_READ_RB"      );
              COMPONENT_MAP(_component,src , "in_RENAME_"+toString(j)+"_"+toString(k)+"_NUM_REG_RB"   ,
                                       dest,"out_DECOD_"                 +toString(k)+"_NUM_REG_RB"   );
              COMPONENT_MAP(_component,src , "in_RENAME_"+toString(j)+"_"+toString(k)+"_READ_RC"      ,
                                       dest,"out_DECOD_"                 +toString(k)+"_READ_RC"      );
              COMPONENT_MAP(_component,src , "in_RENAME_"+toString(j)+"_"+toString(k)+"_NUM_REG_RC"   ,
                                       dest,"out_DECOD_"                 +toString(k)+"_NUM_REG_RC"   );
              COMPONENT_MAP(_component,src , "in_RENAME_"+toString(j)+"_"+toString(k)+"_WRITE_RD"     ,
                                       dest,"out_DECOD_"                 +toString(k)+"_WRITE_RD"     );
              COMPONENT_MAP(_component,src , "in_RENAME_"+toString(j)+"_"+toString(k)+"_NUM_REG_RD"   ,
                                       dest,"out_DECOD_"                 +toString(k)+"_NUM_REG_RD"   );
              COMPONENT_MAP(_component,src , "in_RENAME_"+toString(j)+"_"+toString(k)+"_WRITE_RE"     ,
                                       dest,"out_DECOD_"                 +toString(k)+"_WRITE_RE"     );
              COMPONENT_MAP(_component,src , "in_RENAME_"+toString(j)+"_"+toString(k)+"_NUM_REG_RE"   ,
                                       dest,"out_DECOD_"                 +toString(k)+"_NUM_REG_RE"   );
              COMPONENT_MAP(_component,src , "in_RENAME_"+toString(j)+"_"+toString(k)+"_EXCEPTION_USE",
                                       dest,"out_DECOD_"                 +toString(k)+"_EXCEPTION_USE");
              COMPONENT_MAP(_component,src , "in_RENAME_"+toString(j)+"_"+toString(k)+"_EXCEPTION"    ,
                                       dest,"out_DECOD_"                 +toString(k)+"_EXCEPTION"    );
        
              dest = _name+"_glue";
#ifdef POSITION
              _component->interface_map (src ,"rename_"+toString(j)+"_"+toString(k),
                                         dest,"rename_"+toString(j)+"_"+toString(k));
#endif
              if (_param->_have_port_front_end_id)
              COMPONENT_MAP(_component,src , "in_RENAME_"+toString(j)+"_"+toString(k)+"_FRONT_END_ID" ,
                                       dest,"out_RENAME_"+toString(j)+"_"+toString(k)+"_FRONT_END_ID" );
            }

        // ~~~~~[ Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~
        for (uint32_t j=0; j<_param->_nb_inst_branch_complete[i];++j)
          {
            dest = _name+"_glue";
#ifdef POSITION
            _component->interface_map (src ,"branch_complete_"                           +toString(j),
                                       dest,"branch_complete_ooo_engine_"+toString(i)+"_"+toString(j));
#endif

            COMPONENT_MAP(_component,src ,"out_BRANCH_COMPLETE_"                           +toString(j)+"_VAL"            ,
                                     dest, "in_BRANCH_COMPLETE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_VAL"            );
            COMPONENT_MAP(_component,src , "in_BRANCH_COMPLETE_"                           +toString(j)+"_ACK"            ,
                                     dest,"out_BRANCH_COMPLETE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_ACK"            );
            if (_param->_have_port_front_end_id)
            COMPONENT_MAP(_component,src ,"out_BRANCH_COMPLETE_"                           +toString(j)+"_FRONT_END_ID"   ,
                                     dest, "in_BRANCH_COMPLETE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_FRONT_END_ID"   );
            if (_param->_have_port_context_id)
            COMPONENT_MAP(_component,src ,"out_BRANCH_COMPLETE_"                           +toString(j)+"_CONTEXT_ID"     ,
                                     dest, "in_BRANCH_COMPLETE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_CONTEXT_ID"     );
            if (_param->_have_port_depth)
            COMPONENT_MAP(_component,src ,"out_BRANCH_COMPLETE_"                           +toString(j)+"_DEPTH"          ,
                                     dest, "in_BRANCH_COMPLETE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_DEPTH"          );
            COMPONENT_MAP(_component,src ,"out_BRANCH_COMPLETE_"                           +toString(j)+"_ADDRESS"        ,
                                     dest, "in_BRANCH_COMPLETE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_ADDRESS"        );
            COMPONENT_MAP(_component,src ,"out_BRANCH_COMPLETE_"                           +toString(j)+"_NO_SEQUENCE"    ,
                                     dest, "in_BRANCH_COMPLETE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_NO_SEQUENCE"    );
            COMPONENT_MAP(_component,src , "in_BRANCH_COMPLETE_"                           +toString(j)+"_MISS_PREDICTION",
                                     dest,"out_BRANCH_COMPLETE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_MISS_PREDICTION");
          }     

        // ~~~~~[ Interface : "commit_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        {
          dest = _name+"_glue";
#ifdef POSITION
          _component->interface_map (src ,"commit_event",
                                     dest,"commit_event_ooo_engine_"+toString(i));
#endif
          
          COMPONENT_MAP(_component,src ,"out_COMMIT_EVENT_VAL"             ,
                                   dest, "in_COMMIT_EVENT_OOO_ENGINE_"+toString(i)+"_VAL"             );
          COMPONENT_MAP(_component,src , "in_COMMIT_EVENT_ACK"             ,
                                   dest,"out_COMMIT_EVENT_OOO_ENGINE_"+toString(i)+"_ACK"             );
          if (_param->_have_port_front_end_id)
          COMPONENT_MAP(_component,src ,"out_COMMIT_EVENT_FRONT_END_ID"    ,
                                   dest, "in_COMMIT_EVENT_OOO_ENGINE_"+toString(i)+"_FRONT_END_ID"    );
          if (_param->_have_port_context_id)
          COMPONENT_MAP(_component,src ,"out_COMMIT_EVENT_CONTEXT_ID"      ,
                                   dest, "in_COMMIT_EVENT_OOO_ENGINE_"+toString(i)+"_CONTEXT_ID"      );
          if (_param->_have_port_depth)
          COMPONENT_MAP(_component,src ,"out_COMMIT_EVENT_DEPTH"           ,
                                   dest, "in_COMMIT_EVENT_OOO_ENGINE_"+toString(i)+"_DEPTH"           );
          COMPONENT_MAP(_component,src ,"out_COMMIT_EVENT_TYPE"            ,
                                   dest, "in_COMMIT_EVENT_OOO_ENGINE_"+toString(i)+"_TYPE"            );
          COMPONENT_MAP(_component,src ,"out_COMMIT_EVENT_IS_DELAY_SLOT"   ,
                                   dest, "in_COMMIT_EVENT_OOO_ENGINE_"+toString(i)+"_IS_DELAY_SLOT"   );
          COMPONENT_MAP(_component,src ,"out_COMMIT_EVENT_ADDRESS"         ,
                                   dest, "in_COMMIT_EVENT_OOO_ENGINE_"+toString(i)+"_ADDRESS"         );
          COMPONENT_MAP(_component,src ,"out_COMMIT_EVENT_ADDRESS_EPCR_VAL",
                                   dest, "in_COMMIT_EVENT_OOO_ENGINE_"+toString(i)+"_ADDRESS_EPCR_VAL");
          COMPONENT_MAP(_component,src ,"out_COMMIT_EVENT_ADDRESS_EPCR"    ,
                                   dest, "in_COMMIT_EVENT_OOO_ENGINE_"+toString(i)+"_ADDRESS_EPCR"    );
          COMPONENT_MAP(_component,src ,"out_COMMIT_EVENT_ADDRESS_EEAR_VAL",
                                   dest, "in_COMMIT_EVENT_OOO_ENGINE_"+toString(i)+"_ADDRESS_EEAR_VAL");
          COMPONENT_MAP(_component,src ,"out_COMMIT_EVENT_ADDRESS_EEAR"    ,
                                   dest, "in_COMMIT_EVENT_OOO_ENGINE_"+toString(i)+"_ADDRESS_EEAR"    );
        }

        // ~~~~~[ Interface "event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        for (uint32_t j=0; j<_param->_ooo_engine_nb_front_end [i]; ++j)
          {
            uint32_t x = _param->_translate_ooo_engine_num_front_end [i][j];
            for (uint32_t k=0; k<_param->_nb_context[x]; ++k)
              {
                dest = _name+"_front_end_"+toString(x);
#ifdef POSITION
                _component->interface_map (src ,"event_"+toString(j)+"_"+toString(k),
                                           dest,"event_"                +toString(k));
#endif

                COMPONENT_MAP(_component,src , "in_EVENT_"+toString(j)+"_"+toString(k)+"_VAL"             ,
                                         dest,"out_EVENT_"                +toString(k)+"_VAL"             );
                COMPONENT_MAP(_component,src ,"out_EVENT_"+toString(j)+"_"+toString(k)+"_ACK"             ,
                                         dest, "in_EVENT_"                +toString(k)+"_ACK"             );
                COMPONENT_MAP(_component,src , "in_EVENT_"+toString(j)+"_"+toString(k)+"_ADDRESS"         ,
                                         dest,"out_EVENT_"                +toString(k)+"_ADDRESS"         );
                COMPONENT_MAP(_component,src , "in_EVENT_"+toString(j)+"_"+toString(k)+"_ADDRESS_NEXT"    ,
                                         dest,"out_EVENT_"                +toString(k)+"_ADDRESS_NEXT"    ); 
                COMPONENT_MAP(_component,src , "in_EVENT_"+toString(j)+"_"+toString(k)+"_ADDRESS_NEXT_VAL",
                                         dest,"out_EVENT_"                +toString(k)+"_ADDRESS_NEXT_VAL");
                COMPONENT_MAP(_component,src , "in_EVENT_"+toString(j)+"_"+toString(k)+"_IS_DS_TAKE"      ,
                                         dest,"out_EVENT_"                +toString(k)+"_IS_DS_TAKE"      );
              }
          }

        // ~~~~~[ Interface "spr_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        for (uint32_t j=0; j<_param->_ooo_engine_nb_front_end [i]; ++j)
          {
            uint32_t x = _param->_translate_ooo_engine_num_front_end [i][j];
            for (uint32_t k=0; k<_param->_nb_context[x]; ++k)
              {
                dest = _name+"_front_end_"+toString(x);
#ifdef POSITION
                _component->interface_map (src ,"spr_event_"+toString(j)+"_"+toString(k),
                                           dest,"spr_event_"                +toString(k));
#endif
                COMPONENT_MAP(_component,src , "in_SPR_EVENT_"+toString(j)+"_"+toString(k)+"_VAL"      ,
                                         dest,"out_SPR_EVENT_"                +toString(k)+"_VAL"      );
                COMPONENT_MAP(_component,src ,"out_SPR_EVENT_"+toString(j)+"_"+toString(k)+"_ACK"      ,
                                         dest, "in_SPR_EVENT_"                +toString(k)+"_ACK"      );
                COMPONENT_MAP(_component,src , "in_SPR_EVENT_"+toString(j)+"_"+toString(k)+"_EPCR"     ,
                                         dest,"out_SPR_EVENT_"                +toString(k)+"_EPCR"     );
                COMPONENT_MAP(_component,src , "in_SPR_EVENT_"+toString(j)+"_"+toString(k)+"_EEAR_WEN" ,
                                         dest,"out_SPR_EVENT_"                +toString(k)+"_EEAR_WEN" );
                COMPONENT_MAP(_component,src , "in_SPR_EVENT_"+toString(j)+"_"+toString(k)+"_EEAR"     ,
                                         dest,"out_SPR_EVENT_"                +toString(k)+"_EEAR"     );
                COMPONENT_MAP(_component,src , "in_SPR_EVENT_"+toString(j)+"_"+toString(k)+"_SR_DSX"   ,
                                         dest,"out_SPR_EVENT_"                +toString(k)+"_SR_DSX"   );
                COMPONENT_MAP(_component,src , "in_SPR_EVENT_"+toString(j)+"_"+toString(k)+"_SR_TO_ESR",
                                         dest,"out_SPR_EVENT_"                +toString(k)+"_SR_TO_ESR");
              }
          }

        // ~~~~~[ Interface : "nb_inst" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        for (uint32_t j=0; j<_param->_ooo_engine_nb_front_end [i]; ++j)
          {
            uint32_t x = _param->_translate_ooo_engine_num_front_end [i][j];
            for (uint32_t k=0; k<_param->_nb_context[x]; ++k)
              {
                dest = _name+"_front_end_"+toString(x);
#ifdef POSITION
                _component->interface_map (src ,"nb_inst_"+toString(j)+"_"+toString(k),
                                           dest,"nb_inst_"                +toString(k));
#endif
                COMPONENT_MAP(_component,src ,"out_NB_INST_"+toString(j)+"_"+toString(k)+"_COMMIT_ALL",
                                         dest, "in_NB_INST_"                +toString(k)+"_COMMIT_ALL");
                COMPONENT_MAP(_component,src ,"out_NB_INST_"+toString(j)+"_"+toString(k)+"_COMMIT_MEM",
                                         dest, "in_NB_INST_"                +toString(k)+"_COMMIT_MEM");
                COMPONENT_MAP(_component,src , "in_NB_INST_"+toString(j)+"_"+toString(k)+"_DECOD_ALL" ,
                                         dest,"out_NB_INST_"                +toString(k)+"_DECOD_ALL" );
              }
          }

        // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        for (uint32_t j=0; j<_param->_ooo_engine_nb_front_end [i]; ++j)
          {
            uint32_t x = _param->_translate_ooo_engine_num_front_end [i][j];
            for (uint32_t k=0; k<_param->_nb_context[x]; ++k)
              {
                dest = _name+"_front_end_"+toString(x);
#ifdef POSITION
                _component->interface_map (src ,"depth_"+toString(j)+"_"+toString(k),
                                           dest,"depth_"                +toString(k));
#endif

                if (_param->_have_port_depth)
                  {
                COMPONENT_MAP(_component,src , "in_DEPTH_"+toString(j)+"_"+toString(k)+"_MIN",
                                         dest,"out_DEPTH_"                +toString(k)+"_MIN");
                COMPONENT_MAP(_component,src , "in_DEPTH_"+toString(j)+"_"+toString(k)+"_MAX",
                                         dest,"out_DEPTH_"                +toString(k)+"_MAX");
                  }
                COMPONENT_MAP(_component,src , "in_DEPTH_"+toString(j)+"_"+toString(k)+"_FULL",
                                         dest,"out_DEPTH_"                +toString(k)+"_FULL");
              }
          }

        // ~~~~~[ Interface : "spr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        for (uint32_t j=0; j<_param->_ooo_engine_nb_front_end [i]; ++j)
          {
            uint32_t x = _param->_translate_ooo_engine_num_front_end [i][j];
            for (uint32_t k=0; k<_param->_nb_context[x]; ++k)
              {
                dest = _name+"_front_end_"+toString(x);
#ifdef POSITION
                _component->interface_map (src ,"spr_"+toString(j)+"_"+toString(k),
                                           dest,"spr_"                +toString(k));
#endif

                COMPONENT_MAP(_component,src ,"out_SPR_"+toString(j)+"_"+toString(k)+"_SR_IEE",
                                         dest, "in_SPR_"                +toString(k)+"_SR_IEE");
                COMPONENT_MAP(_component,src ,"out_SPR_"+toString(j)+"_"+toString(k)+"_SR_EPH",
                                         dest, "in_SPR_"                +toString(k)+"_SR_EPH");
              }
          }

        // ~~~~~[ Interface : "issue" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        for (uint32_t j=0; j<_param->_nb_inst_issue [i]; ++j)
          {
            dest = _name+"_glue";
#ifdef POSITION
            _component->interface_map (src ,"issue_"                           +toString(j),
                                       dest,"issue_ooo_engine_"+toString(i)+"_"+toString(j));
#endif

            COMPONENT_MAP(_component,src ,"out_ISSUE_"                           +toString(j)+"_VAL"                  ,
                                     dest, "in_ISSUE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_VAL"                  );
            COMPONENT_MAP(_component,src , "in_ISSUE_"                           +toString(j)+"_ACK"                  ,
                                     dest,"out_ISSUE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_ACK"                  );
            if (_param->_have_port_front_end_id)
            COMPONENT_MAP(_component,src ,"out_ISSUE_"                           +toString(j)+"_FRONT_END_ID"         ,
                                     dest, "in_ISSUE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_FRONT_END_ID"         );
            if (_param->_have_port_context_id)
            COMPONENT_MAP(_component,src ,"out_ISSUE_"                           +toString(j)+"_CONTEXT_ID"           ,
                                     dest, "in_ISSUE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_CONTEXT_ID"           );
            if (_param->_have_port_rob_ptr)
            COMPONENT_MAP(_component,src ,"out_ISSUE_"                           +toString(j)+"_PACKET_ID"            ,
                                     dest, "in_ISSUE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_PACKET_ID"            );
            COMPONENT_MAP(_component,src ,"out_ISSUE_"                           +toString(j)+"_TYPE"                 ,
                                     dest, "in_ISSUE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_TYPE"                 );
            COMPONENT_MAP(_component,src ,"out_ISSUE_"                           +toString(j)+"_OPERATION"            ,
                                     dest, "in_ISSUE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_OPERATION"            );
            COMPONENT_MAP(_component,src ,"out_ISSUE_"                           +toString(j)+"_STORE_QUEUE_PTR_WRITE",
                                     dest, "in_ISSUE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_STORE_QUEUE_PTR_WRITE");
            if (_param->_have_port_load_queue_ptr)
            COMPONENT_MAP(_component,src ,"out_ISSUE_"                           +toString(j)+"_LOAD_QUEUE_PTR_WRITE" ,
                                     dest, "in_ISSUE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_LOAD_QUEUE_PTR_WRITE" );
            COMPONENT_MAP(_component,src ,"out_ISSUE_"                           +toString(j)+"_HAS_IMMEDIAT"         ,
                                     dest, "in_ISSUE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_HAS_IMMEDIAT"         );
            COMPONENT_MAP(_component,src ,"out_ISSUE_"                           +toString(j)+"_IMMEDIAT"             ,
                                     dest, "in_ISSUE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_IMMEDIAT"             );
            COMPONENT_MAP(_component,src ,"out_ISSUE_"                           +toString(j)+"_READ_RA"              ,
                                     dest, "in_ISSUE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_READ_RA"              );
            COMPONENT_MAP(_component,src ,"out_ISSUE_"                           +toString(j)+"_NUM_REG_RA"           ,
                                     dest, "in_ISSUE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_NUM_REG_RA"           );
            COMPONENT_MAP(_component,src ,"out_ISSUE_"                           +toString(j)+"_READ_RB"              ,
                                     dest, "in_ISSUE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_READ_RB"              );
            COMPONENT_MAP(_component,src ,"out_ISSUE_"                           +toString(j)+"_NUM_REG_RB"           ,
                                     dest, "in_ISSUE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_NUM_REG_RB"           );
            COMPONENT_MAP(_component,src ,"out_ISSUE_"                           +toString(j)+"_READ_RC"              ,
                                     dest, "in_ISSUE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_READ_RC"              );
            COMPONENT_MAP(_component,src ,"out_ISSUE_"                           +toString(j)+"_NUM_REG_RC"           ,
                                     dest, "in_ISSUE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_NUM_REG_RC"           );
            COMPONENT_MAP(_component,src ,"out_ISSUE_"                           +toString(j)+"_WRITE_RD"             ,
                                     dest, "in_ISSUE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_WRITE_RD"             );
            COMPONENT_MAP(_component,src ,"out_ISSUE_"                           +toString(j)+"_NUM_REG_RD"           ,
                                     dest, "in_ISSUE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_NUM_REG_RD"           );
            COMPONENT_MAP(_component,src ,"out_ISSUE_"                           +toString(j)+"_WRITE_RE"             ,
                                     dest, "in_ISSUE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_WRITE_RE"             );
            COMPONENT_MAP(_component,src ,"out_ISSUE_"                           +toString(j)+"_NUM_REG_RE"           ,
                                     dest, "in_ISSUE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_NUM_REG_RE"           );
          }

        // ~~~~~[ Interface "execute_loop" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        for (uint32_t j=0; j<_param->_ooo_engine_nb_execute_loop [i]; ++j)
          {
            for (uint32_t k=0; k<_param->_ooo_engine_nb_inst_execute [i][j]; ++k)
              {
                dest = _name+"_glue";
#ifdef POSITION
                _component->interface_map (src ,"execute_loop_"                      +toString(j)+"_"+toString(k),
                                           dest,"execute_ooo_engine_"+toString(i)+"_"+toString(j)+"_"+toString(k));
#endif 

                COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_"                      +toString(j)+"_"+toString(k)+"_VAL"         ,
                                         dest,"out_EXECUTE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_"+toString(k)+"_VAL"         );
                COMPONENT_MAP(_component,src ,"out_EXECUTE_LOOP_"                      +toString(j)+"_"+toString(k)+"_ACK"         ,
                                         dest, "in_EXECUTE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_"+toString(k)+"_ACK"         );
                if (_param->_have_port_front_end_id)
                COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_"                      +toString(j)+"_"+toString(k)+"_FRONT_END_ID",
                                         dest,"out_EXECUTE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_"+toString(k)+"_FRONT_END_ID");
                if (_param->_have_port_context_id)
                COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_"                      +toString(j)+"_"+toString(k)+"_CONTEXT_ID"  ,
                                         dest,"out_EXECUTE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_"+toString(k)+"_CONTEXT_ID"  );
                if (_param->_have_port_rob_ptr)
                COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_"                      +toString(j)+"_"+toString(k)+"_PACKET_ID"   ,
                                         dest,"out_EXECUTE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_"+toString(k)+"_PACKET_ID"   );
//              COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_"                      +toString(j)+"_"+toString(k)+"_TYPE"        ,
//                                       dest,"out_EXECUTE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_"+toString(k)+"_TYPE"        );
//              COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_"                      +toString(j)+"_"+toString(k)+"_OPERATION"   ,
//                                       dest,"out_EXECUTE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_"+toString(k)+"_OPERATION"   );
                COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_"                      +toString(j)+"_"+toString(k)+"_FLAGS"       ,
                                         dest,"out_EXECUTE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_"+toString(k)+"_FLAGS"       );
                COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_"                      +toString(j)+"_"+toString(k)+"_EXCEPTION"   ,
                                         dest,"out_EXECUTE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_"+toString(k)+"_EXCEPTION"   );
                COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_"                      +toString(j)+"_"+toString(k)+"_NO_SEQUENCE" ,
                                         dest,"out_EXECUTE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_"+toString(k)+"_NO_SEQUENCE" );
                COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_"                      +toString(j)+"_"+toString(k)+"_ADDRESS"     ,
                                         dest,"out_EXECUTE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_"+toString(k)+"_ADDRESS"     );
                COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_"                      +toString(j)+"_"+toString(k)+"_DATA"        ,
                                         dest,"out_EXECUTE_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_"+toString(k)+"_DATA"        );
              }
          }

        // ~~~~~[ Interface "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        for (uint32_t j=0; j<_param->_ooo_engine_nb_inst_insert_rob [i]; ++j)
          {
            dest = _name+"_glue";
#ifdef POSITION
            _component->interface_map (src ,"insert_"                           +toString(j),
                                       dest,"insert_ooo_engine_"+toString(i)+"_"+toString(j));
#endif 
            
            COMPONENT_MAP(_component,src ,"out_INSERT_"                           +toString(j)+"_VAL"       ,
                                     dest, "in_INSERT_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_VAL"       );
            COMPONENT_MAP(_component,src , "in_INSERT_"                           +toString(j)+"_ACK"       ,
                                     dest,"out_INSERT_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_ACK"       );
            COMPONENT_MAP(_component,src ,"out_INSERT_"                           +toString(j)+"_RD_USE"    ,
                                     dest, "in_INSERT_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_RD_USE"    );
            COMPONENT_MAP(_component,src ,"out_INSERT_"                           +toString(j)+"_RD_NUM_REG",
                                     dest, "in_INSERT_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_RD_NUM_REG");
            COMPONENT_MAP(_component,src ,"out_INSERT_"                           +toString(j)+"_RE_USE"    ,
                                     dest, "in_INSERT_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_RE_USE"    );
            COMPONENT_MAP(_component,src ,"out_INSERT_"                           +toString(j)+"_RE_NUM_REG",
                                     dest, "in_INSERT_OOO_ENGINE_"+toString(i)+"_"+toString(j)+"_RE_NUM_REG");
          }
      }

    // ===================================================================
    // =====[ execute_loop ]==============================================
    // ===================================================================
    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
      {
        src = _name+"_execute_loop_"+toString(i);
        log_printf(INFO,Core,FUNCTION,_("Instance : %s"),src.c_str());
        
        // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        {
          dest = _name;
#ifdef POSITION
          _component->interface_map (src ,"",
                                     dest,"");
#endif
          PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
          PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
        }

        // ~~~~~[ Interface "execute_loop_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~
        for (uint32_t j=0; j<_param->_nb_read_unit[i]; ++j)
          {
            dest = _name+"_glue";
#ifdef POSITION
            _component->interface_map (src ,"execute_loop_in_"                   +toString(j),
                                       dest,"issue_execute_loop_"+toString(i)+"_"+toString(j));
#endif

            COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_IN_"                   +toString(j)+"_VAL"                  ,
                                     dest,"out_ISSUE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_VAL"                  );
            COMPONENT_MAP(_component,src ,"out_EXECUTE_LOOP_IN_"                   +toString(j)+"_ACK"                  ,
                                     dest, "in_ISSUE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_ACK"                  );
            if (_param->_have_port_front_end_id)
            COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_IN_"                   +toString(j)+"_FRONT_END_ID"         ,
                                     dest,"out_ISSUE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_FRONT_END_ID"         );
            if (_param->_have_port_context_id)
            COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_IN_"                   +toString(j)+"_CONTEXT_ID"           ,
                                     dest,"out_ISSUE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_CONTEXT_ID"           );
            if (_param->_have_port_ooo_engine_id)
            COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_IN_"                   +toString(j)+"_OOO_ENGINE_ID"        ,
                                     dest,"out_ISSUE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_OOO_ENGINE_ID"        );
            if (_param->_have_port_rob_ptr)
            COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_IN_"                   +toString(j)+"_PACKET_ID"            ,
                                     dest,"out_ISSUE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_PACKET_ID"            );
            COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_IN_"                   +toString(j)+"_OPERATION"            ,
                                     dest,"out_ISSUE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_OPERATION"            );
            COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_IN_"                   +toString(j)+"_TYPE"                 ,
                                     dest,"out_ISSUE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_TYPE"                 );
            COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_IN_"                   +toString(j)+"_STORE_QUEUE_PTR_WRITE",
                                     dest,"out_ISSUE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_STORE_QUEUE_PTR_WRITE");
            if (_param->_have_port_load_queue_ptr)
            COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_IN_"                   +toString(j)+"_LOAD_QUEUE_PTR_WRITE" ,
                                     dest,"out_ISSUE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_LOAD_QUEUE_PTR_WRITE" );
            COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_IN_"                   +toString(j)+"_HAS_IMMEDIAT"         ,
                                     dest,"out_ISSUE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_HAS_IMMEDIAT"         );
            COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_IN_"                   +toString(j)+"_IMMEDIAT"             ,
                                     dest,"out_ISSUE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_IMMEDIAT"             );
            COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_IN_"                   +toString(j)+"_READ_RA"              ,
                                     dest,"out_ISSUE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_READ_RA"              );
            COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_IN_"                   +toString(j)+"_NUM_REG_RA"           ,
                                     dest,"out_ISSUE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_NUM_REG_RA"           );
            COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_IN_"                   +toString(j)+"_READ_RB"              ,
                                     dest,"out_ISSUE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_READ_RB"              );
            COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_IN_"                   +toString(j)+"_NUM_REG_RB"           ,
                                     dest,"out_ISSUE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_NUM_REG_RB"           );
            COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_IN_"                   +toString(j)+"_READ_RC"              ,
                                     dest,"out_ISSUE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_READ_RC"              );
            COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_IN_"                   +toString(j)+"_NUM_REG_RC"           ,
                                     dest,"out_ISSUE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_NUM_REG_RC"           );
            COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_IN_"                   +toString(j)+"_WRITE_RD"             ,
                                     dest,"out_ISSUE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_WRITE_RD"             );
            COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_IN_"                   +toString(j)+"_NUM_REG_RD"           ,
                                     dest,"out_ISSUE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_NUM_REG_RD"           );
            COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_IN_"                   +toString(j)+"_WRITE_RE"             ,
                                     dest,"out_ISSUE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_WRITE_RE"             );
            COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_IN_"                   +toString(j)+"_NUM_REG_RE"           ,
                                     dest,"out_ISSUE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_NUM_REG_RE"           );
          }

        // ~~~~~[ Interface "execute_loop_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~
        for (uint32_t j=0; j<_param->_nb_write_unit[i]; ++j)
          {
            dest = _name+"_glue";
#ifdef POSITION
            _component->interface_map (src ,"execute_loop_out_"                    +toString(j),
                                       dest,"execute_execute_loop_"+toString(i)+"_"+toString(j));
#endif

            COMPONENT_MAP(_component,src ,"out_EXECUTE_LOOP_OUT_"                    +toString(j)+"_VAL"          ,
                                     dest, "in_EXECUTE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_VAL"          );
            COMPONENT_MAP(_component,src , "in_EXECUTE_LOOP_OUT_"                    +toString(j)+"_ACK"          ,
                                     dest,"out_EXECUTE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_ACK"          );
            if (_param->_have_port_context_id)
            COMPONENT_MAP(_component,src ,"out_EXECUTE_LOOP_OUT_"                    +toString(j)+"_CONTEXT_ID"   ,
                                     dest, "in_EXECUTE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_CONTEXT_ID"   );
            if (_param->_have_port_front_end_id)
            COMPONENT_MAP(_component,src ,"out_EXECUTE_LOOP_OUT_"                    +toString(j)+"_FRONT_END_ID" ,
                                     dest, "in_EXECUTE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_FRONT_END_ID" );
            if (_param->_have_port_ooo_engine_id)
            COMPONENT_MAP(_component,src ,"out_EXECUTE_LOOP_OUT_"                    +toString(j)+"_OOO_ENGINE_ID",
                                     dest, "in_EXECUTE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_OOO_ENGINE_ID");
            if (_param->_have_port_rob_ptr)
            COMPONENT_MAP(_component,src ,"out_EXECUTE_LOOP_OUT_"                    +toString(j)+"_PACKET_ID"    ,
                                     dest, "in_EXECUTE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_PACKET_ID"    );
//          COMPONENT_MAP(_component,src ,"out_EXECUTE_LOOP_OUT_"                    +toString(j)+"_OPERATION"    ,
//                                   dest, "in_EXECUTE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_OPERATION"    );
//          COMPONENT_MAP(_component,src ,"out_EXECUTE_LOOP_OUT_"                    +toString(j)+"_TYPE"         ,
//                                   dest, "in_EXECUTE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_TYPE"         );
            COMPONENT_MAP(_component,src ,"out_EXECUTE_LOOP_OUT_"                    +toString(j)+"_FLAGS"        ,
                                     dest, "in_EXECUTE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_FLAGS"        );
            COMPONENT_MAP(_component,src ,"out_EXECUTE_LOOP_OUT_"                    +toString(j)+"_EXCEPTION"    ,
                                     dest, "in_EXECUTE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_EXCEPTION"    );
            COMPONENT_MAP(_component,src ,"out_EXECUTE_LOOP_OUT_"                    +toString(j)+"_NO_SEQUENCE"  ,
                                     dest, "in_EXECUTE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_NO_SEQUENCE"  );
            COMPONENT_MAP(_component,src ,"out_EXECUTE_LOOP_OUT_"                    +toString(j)+"_ADDRESS"      ,
                                     dest, "in_EXECUTE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_ADDRESS"      );
            COMPONENT_MAP(_component,src ,"out_EXECUTE_LOOP_OUT_"                    +toString(j)+"_DATA"         ,
                                     dest, "in_EXECUTE_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_DATA"         );
          }

        // ~~~~~[ Interface "insert_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        for (uint32_t j=0; j<_param->_execute_loop_nb_ooo_engine[i]; ++j)
          for (uint32_t k=0; k<_param->_execute_loop_nb_inst_insert_rob[i][j]; ++k)
            {
              dest = _name+"_glue";
#ifdef POSITION
              _component->interface_map (src ,"insert_rob_"                         +toString(j)+"_"+toString(k),
                                         dest,"insert_execute_loop_"+toString(i)+"_"+toString(j)+"_"+toString(k));
#endif

              COMPONENT_MAP(_component,src , "in_INSERT_ROB_"                         +toString(j)+"_"+toString(k)+"_VAL"       ,
                                       dest,"out_INSERT_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_"+toString(k)+"_VAL"       );
              COMPONENT_MAP(_component,src ,"out_INSERT_ROB_"                         +toString(j)+"_"+toString(k)+"_ACK"       ,
                                       dest, "in_INSERT_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_"+toString(k)+"_ACK"       );
              COMPONENT_MAP(_component,src , "in_INSERT_ROB_"                         +toString(j)+"_"+toString(k)+"_RD_USE"    ,
                                       dest,"out_INSERT_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_"+toString(k)+"_RD_USE"    );
              COMPONENT_MAP(_component,src , "in_INSERT_ROB_"                         +toString(j)+"_"+toString(k)+"_RD_NUM_REG",
                                       dest,"out_INSERT_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_"+toString(k)+"_RD_NUM_REG");
              COMPONENT_MAP(_component,src , "in_INSERT_ROB_"                         +toString(j)+"_"+toString(k)+"_RE_USE"    ,
                                       dest,"out_INSERT_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_"+toString(k)+"_RE_USE"    );
              COMPONENT_MAP(_component,src , "in_INSERT_ROB_"                         +toString(j)+"_"+toString(k)+"_RE_NUM_REG",
                                       dest,"out_INSERT_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_"+toString(k)+"_RE_NUM_REG");
            }        

        // ~~~~~[ Interface "dcache_req" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        // out_DCACHE_REQ_VAL        - dcache_access. in_LSQ_REQ_VAL       
        //  in_DCACHE_REQ_ACK        - dcache_access.out_LSQ_REQ_ACK       
        // out_DCACHE_REQ_CONTEXT_ID - dcache_access. in_LSQ_REQ_CONTEXT_ID
        // out_DCACHE_REQ_PACKET_ID  - dcache_access. in_LSQ_REQ_PACKET_ID 
        // out_DCACHE_REQ_ADDRESS    - dcache_access. in_LSQ_REQ_ADDRESS   
        // out_DCACHE_REQ_TYPE       - dcache_access. in_LSQ_REQ_TYPE      
        // out_DCACHE_REQ_WDATA      - dcache_access. in_LSQ_REQ_WDATA

        // ~~~~~[ Interface "dcache_rsp" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        //  in_DCACHE_RSP_VAL        - dcache_access.out_LSQ_RSP_VAL       
        // out_DCACHE_RSP_ACK        - dcache_access. in_LSQ_RSP_ACK       
        //  in_DCACHE_RSP_CONTEXT_ID - dcache_access.out_LSQ_RSP_CONTEXT_ID
        //  in_DCACHE_RSP_PACKET_ID  - dcache_access.out_LSQ_RSP_PACKET_ID 
        //  in_DCACHE_RSP_RDATA      - dcache_access.out_LSQ_RSP_RDATA     
        //  in_DCACHE_RSP_ERROR      - dcache_access.out_LSQ_RSP_ERROR
      }

    // ===================================================================
    // =====[ icache_access ]=============================================
    // ===================================================================
    {
      src = _name+"_icache_access";
      log_printf(INFO,Core,FUNCTION,_("Instance : %s"),src.c_str());
      
      // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      {
        dest = _name;
#ifdef POSITION
        _component->interface_map (src ,"",
                                   dest,"");
#endif
        PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
        PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

    // ~~~~~[ Interface "icache_req" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    for (uint32_t i=0; i<_param->_nb_icache_port; ++i)
      {
        dest = _name;
#ifdef POSITION
        _component->interface_map (src ,"icache_req_"+toString(i),
                                   dest,"icache_req_"+toString(i));
#endif
        
        PORT_MAP(_component,src ,"out_ICACHE_REQ_"+toString(i)+"_VAL"      ,
                            dest,"out_ICACHE_REQ_"+toString(i)+"_VAL"      );
        PORT_MAP(_component,src , "in_ICACHE_REQ_"+toString(i)+"_ACK"      ,
                            dest, "in_ICACHE_REQ_"+toString(i)+"_ACK"      );
        if (_param->_have_port_icache_thread_id)
        PORT_MAP(_component,src ,"out_ICACHE_REQ_"+toString(i)+"_THREAD_ID",
                            dest,"out_ICACHE_REQ_"+toString(i)+"_THREAD_ID");
        if (_param->_have_port_icache_packet_id)
        PORT_MAP(_component,src ,"out_ICACHE_REQ_"+toString(i)+"_PACKET_ID",
                            dest,"out_ICACHE_REQ_"+toString(i)+"_PACKET_ID");
        PORT_MAP(_component,src ,"out_ICACHE_REQ_"+toString(i)+"_ADDRESS"  ,
                            dest,"out_ICACHE_REQ_"+toString(i)+"_ADDRESS"  );
        PORT_MAP(_component,src ,"out_ICACHE_REQ_"+toString(i)+"_TYPE"     ,
                            dest,"out_ICACHE_REQ_"+toString(i)+"_TYPE"     );
      }

    // ~~~~~[ Interface "icache_rsp" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    for (uint32_t i=0; i<_param->_nb_icache_port; ++i)
      {
        dest = _name;
#ifdef POSITION
        _component->interface_map (src ,"icache_rsp_"+toString(i),
                                   dest,"icache_rsp_"+toString(i));
#endif

        PORT_MAP(_component,src , "in_ICACHE_RSP_"+toString(i)+"_VAL"        ,
                            dest, "in_ICACHE_RSP_"+toString(i)+"_VAL"        );
        PORT_MAP(_component,src ,"out_ICACHE_RSP_"+toString(i)+"_ACK"        ,
                            dest,"out_ICACHE_RSP_"+toString(i)+"_ACK"        );
        if (_param->_have_port_icache_thread_id)
        PORT_MAP(_component,src , "in_ICACHE_RSP_"+toString(i)+"_THREAD_ID"  ,
                            dest, "in_ICACHE_RSP_"+toString(i)+"_THREAD_ID"  );
        if (_param->_have_port_icache_packet_id)
        PORT_MAP(_component,src , "in_ICACHE_RSP_"+toString(i)+"_PACKET_ID"  ,
                            dest, "in_ICACHE_RSP_"+toString(i)+"_PACKET_ID"  );
        PORT_MAP(_component,src , "in_ICACHE_RSP_"+toString(i)+"_ERROR"      ,
                            dest, "in_ICACHE_RSP_"+toString(i)+"_ERROR"      );

        for (uint32_t j=0; j<_param->_icache_nb_instruction[i];++j)
          {
#ifdef POSITION
            _component->interface_map (src ,"icache_rsp_"+toString(i)+"_"+toString(j),
                                       dest,"icache_rsp_"+toString(i)+"_"+toString(j));
#endif

                            
            PORT_MAP(_component,src , "in_ICACHE_RSP_"+toString(i)+"_"+toString(j)+"_INSTRUCTION",
                                dest, "in_ICACHE_RSP_"+toString(i)+"_"+toString(j)+"_INSTRUCTION");
          }
      }

    // ~~~~~[ Interface "context_req" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    for (uint32_t i=0; i<_param->_nb_front_end; ++i)
      for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
        {
          dest = _name+"_front_end_"+toString(i);
#ifdef POSITION
          _component->interface_map (src ,"context_req_"+toString(i)+"_"+toString(j),
                                     dest,"icache_req_"                 +toString(j));
#endif

          COMPONENT_MAP(_component,src , "in_CONTEXT_REQ_"+toString(i)+"_"+toString(j)+"_VAL"      ,
                                   dest,"out_ICACHE_REQ_"                 +toString(j)+"_VAL"      );
          COMPONENT_MAP(_component,src ,"out_CONTEXT_REQ_"+toString(i)+"_"+toString(j)+"_ACK"      ,
                                   dest, "in_ICACHE_REQ_"                 +toString(j)+"_ACK"      );
//        COMPONENT_MAP(_component,src , "in_CONTEXT_REQ_"+toString(i)+"_"+toString(j)+"_THREAD_ID",
//                                 dest,"out_ICACHE_REQ_"                 +toString(j)+"_THREAD_ID");
          if (_param->_have_port_icache_packet_id)
          COMPONENT_MAP(_component,src , "in_CONTEXT_REQ_"+toString(i)+"_"+toString(j)+"_PACKET_ID",
                                   dest,"out_ICACHE_REQ_"                 +toString(j)+"_PACKET_ID");
          COMPONENT_MAP(_component,src , "in_CONTEXT_REQ_"+toString(i)+"_"+toString(j)+"_ADDRESS"  ,
                                   dest,"out_ICACHE_REQ_"                 +toString(j)+"_ADDRESS"  );
          COMPONENT_MAP(_component,src , "in_CONTEXT_REQ_"+toString(i)+"_"+toString(j)+"_TYPE"     ,
                                   dest,"out_ICACHE_REQ_"                 +toString(j)+"_TYPE"     );
        }   
    
    // ~~~~~[ Interface "context_rsp" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    for (uint32_t i=0; i<_param->_nb_front_end; ++i)
      for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
        {
          dest = _name+"_front_end_"+toString(i);
#ifdef POSITION
          _component->interface_map (src ,"context_rsp_"+toString(i)+"_"+toString(j),
                                     dest,"icache_rsp_"                 +toString(j));
#endif

          COMPONENT_MAP(_component,src ,"out_CONTEXT_RSP_"+toString(i)+"_"+toString(j)+"_VAL"        ,
                                   dest, "in_ICACHE_RSP_"                 +toString(j)+"_VAL"        );
          COMPONENT_MAP(_component,src , "in_CONTEXT_RSP_"+toString(i)+"_"+toString(j)+"_ACK"        ,
                                   dest,"out_ICACHE_RSP_"                 +toString(j)+"_ACK"        );
//        COMPONENT_MAP(_component,src ,"out_CONTEXT_RSP_"+toString(i)+"_"+toString(j)+"_THREAD_ID"  ,
//                                 dest, "in_ICACHE_RSP_"                 +toString(j)+"_THREAD_ID"  );
          if (_param->_have_port_icache_packet_id)
          COMPONENT_MAP(_component,src ,"out_CONTEXT_RSP_"+toString(i)+"_"+toString(j)+"_PACKET_ID"  ,
                                   dest, "in_ICACHE_RSP_"                 +toString(j)+"_PACKET_ID"  );
          COMPONENT_MAP(_component,src ,"out_CONTEXT_RSP_"+toString(i)+"_"+toString(j)+"_ERROR"      ,
                                   dest, "in_ICACHE_RSP_"                 +toString(j)+"_ERROR"      );

          for (uint32_t k=0; k<_param->_front_end_nb_inst_fetch[i][j];++k)
            {
#ifdef POSITION
              _component->interface_map (src ,"context_rsp_"+toString(i)+"_"+toString(j)+"_"+toString(k),
                                         dest,"icache_rsp_"                 +toString(j)+"_"+toString(k));
#endif
              
              COMPONENT_MAP(_component,src ,"out_CONTEXT_RSP_"+toString(i)+"_"+toString(j)+"_"+toString(k)+"_INSTRUCTION",
                                       dest, "in_ICACHE_RSP_"                 +toString(j)+"_"+toString(k)+"_INSTRUCTION");
            }
          
        }
    }

    // ===================================================================
    // =====[ dcache_access ]=============================================
    // ===================================================================
    {
      src = _name+"_dcache_access";
      log_printf(INFO,Core,FUNCTION,_("Instance : %s"),src.c_str());
      
      // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      {
        dest = _name;
#ifdef POSITION
        _component->interface_map (src ,"",
                                   dest,"");
#endif
        PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
        PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

    // ~~~~~[ Interface "dcache_req" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    for (uint32_t i=0; i<_param->_nb_dcache_port; ++i)
      {
        dest = _name;
#ifdef POSITION
        _component->interface_map (src ,"dcache_req_"+toString(i),
                                   dest,"dcache_req_"+toString(i));
#endif
        
        PORT_MAP(_component,src ,"out_DCACHE_REQ_"+toString(i)+"_VAL"      ,
                            dest,"out_DCACHE_REQ_"+toString(i)+"_VAL"      );
        PORT_MAP(_component,src , "in_DCACHE_REQ_"+toString(i)+"_ACK"      ,
                            dest, "in_DCACHE_REQ_"+toString(i)+"_ACK"      );
        if (_param->_have_port_dcache_thread_id)
        PORT_MAP(_component,src ,"out_DCACHE_REQ_"+toString(i)+"_THREAD_ID",
                            dest,"out_DCACHE_REQ_"+toString(i)+"_THREAD_ID");
        if (_param->_have_port_dcache_packet_id)
        PORT_MAP(_component,src ,"out_DCACHE_REQ_"+toString(i)+"_PACKET_ID",
                            dest,"out_DCACHE_REQ_"+toString(i)+"_PACKET_ID");
        PORT_MAP(_component,src ,"out_DCACHE_REQ_"+toString(i)+"_ADDRESS"  ,
                            dest,"out_DCACHE_REQ_"+toString(i)+"_ADDRESS"  );
        PORT_MAP(_component,src ,"out_DCACHE_REQ_"+toString(i)+"_WDATA"    ,
                            dest,"out_DCACHE_REQ_"+toString(i)+"_WDATA"    );
        PORT_MAP(_component,src ,"out_DCACHE_REQ_"+toString(i)+"_TYPE"     ,
                            dest,"out_DCACHE_REQ_"+toString(i)+"_TYPE"     );
      }

    // ~~~~~[ Interface "dcache_rsp" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    for (uint32_t i=0; i<_param->_nb_dcache_port; ++i)
      {
        dest = _name;
#ifdef POSITION
        _component->interface_map (src ,"dcache_rsp_"+toString(i),
                                   dest,"dcache_rsp_"+toString(i));
#endif

        PORT_MAP(_component,src , "in_DCACHE_RSP_"+toString(i)+"_VAL"        ,
                            dest, "in_DCACHE_RSP_"+toString(i)+"_VAL"        );
        PORT_MAP(_component,src ,"out_DCACHE_RSP_"+toString(i)+"_ACK"        ,
                            dest,"out_DCACHE_RSP_"+toString(i)+"_ACK"        );
        if (_param->_have_port_dcache_thread_id)
        PORT_MAP(_component,src , "in_DCACHE_RSP_"+toString(i)+"_THREAD_ID"  ,
                            dest, "in_DCACHE_RSP_"+toString(i)+"_THREAD_ID"  );
        if (_param->_have_port_dcache_packet_id)
        PORT_MAP(_component,src , "in_DCACHE_RSP_"+toString(i)+"_PACKET_ID"  ,
                            dest, "in_DCACHE_RSP_"+toString(i)+"_PACKET_ID"  );
        PORT_MAP(_component,src , "in_DCACHE_RSP_"+toString(i)+"_RDATA"      ,
                            dest, "in_DCACHE_RSP_"+toString(i)+"_RDATA"      );
        PORT_MAP(_component,src , "in_DCACHE_RSP_"+toString(i)+"_ERROR"      ,
                            dest, "in_DCACHE_RSP_"+toString(i)+"_ERROR"      );
      }
    
    // ~~~~~[ Interface "lsq_req" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_param->_execute_loop_nb_load_store_unit[i]; ++j)
        for (uint32_t k=0; k<_param->_execute_loop_nb_cache_port [i][j]; ++k)
          {
            dest = _name+"_execute_loop_"+toString(i);
#ifdef POSITION
            _component->interface_map (src ,"lsq_req_"   +toString(i)+"_"+toString(j)+"_"+toString(k),
                                       dest,"dcache_req_"                +toString(j)+"_"+toString(k));
#endif

            COMPONENT_MAP(_component,src , "in_LSQ_REQ_"   +toString(i)+"_"+toString(j)+"_"+toString(k)+"_VAL"      ,
                                     dest,"out_DCACHE_REQ_"                +toString(j)+"_"+toString(k)+"_VAL"      );
            COMPONENT_MAP(_component,src ,"out_LSQ_REQ_"   +toString(i)+"_"+toString(j)+"_"+toString(k)+"_ACK"      ,
                                     dest, "in_DCACHE_REQ_"                +toString(j)+"_"+toString(k)+"_ACK"      );
            if (_param->_have_port_dcache_thread_id)
            COMPONENT_MAP(_component,src , "in_LSQ_REQ_"   +toString(i)+"_"+toString(j)+"_"+toString(k)+"_THREAD_ID",
                                     dest,"out_DCACHE_REQ_"                +toString(j)+"_"+toString(k)+"_THREAD_ID");
            if (_param->_have_port_dcache_packet_id)
            COMPONENT_MAP(_component,src , "in_LSQ_REQ_"   +toString(i)+"_"+toString(j)+"_"+toString(k)+"_PACKET_ID",
                                     dest,"out_DCACHE_REQ_"                +toString(j)+"_"+toString(k)+"_PACKET_ID");
            COMPONENT_MAP(_component,src , "in_LSQ_REQ_"   +toString(i)+"_"+toString(j)+"_"+toString(k)+"_ADDRESS"  ,
                                     dest,"out_DCACHE_REQ_"                +toString(j)+"_"+toString(k)+"_ADDRESS"  );
            COMPONENT_MAP(_component,src , "in_LSQ_REQ_"   +toString(i)+"_"+toString(j)+"_"+toString(k)+"_WDATA"    ,
                                     dest,"out_DCACHE_REQ_"                +toString(j)+"_"+toString(k)+"_WDATA"    );
            COMPONENT_MAP(_component,src , "in_LSQ_REQ_"   +toString(i)+"_"+toString(j)+"_"+toString(k)+"_TYPE"     ,
                                     dest,"out_DCACHE_REQ_"                +toString(j)+"_"+toString(k)+"_TYPE"     );
          }

    // ~~~~~[ Interface "lsq_rsp" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_param->_execute_loop_nb_load_store_unit[i]; ++j)
        for (uint32_t k=0; k<_param->_execute_loop_nb_cache_port [i][j]; ++k)
          {
            dest = _name+"_execute_loop_"+toString(i);
#ifdef POSITION
            _component->interface_map (src ,"lsq_rsp_"   +toString(i)+"_"+toString(j)+"_"+toString(k),
                                       dest,"dcache_rsp_"                +toString(j)+"_"+toString(k));
#endif

            COMPONENT_MAP(_component,src ,"out_LSQ_RSP_"   +toString(i)+"_"+toString(j)+"_"+toString(k)+"_VAL"      ,
                                     dest, "in_DCACHE_RSP_"                +toString(j)+"_"+toString(k)+"_VAL"      );
            COMPONENT_MAP(_component,src , "in_LSQ_RSP_"   +toString(i)+"_"+toString(j)+"_"+toString(k)+"_ACK"      ,
                                     dest,"out_DCACHE_RSP_"                +toString(j)+"_"+toString(k)+"_ACK"      );
            if (_param->_have_port_dcache_thread_id)
            COMPONENT_MAP(_component,src ,"out_LSQ_RSP_"   +toString(i)+"_"+toString(j)+"_"+toString(k)+"_THREAD_ID",
                                     dest, "in_DCACHE_RSP_"                +toString(j)+"_"+toString(k)+"_THREAD_ID");
            if (_param->_have_port_dcache_packet_id)
            COMPONENT_MAP(_component,src ,"out_LSQ_RSP_"   +toString(i)+"_"+toString(j)+"_"+toString(k)+"_PACKET_ID",
                                     dest, "in_DCACHE_RSP_"                +toString(j)+"_"+toString(k)+"_PACKET_ID");
            COMPONENT_MAP(_component,src ,"out_LSQ_RSP_"   +toString(i)+"_"+toString(j)+"_"+toString(k)+"_RDATA"    ,
                                     dest, "in_DCACHE_RSP_"                +toString(j)+"_"+toString(k)+"_RDATA"    );
            COMPONENT_MAP(_component,src ,"out_LSQ_RSP_"   +toString(i)+"_"+toString(j)+"_"+toString(k)+"_ERROR"    ,
                                     dest, "in_DCACHE_RSP_"                +toString(j)+"_"+toString(k)+"_ERROR"    );
          }
    }

    // ===================================================================
    // =====[ glue ]======================================================
    // ===================================================================
    {
      src = _name+"_glue";
      log_printf(INFO,Core,FUNCTION,_("Instance : %s"),src.c_str());
      
      // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      {
        dest = _name;
#ifdef POSITION
        _component->interface_map (src ,"",
                                   dest,"");
#endif
        PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
        PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      // ~~~~~[ Interface : "rename" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~         
      // out_RENAME_FRONT_END_ID - ooo_engine. in_RENAME_FRONT_END_ID
      
      // ~~~~~[ Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~
      // out_BRANCH_COMPLETE_FRONT_END_VAL             - front_end. in_BRANCH_COMPLETE_VAL            
      //  in_BRANCH_COMPLETE_FRONT_END_ACK             - front_end.out_BRANCH_COMPLETE_ACK            
      // out_BRANCH_COMPLETE_FRONT_END_CONTEXT_ID      - front_end. in_BRANCH_COMPLETE_CONTEXT_ID     
      // out_BRANCH_COMPLETE_FRONT_END_DEPTH           - front_end. in_BRANCH_COMPLETE_DEPTH          
      // out_BRANCH_COMPLETE_FRONT_END_ADDRESS         - front_end. in_BRANCH_COMPLETE_ADDRESS        
      // out_BRANCH_COMPLETE_FRONT_END_FLAG            - front_end. in_BRANCH_COMPLETE_NO_SEQUENCE    
      //  in_BRANCH_COMPLETE_FRONT_END_MISS_PREDICTION - front_end.out_BRANCH_COMPLETE_MISS_PREDICTION
      
      //  in_BRANCH_COMPLETE_OOO_ENGINE_VAL            - ooo_engine.out_BRANCH_COMPLETE_VAL            
      // out_BRANCH_COMPLETE_OOO_ENGINE_ACK            - ooo_engine. in_BRANCH_COMPLETE_ACK            
      //  in_BRANCH_COMPLETE_OOO_ENGINE_FRONT_END_ID   - ooo_engine.out_BRANCH_COMPLETE_FRONT_END_ID   
      //  in_BRANCH_COMPLETE_OOO_ENGINE_CONTEXT_ID     - ooo_engine.out_BRANCH_COMPLETE_CONTEXT_ID     
      //  in_BRANCH_COMPLETE_OOO_ENGINE_DEPTH          - ooo_engine.out_BRANCH_COMPLETE_DEPTH          
      //  in_BRANCH_COMPLETE_OOO_ENGINE_ADDRESS        - ooo_engine.out_BRANCH_COMPLETE_ADDRESS        
      //  in_BRANCH_COMPLETE_OOO_ENGINE_FLAG           - ooo_engine.out_BRANCH_COMPLETE_NO_SEQUENCE    
      // out_BRANCH_COMPLETE_OOO_ENGINE_MISS_PREDICTION- ooo_engine. in_BRANCH_COMPLETE_MISS_PREDICTION
      
      // ~~~~~[ Interface : "commit_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      // out_COMMIT_EVENT_FRONT_END_VAL              - front_end. in_COMMIT_EVENT_VAL             
      //  in_COMMIT_EVENT_FRONT_END_ACK              - front_end.out_COMMIT_EVENT_ACK             
      // out_COMMIT_EVENT_FRONT_END_CONTEXT_ID       - front_end. in_COMMIT_EVENT_CONTEXT_ID      
      // out_COMMIT_EVENT_FRONT_END_DEPTH            - front_end. in_COMMIT_EVENT_DEPTH           
      // out_COMMIT_EVENT_FRONT_END_TYPE             - front_end. in_COMMIT_EVENT_TYPE            
      // out_COMMIT_EVENT_FRONT_END_IS_DELAY_SLOT    - front_end. in_COMMIT_EVENT_IS_DELAY_SLOT   
      // out_COMMIT_EVENT_FRONT_END_ADDRESS          - front_end. in_COMMIT_EVENT_ADDRESS         
      // out_COMMIT_EVENT_FRONT_END_ADDRESS_EPCR_VAL - front_end. in_COMMIT_EVENT_ADDRESS_EPCR_VAL
      // out_COMMIT_EVENT_FRONT_END_ADDRESS_EPCR     - front_end. in_COMMIT_EVENT_ADDRESS_EPCR    
      // out_COMMIT_EVENT_FRONT_END_ADDRESS_EEAR_VAL - front_end. in_COMMIT_EVENT_ADDRESS_EEAR_VAL
      // out_COMMIT_EVENT_FRONT_END_ADDRESS_EEAR     - front_end. in_COMMIT_EVENT_ADDRESS_EEAR    
      
      //  in_COMMIT_EVENT_OOO_ENGINE_VAL             - ooo_engine.out_COMMIT_EVENT_VAL             
      // out_COMMIT_EVENT_OOO_ENGINE_ACK             - ooo_engine. in_COMMIT_EVENT_ACK             
      //  in_COMMIT_EVENT_OOO_ENGINE_FRONT_END_ID    - ooo_engine.out_COMMIT_EVENT_FRONT_END_ID    
      //  in_COMMIT_EVENT_OOO_ENGINE_CONTEXT_ID      - ooo_engine.out_COMMIT_EVENT_CONTEXT_ID      
      //  in_COMMIT_EVENT_OOO_ENGINE_DEPTH           - ooo_engine.out_COMMIT_EVENT_DEPTH           
      //  in_COMMIT_EVENT_OOO_ENGINE_TYPE            - ooo_engine.out_COMMIT_EVENT_TYPE            
      //  in_COMMIT_EVENT_OOO_ENGINE_IS_DELAY_SLOT   - ooo_engine.out_COMMIT_EVENT_IS_DELAY_SLOT   
      //  in_COMMIT_EVENT_OOO_ENGINE_ADDRESS         - ooo_engine.out_COMMIT_EVENT_ADDRESS         
      //  in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EPCR_VAL- ooo_engine.out_COMMIT_EVENT_ADDRESS_EPCR_VAL
      //  in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EPCR    - ooo_engine.out_COMMIT_EVENT_ADDRESS_EPCR    
      //  in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EEAR_VAL- ooo_engine.out_COMMIT_EVENT_ADDRESS_EEAR_VAL
      //  in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EEAR    - ooo_engine.out_COMMIT_EVENT_ADDRESS_EEAR    
      
      // ~~~~~[ Interface : "issue" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      //  in_ISSUE_OOO_ENGINE_VAL                   - ooo_engine.out_ISSUE_VAL                  
      // out_ISSUE_OOO_ENGINE_ACK                   - ooo_engine. in_ISSUE_ACK                  
      //  in_ISSUE_OOO_ENGINE_FRONT_END_ID          - ooo_engine.out_ISSUE_FRONT_END_ID         
      //  in_ISSUE_OOO_ENGINE_CONTEXT_ID            - ooo_engine.out_ISSUE_CONTEXT_ID           
      //  in_ISSUE_OOO_ENGINE_PACKET_ID             - ooo_engine.out_ISSUE_PACKET_ID            
      //  in_ISSUE_OOO_ENGINE_TYPE                  - ooo_engine.out_ISSUE_TYPE                 
      //  in_ISSUE_OOO_ENGINE_OPERATION             - ooo_engine.out_ISSUE_OPERATION            
      //  in_ISSUE_OOO_ENGINE_STORE_QUEUE_PTR_WRITE - ooo_engine.out_ISSUE_STORE_QUEUE_PTR_WRITE
      //  in_ISSUE_OOO_ENGINE_LOAD_QUEUE_PTR_WRITE  - ooo_engine.out_ISSUE_LOAD_QUEUE_PTR_WRITE 
      //  in_ISSUE_OOO_ENGINE_HAS_IMMEDIAT          - ooo_engine.out_ISSUE_HAS_IMMEDIAT         
      //  in_ISSUE_OOO_ENGINE_IMMEDIAT              - ooo_engine.out_ISSUE_IMMEDIAT             
      //  in_ISSUE_OOO_ENGINE_READ_RA               - ooo_engine.out_ISSUE_READ_RA              
      //  in_ISSUE_OOO_ENGINE_NUM_REG_RA            - ooo_engine.out_ISSUE_NUM_REG_RA           
      //  in_ISSUE_OOO_ENGINE_READ_RB               - ooo_engine.out_ISSUE_READ_RB              
      //  in_ISSUE_OOO_ENGINE_NUM_REG_RB            - ooo_engine.out_ISSUE_NUM_REG_RB           
      //  in_ISSUE_OOO_ENGINE_READ_RC               - ooo_engine.out_ISSUE_READ_RC              
      //  in_ISSUE_OOO_ENGINE_NUM_REG_RC            - ooo_engine.out_ISSUE_NUM_REG_RC           
      //  in_ISSUE_OOO_ENGINE_WRITE_RD              - ooo_engine.out_ISSUE_WRITE_RD             
      //  in_ISSUE_OOO_ENGINE_NUM_REG_RD            - ooo_engine.out_ISSUE_NUM_REG_RD           
      //  in_ISSUE_OOO_ENGINE_WRITE_RE              - ooo_engine.out_ISSUE_WRITE_RE             
      //  in_ISSUE_OOO_ENGINE_NUM_REG_RE            - ooo_engine.out_ISSUE_NUM_REG_RE           
      
      // out_ISSUE_EXECUTE_LOOP_VAL                   - execute_loop. in_EXECUTE_LOOP_IN_VAL                  
      //  in_ISSUE_EXECUTE_LOOP_ACK                   - execute_loop. in_EXECUTE_LOOP_IN_ACK                  
      // out_ISSUE_EXECUTE_LOOP_CONTEXT_ID            - execute_loop. in_EXECUTE_LOOP_IN_CONTEXT_ID           
      // out_ISSUE_EXECUTE_LOOP_FRONT_END_ID          - execute_loop. in_EXECUTE_LOOP_IN_FRONT_END_ID         
      // out_ISSUE_EXECUTE_LOOP_OOO_ENGINE_ID         - execute_loop. in_EXECUTE_LOOP_IN_OOO_ENGINE_ID        
      // out_ISSUE_EXECUTE_LOOP_PACKET_ID             - execute_loop. in_EXECUTE_LOOP_IN_PACKET_ID            
      // out_ISSUE_EXECUTE_LOOP_OPERATION             - execute_loop. in_EXECUTE_LOOP_IN_OPERATION            
      // out_ISSUE_EXECUTE_LOOP_TYPE                  - execute_loop. in_EXECUTE_LOOP_IN_TYPE                 
      // out_ISSUE_EXECUTE_LOOP_STORE_QUEUE_PTR_WRITE - execute_loop. in_EXECUTE_LOOP_IN_STORE_QUEUE_PTR_WRITE
      // out_ISSUE_EXECUTE_LOOP_LOAD_QUEUE_PTR_WRITE  - execute_loop. in_EXECUTE_LOOP_IN_LOAD_QUEUE_PTR_WRITE 
      // out_ISSUE_EXECUTE_LOOP_HAS_IMMEDIAT          - execute_loop. in_EXECUTE_LOOP_IN_HAS_IMMEDIAT         
      // out_ISSUE_EXECUTE_LOOP_IMMEDIAT              - execute_loop. in_EXECUTE_LOOP_IN_IMMEDIAT             
      // out_ISSUE_EXECUTE_LOOP_READ_RA               - execute_loop. in_EXECUTE_LOOP_IN_READ_RA              
      // out_ISSUE_EXECUTE_LOOP_NUM_REG_RA            - execute_loop. in_EXECUTE_LOOP_IN_NUM_REG_RA           
      // out_ISSUE_EXECUTE_LOOP_READ_RB               - execute_loop. in_EXECUTE_LOOP_IN_READ_RB              
      // out_ISSUE_EXECUTE_LOOP_NUM_REG_RB            - execute_loop. in_EXECUTE_LOOP_IN_NUM_REG_RB           
      // out_ISSUE_EXECUTE_LOOP_READ_RC               - execute_loop. in_EXECUTE_LOOP_IN_READ_RC              
      // out_ISSUE_EXECUTE_LOOP_NUM_REG_RC            - execute_loop. in_EXECUTE_LOOP_IN_NUM_REG_RC           
      // out_ISSUE_EXECUTE_LOOP_WRITE_RD              - execute_loop. in_EXECUTE_LOOP_IN_WRITE_RD             
      // out_ISSUE_EXECUTE_LOOP_NUM_REG_RD            - execute_loop. in_EXECUTE_LOOP_IN_NUM_REG_RD           
      // out_ISSUE_EXECUTE_LOOP_WRITE_RE              - execute_loop. in_EXECUTE_LOOP_IN_WRITE_RE             
      // out_ISSUE_EXECUTE_LOOP_NUM_REG_RE            - execute_loop. in_EXECUTE_LOOP_IN_NUM_REG_RE           
  
  
      // ~~~~~[ Interface "execute_loop" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      //   out_EXECUTE_OOO_ENGINE_VAL          - ooo_engine. in_EXECUTE_LOOP_VAL         
      //    in_EXECUTE_OOO_ENGINE_ACK          - ooo_engine.out_EXECUTE_LOOP_ACK         
      //   out_EXECUTE_OOO_ENGINE_FRONT_END_ID - ooo_engine. in_EXECUTE_LOOP_FRONT_END_ID
      //   out_EXECUTE_OOO_ENGINE_CONTEXT_ID   - ooo_engine. in_EXECUTE_LOOP_CONTEXT_ID  
      //   out_EXECUTE_OOO_ENGINE_PACKET_ID    - ooo_engine. in_EXECUTE_LOOP_PACKET_ID   
      //// out_EXECUTE_OOO_ENGINE_TYPE         - ooo_engine. in_EXECUTE_LOOP_TYPE        
      //// out_EXECUTE_OOO_ENGINE_OPERATION    - ooo_engine. in_EXECUTE_LOOP_OPERATION   
      //   out_EXECUTE_OOO_ENGINE_FLAGS        - ooo_engine. in_EXECUTE_LOOP_FLAGS       
      //   out_EXECUTE_OOO_ENGINE_EXCEPTION    - ooo_engine. in_EXECUTE_LOOP_EXCEPTION   
      //   out_EXECUTE_OOO_ENGINE_NO_SEQUENCE  - ooo_engine. in_EXECUTE_LOOP_NO_SEQUENCE 
      //   out_EXECUTE_OOO_ENGINE_ADDRESS      - ooo_engine. in_EXECUTE_LOOP_ADDRESS     
      //   out_EXECUTE_OOO_ENGINE_DATA         - ooo_engine. in_EXECUTE_LOOP_DATA        
  
      //    in_EXECUTE_EXECUTE_LOOP_VAL           - execute_loop.out_EXECUTE_LOOP_OUT_VAL          
      //   out_EXECUTE_EXECUTE_LOOP_ACK           - execute_loop.out_EXECUTE_LOOP_OUT_ACK          
      //    in_EXECUTE_EXECUTE_LOOP_CONTEXT_ID    - execute_loop.out_EXECUTE_LOOP_OUT_CONTEXT_ID   
      //    in_EXECUTE_EXECUTE_LOOP_FRONT_END_ID  - execute_loop.out_EXECUTE_LOOP_OUT_FRONT_END_ID 
      //    in_EXECUTE_EXECUTE_LOOP_OOO_ENGINE_ID - execute_loop.out_EXECUTE_LOOP_OUT_OOO_ENGINE_ID
      //    in_EXECUTE_EXECUTE_LOOP_PACKET_ID     - execute_loop.out_EXECUTE_LOOP_OUT_PACKET_ID    
      ////  in_EXECUTE_EXECUTE_LOOP_OPERATION     - execute_loop.out_EXECUTE_LOOP_OUT_OPERATION    
      ////  in_EXECUTE_EXECUTE_LOOP_TYPE          - execute_loop.out_EXECUTE_LOOP_OUT_TYPE         
      //    in_EXECUTE_EXECUTE_LOOP_FLAGS         - execute_loop.out_EXECUTE_LOOP_OUT_FLAGS        
      //    in_EXECUTE_EXECUTE_LOOP_EXCEPTION     - execute_loop.out_EXECUTE_LOOP_OUT_EXCEPTION    
      //    in_EXECUTE_EXECUTE_LOOP_NO_SEQUENCE   - execute_loop.out_EXECUTE_LOOP_OUT_NO_SEQUENCE  
      //    in_EXECUTE_EXECUTE_LOOP_ADDRESS       - execute_loop.out_EXECUTE_LOOP_OUT_ADDRESS      
      //    in_EXECUTE_EXECUTE_LOOP_DATA          - execute_loop.out_EXECUTE_LOOP_OUT_DATA         

      // ~~~~~[ Interface "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      //  in_INSERT_OOO_ENGINE_VAL        - ooo_engine.out_INSERT_VAL       
      // out_INSERT_OOO_ENGINE_ACK        - ooo_engine. in_INSERT_ACK       
      //  in_INSERT_OOO_ENGINE_RD_USE     - ooo_engine.out_INSERT_RD_USE    
      //  in_INSERT_OOO_ENGINE_RD_NUM_REG - ooo_engine.out_INSERT_RD_NUM_REG
      //  in_INSERT_OOO_ENGINE_RE_USE     - ooo_engine.out_INSERT_RE_USE    
      //  in_INSERT_OOO_ENGINE_RE_NUM_REG - ooo_engine.out_INSERT_RE_NUM_REG
      
      // out_INSERT_EXECUTE_LOOP_VAL        - execute_loop. in_INSERT_ROB_VAL       
      //  in_INSERT_EXECUTE_LOOP_ACK        - execute_loop.out_INSERT_ROB_ACK       
      // out_INSERT_EXECUTE_LOOP_RD_USE     - execute_loop. in_INSERT_ROB_RD_USE    
      // out_INSERT_EXECUTE_LOOP_RD_NUM_REG - execute_loop. in_INSERT_ROB_RD_NUM_REG
      // out_INSERT_EXECUTE_LOOP_RE_USE     - execute_loop. in_INSERT_ROB_RE_USE    
      // out_INSERT_EXECUTE_LOOP_RE_NUM_REG - execute_loop. in_INSERT_ROB_RE_NUM_REG

    }

    // ~~~~~[ Others ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ 
#if DEBUG_Core == true
    _component->test_map(false);
#endif

#ifdef POSITION
     if (usage_is_set(_usage,USE_POSITION))
       _component->generate_file();
#endif

     log_end(Core,FUNCTION);
  };

}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              
