#ifdef SYSTEMC
/*
 * $Id: Queue_genMoore.cpp 101 2009-01-15 17:19:08Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Queue/include/Queue.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace queue {

#undef  FUNCTION
#define FUNCTION "Queue::genMoore"
  void Queue::genMoore (void)
  {
    log_printf(FUNC,Queue,FUNCTION,"Begin");

    //---------------------------------------------
    // Output
    //---------------------------------------------
    internal_INSERT_ACK = not _queue_control->full();
    internal_RETIRE_VAL = not _queue_control->empty();
    
    PORT_WRITE(out_INSERT_ACK , internal_INSERT_ACK);
    PORT_WRITE(out_RETIRE_VAL , internal_RETIRE_VAL);
    PORT_WRITE(out_RETIRE_DATA,_queue_data[(*_queue_control)[0]]);

    //---------------------------------------------
    // Slot
    //---------------------------------------------
    // Note : Slot 0 is the same slot as retire interface.
    uint32_t nb_elt = _queue_control->nb_elt();

    for (uint32_t i=0; i<_param->_nb_port_slot; ++i)
      {
        PORT_WRITE(out_SLOT_VAL  [i], i<nb_elt);
        PORT_WRITE(out_SLOT_DATA [i],_queue_data[(*_queue_control)[i]]);
      }

    //---------------------------------------------
    // Pointer
    //---------------------------------------------
    if (_param->_have_port_ptr_write)
    PORT_WRITE(out_PTR_WRITE, _queue_control->ptr_push());
    if (_param->_have_port_ptr_read )
    PORT_WRITE(out_PTR_READ , _queue_control->ptr_pop ());

    log_printf(FUNC,Queue,FUNCTION,"End");
  };

}; // end namespace queue
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
