/*
 * $Id: main.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Monolithic/SelfTest/include/test.h"

#define NB_PARAMS 5

void usage (string exec)
{
  cerr << "<Usage> " << exec << " name_instance list_params" << endl
       << "list_params is :" << endl
       << " - nb_port_read       (unsigned int)" << endl
       << " - nb_port_write      (unsigned int)" << endl
       << " - nb_port_read_write (unsigned int)" << endl
       << " - nb_word            (unsigned int)" << endl
       << " - size_word          (unsigned int)" << endl;
  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc <  2+NB_PARAMS)
    usage (argv[0]);

  const string   name               = argv[1];
  const uint32_t nb_port_read       = atoi(argv[2]);
  const uint32_t nb_port_write      = atoi(argv[3]);
  const uint32_t nb_port_read_write = atoi(argv[4]);
  const uint32_t nb_word            = atoi(argv[5]);
  const uint32_t size_word          = atoi(argv[6]);
  
  morpheo::behavioural::generic::registerfile::registerfile_monolithic::Parameters * param = new morpheo::behavioural::generic::registerfile::registerfile_monolithic::Parameters
    (nb_port_read ,
     nb_port_write,
     nb_port_read_write,
     nb_word      ,
     size_word    );
  
  test (name,param);

  return (EXIT_SUCCESS);
}
