/*
 * $Id: RegisterFile_Multi_Banked.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Multi_Banked/include/RegisterFile_Multi_Banked.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace registerfile {
namespace registerfile_multi_banked {

#undef  FUNCTION
#define FUNCTION "RegisterFile_Multi_Banked::RegisterFile_Multi_Banked"
  RegisterFile_Multi_Banked::RegisterFile_Multi_Banked 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   std::string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::generic::registerfile::registerfile_multi_banked::Parameters * param,
   Tusage_t usage):
    _name              (name)
    ,_param            (param)
    ,_usage (usage)
  {
    log_printf(FUNC,RegisterFile_Multi_Banked,FUNCTION,"Begin");

#if DEBUG_RegisterFile_Multi_Banked == true
    log_printf(INFO,RegisterFile_Multi_Banked,FUNCTION,_("<%s> Parameters"),_name.c_str());

    std::cout << *param << std::endl;
#endif    

    log_printf(INFO,RegisterFile_Multi_Banked,FUNCTION,"Allocation");
    
    allocation ();

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
        log_printf(INFO,RegisterFile_Multi_Banked,FUNCTION,"Allocation of statistics");
        
        // Allocation of statistics
        statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {	
        // generate the vhdl
        log_printf(INFO,RegisterFile_Multi_Banked,FUNCTION,"Generate the vhdl");
        
        vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {	
    // Function pointer
    if (_param->_crossbar == FULL_CROSSBAR)                             
      {
	function_transition     = &morpheo::behavioural::generic::registerfile::registerfile_multi_banked::RegisterFile_Multi_Banked::   full_crossbar_transition;
	function_genMealy_read  = &morpheo::behavioural::generic::registerfile::registerfile_multi_banked::RegisterFile_Multi_Banked::   full_crossbar_genMealy_read;
	function_genMealy_write = &morpheo::behavioural::generic::registerfile::registerfile_multi_banked::RegisterFile_Multi_Banked::   full_crossbar_genMealy_write;
      }
    else
      {
	function_transition     = &morpheo::behavioural::generic::registerfile::registerfile_multi_banked::RegisterFile_Multi_Banked::   partial_crossbar_transition;
	function_genMealy_read  = &morpheo::behavioural::generic::registerfile::registerfile_multi_banked::RegisterFile_Multi_Banked::   partial_crossbar_genMealy_read;
	function_genMealy_write = &morpheo::behavioural::generic::registerfile::registerfile_multi_banked::RegisterFile_Multi_Banked::   partial_crossbar_genMealy_write;
      }

    log_printf(INFO,RegisterFile_Multi_Banked,FUNCTION,"Method - transition");

    SC_METHOD (transition);
    dont_initialize ();
    sensitive << (*(in_CLOCK)).pos();

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
#endif    

    log_printf(INFO,RegisterFile_Multi_Banked,FUNCTION,"Method - genMealy_write");

    SC_METHOD (genMealy_read);
    dont_initialize ();
    sensitive << (*(in_CLOCK)).neg();
    for (uint32_t i=0; i<_param->_nb_port_read; i++)
      {
	sensitive << *( in_READ_VAL     [i]);
	if (_param->_have_port_address == true)
	  sensitive << *( in_READ_ADDRESS [i]);
      }

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t i=0; i<_param->_nb_port_read; i++)
      {
	(*(out_READ_ACK  [i])) (*( in_READ_VAL     [i]));
	if (_param->_have_port_address == true)
	(*(out_READ_ACK  [i])) (*( in_READ_ADDRESS [i]));
	(*(out_READ_DATA [i])) (*( in_READ_VAL     [i]));
	if (_param->_have_port_address == true)
	(*(out_READ_DATA [i])) (*( in_READ_ADDRESS [i]));
      }
//     for (uint32_t i=0; i<_param->_nb_port_read_write; i++)
//       {  
// 	(*(out_READ_WRITE_RDATA [i])) (*( in_READ_WRITE_VAL     [i]));
// 	(*(out_READ_WRITE_RDATA [i])) (*( in_READ_WRITE_RW      [i]));
// 	(*(out_READ_WRITE_RDATA [i])) (*( in_READ_WRITE_ADDRESS [i]));
//       }
#endif    

    SC_METHOD (genMealy_write);
    dont_initialize ();
    sensitive<< (*(in_CLOCK)).neg();
    for (uint32_t i=0; i<_param->_nb_port_write; i++)
      {
	sensitive << *( in_WRITE_VAL     [i])
		  << *( in_WRITE_DATA    [i]);
	if (_param->_have_port_address == true)
	  sensitive << *( in_WRITE_ADDRESS [i]);
      }

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t i=0; i<_param->_nb_port_write; i++)
      {
	(*(out_WRITE_ACK  [i])) (*( in_WRITE_VAL     [i]));
	if (_param->_have_port_address == true)
	(*(out_WRITE_ACK  [i])) (*( in_WRITE_ADDRESS [i]));
	(*(out_WRITE_ACK  [i])) (*( in_WRITE_DATA    [i]));
      }
#endif    
      }
#endif
    log_printf(FUNC,RegisterFile_Multi_Banked,FUNCTION,"End");
  };
  
#undef  FUNCTION
#define FUNCTION "RegisterFile_Multi_Banked::~RegisterFile_Multi_Banked"
  RegisterFile_Multi_Banked::~RegisterFile_Multi_Banked (void)
  {
    log_printf(FUNC,RegisterFile_Multi_Banked,FUNCTION,"Begin");

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
        log_printf(INFO,RegisterFile_Multi_Banked,FUNCTION,"Generate Statistics file");
        delete _stat;
      }
#endif

    log_printf(INFO,RegisterFile_Multi_Banked,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,RegisterFile_Multi_Banked,FUNCTION,"End");
  };

}; // end namespace registerfile_multi_banked
}; // end namespace registerfile
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
