#ifndef morpheo_behavioural_generic_sort_Parameters_h
#define morpheo_behavioural_generic_sort_Parameters_h

/*
 * $Id: Parameters.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"
#include "Behavioural/Generic/Sort/include/Types.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace sort {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t _nb_input           ;
  public : uint32_t _nb_output          ;
  public : bool     _ascending          ;
  public : uint32_t _size_data          ;
  public : bool     _have_port_index_out;
  public : bool     _have_port_data_out ;

  public : uint32_t _size_address       ;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t nb_input           ,
			uint32_t nb_output          ,
			bool     ascending          ,
			uint32_t size_data          ,
			bool     have_port_index_out,
			bool     have_port_data_out );

//public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
					    morpheo::behavioural::generic::sort::Parameters & x);
  };

}; // end namespace sort
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
