/*
 * Test_052
 *
 * end_ko : infinite_loop
 * end_ok : Write in R1 the stop address and stop an data
 *          The store in the destination of an jump
 * start  : Test l.sfges, l.sfgesi, l.sfgeu, l.sfgeui
 */
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0
_end_ko        :        
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r1 /* stop address */
_infinite_loop :        
        l.j	_infinite_loop
        l.nop

_end_ok :
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r0 /* stop address */


/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _start
_start:
        /*
              A     B    F
                         S U
         01)  2107  1981 1 1
         02)  2107 -1981 1 0
         03) -2107  1981 0 1
         04) -2107 -1981 0 0
         05)  1981  2107 0 0
         06)  1981 -2107 1 0
         07) -1981  2107 0 1
         08) -1981 -2107 1 1
         09)  1407  1407 1 1
         10)  1407 -1407 1 0
         11) -1407  1407 0 1
         12) -1407 -1407 1 1
        */

        /************/
        /* Signed   */
        /************/
        /* Register */
        l.xori  	r1,r0,  2107
        l.xori  	r2,r0,  1981
        l.sfges 	r1, r2
        l.bnf   	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0,  2107
        l.xori  	r2,r0, -1981
        l.sfges 	r1, r2
        l.bnf   	_end_ko
        l.nop   	

        l.xori  	r1,r0, -2107
        l.xori  	r2,r0,  1981
        l.sfges 	r1, r2
        l.bf    	_end_ko
        l.nop   	

        l.xori  	r1,r0, -2107
        l.xori  	r2,r0, -1981
        l.sfges 	r1, r2
        l.bf    	_end_ko
        l.nop   	
        
        l.xori  	r1,r0,  1981
        l.xori  	r2,r0,  2107
        l.sfges 	r1, r2
        l.bf    	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0,  1981
        l.xori  	r2,r0, -2107
        l.sfges 	r1, r2
        l.bnf   	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0, -1981
        l.xori  	r2,r0,  2107
        l.sfges 	r1, r2
        l.bf    	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0, -1981
        l.xori  	r2,r0, -2107
        l.sfges 	r1, r2
        l.bnf   	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0,  1407
        l.xori  	r2,r0,  1407
        l.sfges 	r1, r2
        l.bnf   	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0,  1407
        l.xori  	r2,r0, -1407
        l.sfges 	r1, r2
        l.bnf   	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0, -1407
        l.xori  	r2,r0,  1407
        l.sfges 	r1, r2
        l.bf    	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0, -1407
        l.xori  	r2,r0, -1407
        l.sfges 	r1, r2
        l.bnf   	_end_ko
        l.nop

        /* immediat */
        l.xori  	r1,r0,  2107
        l.sfgesi	r1,  1981
        l.bnf   	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0,  2107
        l.sfgesi	r1, -1981
        l.bnf   	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0, -2107
        l.sfgesi	r1,  1981
        l.bf    	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0, -2107
        l.sfgesi	r1, -1981
        l.bf    	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0,  1981
        l.sfgesi	r1,  2107
        l.bf    	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0,  1981
        l.sfgesi	r1, -2107
        l.bnf   	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0, -1981
        l.sfgesi	r1,  2107
        l.bf    	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0, -1981
        l.sfgesi	r1, -2107
        l.bnf   	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0,  1407
        l.sfgesi	r1,  1407
        l.bnf   	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0,  1407
        l.sfgesi	r1, -1407
        l.bnf   	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0, -1407
        l.sfgesi	r1,  1407
        l.bf    	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0, -1407
        l.sfgesi	r1, -1407
        l.bnf   	_end_ko
        l.nop
        
        /************/
        /* Unsigned */
        /************/
        /* Register */
        l.xori  	r1,r0,  2107
        l.xori  	r2,r0,  1981
        l.sfgeu 	r1, r2
        l.bnf   	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0,  2107
        l.xori  	r2,r0, -1981
        l.sfgeu 	r1, r2
        l.bf    	_end_ko
        l.nop   	

        l.xori  	r1,r0, -2107
        l.xori  	r2,r0,  1981
        l.sfgeu 	r1, r2
        l.bnf   	_end_ko
        l.nop   	

        l.xori  	r1,r0, -2107
        l.xori  	r2,r0, -1981
        l.sfgeu 	r1, r2
        l.bf    	_end_ko
        l.nop   	
        
        l.xori  	r1,r0,  1981
        l.xori  	r2,r0,  2107
        l.sfgeu 	r1, r2
        l.bf    	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0,  1981
        l.xori  	r2,r0, -2107
        l.sfgeu 	r1, r2
        l.bf    	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0, -1981
        l.xori  	r2,r0,  2107
        l.sfgeu 	r1, r2
        l.bnf   	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0, -1981
        l.xori  	r2,r0, -2107
        l.sfgeu 	r1, r2
        l.bnf   	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0,  1407
        l.xori  	r2,r0,  1407
        l.sfgeu 	r1, r2
        l.bnf   	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0,  1407
        l.xori  	r2,r0, -1407
        l.sfgeu 	r1, r2
        l.bf    	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0, -1407
        l.xori  	r2,r0,  1407
        l.sfgeu 	r1, r2
        l.bnf   	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0, -1407
        l.xori  	r2,r0, -1407
        l.sfgeu 	r1, r2
        l.bnf   	_end_ko
        l.nop

        /* immediat */
        l.xori  	r1,r0,  2107
        l.sfgeui	r1,  1981
        l.bnf   	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0,  2107
        l.sfgeui	r1, -1981
        l.bf    	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0, -2107
        l.sfgeui	r1,  1981
        l.bnf   	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0, -2107
        l.sfgeui	r1, -1981
        l.bf    	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0,  1981
        l.sfgeui	r1,  2107
        l.bf    	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0,  1981
        l.sfgeui	r1, -2107
        l.bf    	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0, -1981
        l.sfgeui	r1,  2107
        l.bnf   	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0, -1981
        l.sfgeui	r1, -2107
        l.bnf   	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0,  1407
        l.sfgeui	r1,  1407
        l.bnf   	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0,  1407
        l.sfgeui	r1, -1407
        l.bf    	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0, -1407
        l.sfgeui	r1,  1407
        l.bnf   	_end_ko
        l.nop   	
                	
        l.xori  	r1,r0, -1407
        l.sfgeui	r1, -1407
        l.bnf   	_end_ko
        l.nop
        
        /* end test */
        l.j     _end_ok
        l.nop
