/*
 * $Id: main.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Priority/SelfTest/include/test.h"

#define NB_PARAMS 4

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * priority                (Tpriority_t      )\n"));
  err (_(" * load_balancing          (Tload_balancing_t)\n"));
  err (_(" * nb_grp                  (uint32_t         )\n"));
  err (_(" * nb_elt         [nb_grp] (uint32_t         )\n"));
  err (_(" * nb_grp_select           (uint32_t         )\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc <= static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  string name = argv[x++];
  Tpriority_t       _priority       = fromString<Tpriority_t      >(argv[x++]);
  Tload_balancing_t _load_balancing = fromString<Tload_balancing_t>(argv[x++]);

  uint32_t          _nb_grp         = fromString<uint32_t         >(argv[x++]);

  if (argc != static_cast<int>(2+NB_PARAMS+_nb_grp))
    usage (argc, argv);

  uint32_t        * _nb_elt = new uint32_t [_nb_grp];
  for (uint32_t i=0; i<_nb_grp; i++)
    _nb_elt [i] = fromString<uint32_t>(argv[x++]);

  uint32_t          _nb_grp_select  = fromString<uint32_t         >(argv[x++]);

  int _return = EXIT_SUCCESS;
  try 
    {
      Priority * _Priority = new Priority 
	(name.c_str(),
	 _priority,
	 _load_balancing,
	 _nb_grp       ,
	 _nb_elt       ,
	 _nb_grp_select);
      
      _Priority->reset();


      std::list<select_t> * select;

      for (uint32_t i=0; i<32; i++)
	{
	  msg("Iteration [%d]\n",i);
	  _Priority->transition();
	  select = _Priority->select();
	  for (std::list<select_t>::iterator it = select->begin();
	       it != select->end();
	       it ++)
	    {
	      msg("  - [%d] %d\n",(*it).grp, (*it).elt);
	    }
	}

      delete _Priority;
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }
  
  try 
    {
      if (_return == EXIT_SUCCESS)
	TEST_OK("Priority : no error");
      else
	TEST_KO("Priority : a lot of error");
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }

  return (_return);
}
