#ifndef morpheo_behavioural_Model_h
#define morpheo_behavioural_Model_h

/*
 * $Id: Model.h 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Common/include/ErrorMorpheo.h"
#include <map>

namespace morpheo              {
namespace behavioural          {

  typedef enum
    {
      MODEL_SYSTEMC,
      MODEL_VHDL
    } model_type_t;

  typedef struct
  {
    model_type_t      type ;
    debug_verbosity_t debug;
  } model_t;
    
  class Model
  {
  private : static const model_type_t      default_type  = MODEL_SYSTEMC;
  private : static const debug_verbosity_t default_debug = DEBUG_NONE;

  private : std::map<std::string,model_t> models;

  public  :                    Model (void);
  public  :                   ~Model (void);
  public  : void              set_model (std::string component, model_type_t type, debug_verbosity_t debug);
  public  : model_type_t      get_type  (std::string component);
  public  : debug_verbosity_t get_debug (std::string component);
  public  : void              print     (void);
  };
  
}; // end namespace behavioural          

  template<> inline std::string toString<morpheo::behavioural::model_type_t>(const morpheo::behavioural::model_type_t& x)
  {
    switch (x)
      {
      case morpheo::behavioural::MODEL_SYSTEMC : return "systemc" ; break;
      case morpheo::behavioural::MODEL_VHDL    : return "vhdl"    ; break;
      default : return ""; break;
      }
  };

  template<> inline morpheo::behavioural::model_type_t fromString<morpheo::behavioural::model_type_t>(const std::string& x)
  {
    if ( (x.compare(toString(static_cast<uint32_t>(morpheo::behavioural::MODEL_SYSTEMC))) == 0) or
         (x.compare("model_systemc") == 0) or
         (x.compare("systemc") == 0)
         )
      return morpheo::behavioural::MODEL_SYSTEMC;
    if ( (x.compare(toString(static_cast<uint32_t>(morpheo::behavioural::MODEL_VHDL))) == 0) or
         (x.compare("model_vhdl") == 0) or
         (x.compare("vhdl") == 0))
      return morpheo::behavioural::MODEL_VHDL;
    throw (ERRORMORPHEO ("fromString","Unknow string : \""+x+"\"\n"));
  };

}; // end namespace morpheo              

#endif

