/*
 * Test_022
 *
 * end_ko : infinite_loop
 * end_ok : Write in R1 the stop address and stop an data
 *          The store in the destination of an jump
 * start  : Test l.jal
 */
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0
_end_ko        :        
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r1 /* stop address */
_infinite_loop :        
        l.j	_infinite_loop
        l.nop

_end_ok :
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r0 /* stop address */


/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _start
_start:
        l.and r1, r0, r0 /* counter 1 */
        l.ori r2, r0, 10 /* limit */
        l.j     _go0
        l.nop
        l.j     _end_ko
        l.nop
        
        .org 0x120
_go0    :
        l.nop
        l.nop
        l.jal   _go1
        l.sfeqi r9, 0x130
        l.j     _end_ko
        l.nop

        .org 0x140
_go2    :
        l.bnf   _end_ko
        l.nop
        l.jal   _go3
        l.sfeqi r9, 0x150
        l.j     _end_ko
        l.nop

        .org 0x160
_go1    :
        l.bnf   _end_ko
        l.nop
        l.jal   _go2
        l.sfeqi r9,0x170
        l.j     _end_ko
        l.nop

        .org 0x180
_go3    :
        l.bnf   _end_ko
        l.nop
        l.jal   _go4
        l.sfeqi r9,0x190
        l.j     _end_ko
        l.nop
        
        .org 0x200
_go4    :
        l.bnf   _end_ko
        l.nop
        l.addi  r1, r1, 1
        l.sfeq  r1, r2
        l.bf    _end_ok
        l.nop
        l.j     _go0
        l.nop
        l.j     _end_ko
        l.nop
