/*
 * $Id: Execute_loop_Glue_allocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Execute_loop_Glue/include/Execute_loop_Glue.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/Max.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace execute_loop_glue {



#undef  FUNCTION
#define FUNCTION "Execute_loop_Glue::allocation"
  void Execute_loop_Glue::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_begin(Execute_loop_Glue,FUNCTION);

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Execute_loop_Glue"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 _("Generalist interface")
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // -----[ Interface "gpr_write_write_unit" ]--------------------------
    {
      ALLOC1_INTERFACE_BEGIN("gpr_write_write_unit", IN, EAST, _("General register write (from write_unit)"), _param->_nb_gpr_write);
      
      ALLOC1_VALACK_IN ( in_GPR_WRITE_WRITE_UNIT_VAL               ,VAL);
      ALLOC1_VALACK_OUT(out_GPR_WRITE_WRITE_UNIT_ACK               ,ACK);
      ALLOC1_SIGNAL_IN ( in_GPR_WRITE_WRITE_UNIT_OOO_ENGINE_ID     ,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id);
      ALLOC1_SIGNAL_IN ( in_GPR_WRITE_WRITE_UNIT_NUM_REG           ,"num_reg"      ,Tgeneral_address_t,_param->_size_general_register);
      ALLOC1_SIGNAL_IN ( in_GPR_WRITE_WRITE_UNIT_DATA              ,"data"         ,Tgeneral_data_t   ,_param->_size_general_data);

      ALLOC1_INTERFACE_END(_param->_nb_gpr_write);
    }

    // -----[ Interface "gpr_write_register_file" ]-----------------------
    {
      ALLOC1_INTERFACE_BEGIN("gpr_write_register_file",OUT,SOUTH, _("General register write (to register file)"), _param->_nb_gpr_write);

      ALLOC1_VALACK_OUT(out_GPR_WRITE_REGISTER_FILE_VAL            ,VAL);							   
      ALLOC1_VALACK_IN ( in_GPR_WRITE_REGISTER_FILE_ACK            ,ACK);							   
      ALLOC1_SIGNAL_OUT(out_GPR_WRITE_REGISTER_FILE_OOO_ENGINE_ID  ,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id);
      ALLOC1_SIGNAL_OUT(out_GPR_WRITE_REGISTER_FILE_NUM_REG        ,"num_reg"      ,Tgeneral_address_t,_param->_size_general_register);
      ALLOC1_SIGNAL_OUT(out_GPR_WRITE_REGISTER_FILE_DATA           ,"data"         ,Tgeneral_data_t   ,_param->_size_general_data);

      ALLOC1_INTERFACE_END(_param->_nb_gpr_write);
    }

    // -----[ Interface "gpr_write_read_unit" ]---------------------------
    {
      ALLOC1_INTERFACE_BEGIN("gpr_write_read_unit",OUT,SOUTH, _("General register write (to read unit)"), _param->_nb_gpr_write);

      ALLOC1_VALACK_OUT(out_GPR_WRITE_READ_UNIT_VAL                ,VAL);							   
      ALLOC1_SIGNAL_OUT(out_GPR_WRITE_READ_UNIT_OOO_ENGINE_ID      ,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id);
      ALLOC1_SIGNAL_OUT(out_GPR_WRITE_READ_UNIT_NUM_REG            ,"num_reg"      ,Tgeneral_address_t,_param->_size_general_register);
      ALLOC1_SIGNAL_OUT(out_GPR_WRITE_READ_UNIT_DATA               ,"data"         ,Tgeneral_data_t   ,_param->_size_general_data);

      ALLOC1_INTERFACE_END(_param->_nb_gpr_write);
    }

    // -----[ Interface "spr_write_write_unit" ]--------------------------
    {
      ALLOC1_INTERFACE_BEGIN("spr_write_write_unit", IN, EAST, _("Special register write (from write_unit)"), _param->_nb_spr_write);
      
      ALLOC1_VALACK_IN ( in_SPR_WRITE_WRITE_UNIT_VAL               ,VAL);
      ALLOC1_VALACK_OUT(out_SPR_WRITE_WRITE_UNIT_ACK               ,ACK);
      ALLOC1_SIGNAL_IN ( in_SPR_WRITE_WRITE_UNIT_OOO_ENGINE_ID     ,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id);
      ALLOC1_SIGNAL_IN ( in_SPR_WRITE_WRITE_UNIT_NUM_REG           ,"num_reg"      ,Tspecial_address_t,_param->_size_special_register);
      ALLOC1_SIGNAL_IN ( in_SPR_WRITE_WRITE_UNIT_DATA              ,"data"         ,Tspecial_data_t   ,_param->_size_special_data);

      ALLOC1_INTERFACE_END(_param->_nb_spr_write);
    }

    // -----[ Interface "spr_write_register_file" ]-----------------------
    {
      ALLOC1_INTERFACE_BEGIN("spr_write_register_file",OUT,SOUTH, _("Special register write (to register file)"), _param->_nb_spr_write);

      ALLOC1_VALACK_OUT(out_SPR_WRITE_REGISTER_FILE_VAL            ,VAL);							   
      ALLOC1_VALACK_IN ( in_SPR_WRITE_REGISTER_FILE_ACK            ,ACK);							   
      ALLOC1_SIGNAL_OUT(out_SPR_WRITE_REGISTER_FILE_OOO_ENGINE_ID  ,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id);
      ALLOC1_SIGNAL_OUT(out_SPR_WRITE_REGISTER_FILE_NUM_REG        ,"num_reg"      ,Tspecial_address_t,_param->_size_special_register);
      ALLOC1_SIGNAL_OUT(out_SPR_WRITE_REGISTER_FILE_DATA           ,"data"         ,Tspecial_data_t   ,_param->_size_special_data);

      ALLOC1_INTERFACE_END(_param->_nb_spr_write);
    }

    // -----[ Interface "spr_write_read_unit" ]---------------------------
    {
      ALLOC1_INTERFACE_BEGIN("spr_write_read_unit",OUT,SOUTH, _("Special register write (to read unit)"), _param->_nb_spr_write);

      ALLOC1_VALACK_OUT(out_SPR_WRITE_READ_UNIT_VAL                ,VAL);							   
      ALLOC1_SIGNAL_OUT(out_SPR_WRITE_READ_UNIT_OOO_ENGINE_ID      ,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id);
      ALLOC1_SIGNAL_OUT(out_SPR_WRITE_READ_UNIT_NUM_REG            ,"num_reg"      ,Tspecial_address_t,_param->_size_special_register);
      ALLOC1_SIGNAL_OUT(out_SPR_WRITE_READ_UNIT_DATA               ,"data"         ,Tspecial_data_t   ,_param->_size_special_data);

      ALLOC1_INTERFACE_END(_param->_nb_spr_write);
    }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
	_component->generate_file();
#endif

    log_end(Execute_loop_Glue,FUNCTION);
  };

}; // end namespace execute_loop_glue
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
