 #ifndef morpheo_behavioural_core_multi_ooo_engine_ooo_engine_rename_unit_register_translation_unit_stat_list_unit_Stat_List_unit_h
#define morpheo_behavioural_core_multi_ooo_engine_ooo_engine_rename_unit_register_translation_unit_stat_list_unit_Stat_List_unit_h

/*
 * $Id: Stat_List_unit.h 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Stat_List_unit/include/Types.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Stat_List_unit/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace stat_list_unit {


  class Stat_List_unit 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET;

    // ~~~~~[ Interface "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )   **  in_INSERT_VAL               ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t        )   ** out_INSERT_ACK               ;//[nb_inst_insert]
  public    : SC_IN (Tcontrol_t        )   **  in_INSERT_READ_RA           ;//[nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t)   **  in_INSERT_NUM_REG_RA_PHY    ;//[nb_inst_insert]
  public    : SC_IN (Tcontrol_t        )   **  in_INSERT_READ_RB           ;//[nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t)   **  in_INSERT_NUM_REG_RB_PHY    ;//[nb_inst_insert]
  public    : SC_IN (Tcontrol_t        )   **  in_INSERT_READ_RC           ;//[nb_inst_insert]
  public    : SC_IN (Tspecial_address_t)   **  in_INSERT_NUM_REG_RC_PHY    ;//[nb_inst_insert]
  public    : SC_IN (Tcontrol_t        )   **  in_INSERT_WRITE_RD          ;//[nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t)   **  in_INSERT_NUM_REG_RD_PHY_NEW;//[nb_inst_insert]
  public    : SC_IN (Tcontrol_t        )   **  in_INSERT_WRITE_RE          ;//[nb_inst_insert]
  public    : SC_IN (Tspecial_address_t)   **  in_INSERT_NUM_REG_RE_PHY_NEW;//[nb_inst_insert]

    // ~~~~~[ Interface "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )   **  in_RETIRE_VAL               ;//[nb_inst_retire]
  public    : SC_OUT(Tcontrol_t        )   ** out_RETIRE_ACK               ;//[nb_inst_retire]
  public    : SC_IN (Tcontrol_t        )   **  in_RETIRE_RESTORE           ;//[nb_inst_retire]
  public    : SC_IN (Tcontrol_t        )   **  in_RETIRE_READ_RA           ;//[nb_inst_retire]
  public    : SC_IN (Tgeneral_address_t)   **  in_RETIRE_NUM_REG_RA_PHY    ;//[nb_inst_retire]
  public    : SC_IN (Tcontrol_t        )   **  in_RETIRE_READ_RB           ;//[nb_inst_retire]
  public    : SC_IN (Tgeneral_address_t)   **  in_RETIRE_NUM_REG_RB_PHY    ;//[nb_inst_retire]
  public    : SC_IN (Tcontrol_t        )   **  in_RETIRE_READ_RC           ;//[nb_inst_retire]
  public    : SC_IN (Tspecial_address_t)   **  in_RETIRE_NUM_REG_RC_PHY    ;//[nb_inst_retire]
  public    : SC_IN (Tcontrol_t        )   **  in_RETIRE_WRITE_RD          ;//[nb_inst_retire]
  public    : SC_IN (Tcontrol_t        )   **  in_RETIRE_RESTORE_RD_PHY_OLD;//[nb_inst_retire]
  public    : SC_IN (Tgeneral_address_t)   **  in_RETIRE_NUM_REG_RD_PHY_OLD;//[nb_inst_retire]
  public    : SC_IN (Tgeneral_address_t)   **  in_RETIRE_NUM_REG_RD_PHY_NEW;//[nb_inst_retire]
  public    : SC_IN (Tcontrol_t        )   **  in_RETIRE_WRITE_RE          ;//[nb_inst_retire]
  public    : SC_IN (Tcontrol_t        )   **  in_RETIRE_RESTORE_RE_PHY_OLD;//[nb_inst_retire]
  public    : SC_IN (Tspecial_address_t)   **  in_RETIRE_NUM_REG_RE_PHY_OLD;//[nb_inst_retire]
  public    : SC_IN (Tspecial_address_t)   **  in_RETIRE_NUM_REG_RE_PHY_NEW;//[nb_inst_retire]

    // ~~~~~[ interface : "push_gpr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t)           ** out_PUSH_GPR_VAL             ;//[nb_reg_free]
  public    : SC_IN (Tcontrol_t)           **  in_PUSH_GPR_ACK             ;//[nb_reg_free]
  public    : SC_OUT(Tgeneral_address_t)   ** out_PUSH_GPR_NUM_REG         ;//[nb_reg_free]

    // ~~~~~[ interface : "push_spr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t)           ** out_PUSH_SPR_VAL             ;//[nb_reg_free]
  public    : SC_IN (Tcontrol_t)           **  in_PUSH_SPR_ACK             ;//[nb_reg_free]
  public    : SC_OUT(Tspecial_address_t)   ** out_PUSH_SPR_NUM_REG         ;//[nb_reg_free]

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : stat_list_entry_t            ** gpr_stat_list; //[nb_bank][nb_general_register_by_bank]
  private   : stat_list_entry_t            ** spr_stat_list; //[nb_bank][nb_general_register_by_bank]

  private   : uint32_t                        reg_GPR_PTR_FREE;
  private   : uint32_t                        reg_SPR_PTR_FREE;

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  private   : Tcontrol_t                    * internal_INSERT_ACK       ;//[nb_inst_insert]
  private   : Tcontrol_t                    * internal_RETIRE_ACK       ;//[nb_inst_retire]
  private   : Tcontrol_t                    * internal_PUSH_GPR_VAL     ;//[nb_reg_free]
  private   : uint32_t                      * internal_PUSH_GPR_NUM_BANK;//[nb_reg_free]
  private   : Tcontrol_t                    * internal_PUSH_SPR_VAL     ;//[nb_reg_free]
  private   : uint32_t                      * internal_PUSH_SPR_NUM_BANK;//[nb_reg_free]
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Stat_List_unit);
#endif
  public  :          Stat_List_unit              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Stat_List_unit             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        transition                (void);
  public  : void        genMoore                  (void);
//public  : void        genMealy                  (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_declaration    (morpheo::behavioural::Parameters_Statistics * param_statistics);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace stat_list_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
