/*
 * $Id: Shifter_deallocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Shifter/include/Shifter.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace shifter {


  void Shifter::deallocation (void)
  {
    if (usage_is_set(_usage,USE_SYSTEMC))
      {	
#if (defined(STATISTICS) || defined (VHDL_TESTBENCH))
        delete     in_CLOCK;
#endif

        DELETE1_SIGNAL( in_SHIFTER_DATA       ,_param->_nb_port,_param->_size_data);
        if (_param->_shift_value == 0)
        DELETE1_SIGNAL( in_SHIFTER_SHIFT      ,_param->_nb_port,_param->_size_shift);
        if (_param->_direction == external_direction)
        DELETE1_SIGNAL( in_SHIFTER_DIRECTION  ,_param->_nb_port,1);
        if (_param->_rotate == external_rotate)
        DELETE1_SIGNAL( in_SHIFTER_TYPE       ,_param->_nb_port,1);
        if (_param->_carry == external_carry)
        DELETE1_SIGNAL( in_SHIFTER_CARRY      ,_param->_nb_port,1);
        if (_param->_carry == external_completion)
        {
        if (_param->_type_completion_bool == true)
          {
        DELETE1_SIGNAL( in_SHIFTER_CARRY_IN   ,_param->_nb_port,1);
          }
        else
          {
        DELETE1_SIGNAL( in_SHIFTER_COMPLETION ,_param->_nb_port,_param->_size_data_completion);
          }
        }
        DELETE1_SIGNAL(out_SHIFTER_DATA       ,_param->_nb_port,_param->_size_data);
      }

    delete _component;

  };

}; // end namespace shifter
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
