#ifdef SYSTEMC
/*
 * $Id: OOO_Engine_Glue_genMealy_insert_valack.cpp 110 2009-02-19 16:31:47Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/OOO_Engine_Glue/include/OOO_Engine_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace ooo_engine_glue {


#undef  FUNCTION
#define FUNCTION "OOO_Engine_Glue::genMealy_insert_valack"
  void OOO_Engine_Glue::genMealy_insert_valack (void)
  {
    log_begin(OOO_Engine_Glue,FUNCTION);
    log_function(OOO_Engine_Glue,FUNCTION,_name.c_str());

    uint32_t x=0;
    for (uint32_t i=0; i<_param->_nb_rename_unit; ++i)
      {
        // Transaction must be in-order : make in Rename_unit

        for (uint32_t j=0; j<_param->_nb_inst_insert[i]; ++j)
          {
            Tcontrol_t ack                    = PORT_READ(in_INSERT_ACK                    [x]   );
            Tcontrol_t rename_unit_val        = PORT_READ(in_INSERT_RENAME_UNIT_VAL        [i][j]);
            Tcontrol_t rename_unit_no_execute = PORT_READ(in_INSERT_RENAME_UNIT_NO_EXECUTE [i][j]);
            Tcontrol_t commit_unit_ack        = PORT_READ(in_INSERT_COMMIT_UNIT_ACK        [i][j]);
            Tcontrol_t issue_queue_ack        = PORT_READ(in_INSERT_ISSUE_QUEUE_ACK        [i][j]);
            
            // if not execute -> don't route to issue_queue
            
            Tcontrol_t val             = (
                                          rename_unit_val        and
                                          commit_unit_ack        and
                                          (rename_unit_no_execute or
                                           issue_queue_ack));
            Tcontrol_t rename_unit_ack = (
                                          ack                    and
                                          commit_unit_ack        and
                                          (rename_unit_no_execute or
                                           issue_queue_ack));
            Tcontrol_t commit_unit_val = (
                                          ack                    and
                                          rename_unit_val        and
                                          (rename_unit_no_execute or
                                           issue_queue_ack));
            Tcontrol_t issue_queue_val = (
                                          ack                    and
                                          rename_unit_val        and
                                          commit_unit_ack        and
                                          not rename_unit_no_execute);

            PORT_WRITE(out_INSERT_VAL             [x]   ,val            );
            PORT_WRITE(out_INSERT_RENAME_UNIT_ACK [i][j],rename_unit_ack);
            PORT_WRITE(out_INSERT_COMMIT_UNIT_VAL [i][j],commit_unit_val);
            PORT_WRITE(out_INSERT_ISSUE_QUEUE_VAL [i][j],issue_queue_val);

            log_printf(TRACE,OOO_Engine_Glue,FUNCTION,"  * rename_unit [%d].inst_insert[%d] -> %d",i,j,x);
            log_printf(TRACE,OOO_Engine_Glue,FUNCTION,"    * insert_val (RegisterFile)     (w) : %d",val                   );
            log_printf(TRACE,OOO_Engine_Glue,FUNCTION,"    * insert_ack (RegisterFile)     (r) : %d",ack                   );
            log_printf(TRACE,OOO_Engine_Glue,FUNCTION,"    * insert_rename_unit_val        (r) : %d",rename_unit_val       );
            log_printf(TRACE,OOO_Engine_Glue,FUNCTION,"    * insert_rename_unit_ack        (w) : %d",rename_unit_ack       );
            log_printf(TRACE,OOO_Engine_Glue,FUNCTION,"    * insert_rename_unit_no_execute (r) : %d",rename_unit_no_execute);
            log_printf(TRACE,OOO_Engine_Glue,FUNCTION,"    * insert_commit_unit_val        (w) : %d",commit_unit_val       );
            log_printf(TRACE,OOO_Engine_Glue,FUNCTION,"    * insert_commit_unit_ack        (r) : %d",commit_unit_ack       );
            log_printf(TRACE,OOO_Engine_Glue,FUNCTION,"    * insert_issue_queue_val        (w) : %d",issue_queue_val       );
            log_printf(TRACE,OOO_Engine_Glue,FUNCTION,"    * insert_issue_queue_ack        (r) : %d",issue_queue_ack       );

            x ++;
          }
      }
    
    log_end(OOO_Engine_Glue,FUNCTION);
  };

}; // end namespace ooo_engine_glue
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
