/*
 * $Id: Reexecute_unit_allocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Reexecute_unit/include/Reexecute_unit.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/Max.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace reexecute_unit {



#undef  FUNCTION
#define FUNCTION "Reexecute_unit::allocation"
  void Reexecute_unit::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_begin(Reexecute_unit,FUNCTION);

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Reexecute_unit"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 _("Generalist interface")
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface "execute_loop" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("execute_loop", IN, EAST, _("Instruction executed from execute_loop"),_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);

      _ALLOC2_VALACK_IN ( in_EXECUTE_LOOP_VAL                     ,VAL,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
      _ALLOC2_VALACK_OUT(out_EXECUTE_LOOP_ACK                     ,ACK,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
      _ALLOC2_SIGNAL_IN ( in_EXECUTE_LOOP_CONTEXT_ID              ,"context_id"  ,Tcontext_t         ,_param->_size_context_id  ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
      _ALLOC2_SIGNAL_IN ( in_EXECUTE_LOOP_FRONT_END_ID            ,"front_end_id",Tcontext_t         ,_param->_size_front_end_id,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
      _ALLOC2_SIGNAL_IN ( in_EXECUTE_LOOP_PACKET_ID               ,"packet_id"   ,Tpacket_t          ,_param->_size_rob_ptr     ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
//    _ALLOC2_SIGNAL_IN ( in_EXECUTE_LOOP_OPERATION               ,"operation"   ,Toperation_t       ,_param->_size_operation   ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
//    _ALLOC2_SIGNAL_IN ( in_EXECUTE_LOOP_TYPE                    ,"type"        ,Ttype_t            ,_param->_size_type        ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
      _ALLOC2_SIGNAL_IN ( in_EXECUTE_LOOP_FLAGS                   ,"flags"       ,Tspecial_data_t    ,_param->_size_special_data,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
      _ALLOC2_SIGNAL_IN ( in_EXECUTE_LOOP_EXCEPTION               ,"exception"   ,Texception_t       ,_param->_size_exception   ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
      _ALLOC2_SIGNAL_IN ( in_EXECUTE_LOOP_NO_SEQUENCE             ,"no_sequence" ,Tcontrol_t         ,1                         ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
      _ALLOC2_SIGNAL_IN ( in_EXECUTE_LOOP_ADDRESS                 ,"address"     ,Taddress_t         ,_param->_size_instruction_address,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
      _ALLOC2_SIGNAL_IN ( in_EXECUTE_LOOP_DATA                    ,"data"        ,Tgeneral_data_t    ,_param->_size_general_data,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);

      ALLOC2_INTERFACE_END(_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
    }

    // ~~~~~[ Interface "commit" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("commit",OUT,WEST, _("Instruction executed to Re Order Buffer"),_param->_nb_inst_commit);

      ALLOC1_VALACK_OUT(out_COMMIT_VAL                           ,VAL);
      ALLOC1_VALACK_IN ( in_COMMIT_ACK                           ,ACK);
      ALLOC1_SIGNAL_OUT(out_COMMIT_WEN                           ,"wen"         ,Tcontrol_t         ,1);
      ALLOC1_SIGNAL_OUT(out_COMMIT_CONTEXT_ID                    ,"context_id"  ,Tcontext_t         ,_param->_size_context_id  );
      ALLOC1_SIGNAL_OUT(out_COMMIT_FRONT_END_ID                  ,"front_end_id",Tcontext_t         ,_param->_size_front_end_id);
      ALLOC1_SIGNAL_OUT(out_COMMIT_PACKET_ID                     ,"packet_id"   ,Tpacket_t          ,_param->_size_rob_ptr     );
//    ALLOC1_SIGNAL_OUT(out_COMMIT_OPERATION                     ,"operation"   ,Toperation_t       ,_param->_size_operation   );
//    ALLOC1_SIGNAL_OUT(out_COMMIT_TYPE                          ,"type"        ,Ttype_t            ,_param->_size_type        );
      ALLOC1_SIGNAL_OUT(out_COMMIT_FLAGS                         ,"flags"       ,Tspecial_data_t    ,_param->_size_special_data);
      ALLOC1_SIGNAL_OUT(out_COMMIT_EXCEPTION                     ,"exception"   ,Texception_t       ,_param->_size_exception   );
      ALLOC1_SIGNAL_OUT(out_COMMIT_NO_SEQUENCE                   ,"no_sequence" ,Tcontrol_t         ,1                         );
      ALLOC1_SIGNAL_OUT(out_COMMIT_ADDRESS                       ,"address"     ,Taddress_t         ,_param->_size_instruction_address);
      ALLOC1_SIGNAL_IN ( in_COMMIT_NUM_REG_RD                    ,"num_reg_rd"  ,Tgeneral_address_t ,_param->_size_general_register);

      ALLOC1_INTERFACE_END(_param->_nb_inst_commit);
    }

    // ~~~~~[ Interface : "spr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("spr",OUT,EAST, _("Access to Special Register"), _param->_nb_inst_reexecute);

      ALLOC1_VALACK_OUT(out_SPR_VAL                              ,VAL);
      ALLOC1_VALACK_IN ( in_SPR_ACK                              ,ACK);
      ALLOC1_SIGNAL_OUT(out_SPR_WEN                              ,"wen"         ,Tcontrol_t         ,1);
      ALLOC1_SIGNAL_OUT(out_SPR_CONTEXT_ID                       ,"context_id"  ,Tcontext_t         ,_param->_size_context_id  );
      ALLOC1_SIGNAL_OUT(out_SPR_FRONT_END_ID                     ,"front_end_id",Tcontext_t         ,_param->_size_front_end_id);
      ALLOC1_SIGNAL_OUT(out_SPR_NUM_GROUP                        ,"num_group"   ,Tspr_address_t     ,_param->_size_special_address_group   );
      ALLOC1_SIGNAL_OUT(out_SPR_NUM_REG                          ,"num_reg"     ,Tspr_address_t     ,_param->_size_special_address_register);
      ALLOC1_SIGNAL_OUT(out_SPR_WDATA                            ,"wdata"       ,Tspr_t             ,_param->_size_spr);
      ALLOC1_SIGNAL_IN ( in_SPR_RDATA                            ,"rdata"       ,Tspr_t             ,_param->_size_spr);
      ALLOC1_SIGNAL_IN ( in_SPR_INVALID                          ,"invalid"     ,Tcontrol_t         ,1);

      ALLOC1_INTERFACE_END(_param->_nb_inst_reexecute);
    }

    // ~~~~~[ Interface : "reexecute_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("reexecute_rob", IN,EAST, _("Instruction reexecuted by the Re Order Buffer (Store head)"), _param->_nb_inst_reexecute);

      ALLOC1_VALACK_IN ( in_REEXECUTE_ROB_VAL                    ,VAL);
      ALLOC1_VALACK_OUT(out_REEXECUTE_ROB_ACK                    ,ACK);
      ALLOC1_SIGNAL_IN ( in_REEXECUTE_ROB_CONTEXT_ID             ,"context_id"           ,Tcontext_t         ,_param->_size_context_id);
      ALLOC1_SIGNAL_IN ( in_REEXECUTE_ROB_FRONT_END_ID           ,"front_end_id"         ,Tcontext_t         ,_param->_size_front_end_id);
      ALLOC1_SIGNAL_IN ( in_REEXECUTE_ROB_PACKET_ID              ,"packet_id"            ,Tpacket_t          ,_param->_size_rob_ptr  );
      ALLOC1_SIGNAL_IN ( in_REEXECUTE_ROB_OPERATION              ,"operation"            ,Toperation_t       ,_param->_size_operation);
      ALLOC1_SIGNAL_IN ( in_REEXECUTE_ROB_TYPE                   ,"type"                 ,Ttype_t            ,_param->_size_type);
      ALLOC1_SIGNAL_IN ( in_REEXECUTE_ROB_STORE_QUEUE_PTR_WRITE  ,"store_queue_ptr_write",Tlsq_ptr_t         ,_param->_size_store_queue_ptr);

      ALLOC1_INTERFACE_END(_param->_nb_inst_reexecute);
    }

    // ~~~~~[ Interface : "reexecute" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("reexecute",OUT,SOUTH, _("Instruction reexecute, send at the issue_queue"), _param->_nb_inst_reexecute);

      ALLOC1_VALACK_OUT(out_REEXECUTE_VAL                  ,VAL);
      ALLOC1_VALACK_IN ( in_REEXECUTE_ACK                  ,ACK);
      ALLOC1_SIGNAL_OUT(out_REEXECUTE_CONTEXT_ID           ,"context_id"           ,Tcontext_t        ,_param->_size_context_id      );
      ALLOC1_SIGNAL_OUT(out_REEXECUTE_FRONT_END_ID         ,"front_end_id"         ,Tcontext_t        ,_param->_size_front_end_id    );
      ALLOC1_SIGNAL_OUT(out_REEXECUTE_PACKET_ID            ,"packet_id"            ,Tpacket_t         ,_param->_size_rob_ptr         );
      ALLOC1_SIGNAL_OUT(out_REEXECUTE_OPERATION            ,"operation"            ,Toperation_t      ,_param->_size_operation       );
      ALLOC1_SIGNAL_OUT(out_REEXECUTE_TYPE                 ,"type"                 ,Ttype_t           ,_param->_size_type            );
      ALLOC1_SIGNAL_OUT(out_REEXECUTE_STORE_QUEUE_PTR_WRITE,"store_queue_ptr_write",Tlsq_ptr_t        ,_param->_size_store_queue_ptr );
      ALLOC1_SIGNAL_OUT(out_REEXECUTE_LOAD_QUEUE_PTR_WRITE ,"load_queue_ptr_write" ,Tlsq_ptr_t        ,_param->_size_load_queue_ptr  );
      ALLOC1_SIGNAL_OUT(out_REEXECUTE_HAS_IMMEDIAT         ,"has_immediat"         ,Tcontrol_t        ,1                             );
      ALLOC1_SIGNAL_OUT(out_REEXECUTE_IMMEDIAT             ,"immediat"             ,Tgeneral_data_t   ,_param->_size_general_data    );
      ALLOC1_SIGNAL_OUT(out_REEXECUTE_READ_RA              ,"read_ra"              ,Tcontrol_t        ,1                             );
      ALLOC1_SIGNAL_OUT(out_REEXECUTE_NUM_REG_RA           ,"num_reg_ra"           ,Tgeneral_address_t,_param->_size_general_register);
      ALLOC1_SIGNAL_OUT(out_REEXECUTE_READ_RB              ,"read_rb"              ,Tcontrol_t        ,1                             );
      ALLOC1_SIGNAL_OUT(out_REEXECUTE_NUM_REG_RB           ,"num_reg_rb"           ,Tgeneral_address_t,_param->_size_general_register);
      ALLOC1_SIGNAL_OUT(out_REEXECUTE_READ_RC              ,"read_rc"              ,Tcontrol_t        ,1                             );
      ALLOC1_SIGNAL_OUT(out_REEXECUTE_NUM_REG_RC           ,"num_reg_rc"           ,Tspecial_address_t,_param->_size_special_register);
      ALLOC1_SIGNAL_OUT(out_REEXECUTE_WRITE_RD             ,"write_rd"             ,Tcontrol_t        ,1                             );
      ALLOC1_SIGNAL_OUT(out_REEXECUTE_NUM_REG_RD           ,"num_reg_rd"           ,Tgeneral_address_t,_param->_size_general_register);
      ALLOC1_SIGNAL_OUT(out_REEXECUTE_WRITE_RE             ,"write_re"             ,Tcontrol_t        ,1                             );
      ALLOC1_SIGNAL_OUT(out_REEXECUTE_NUM_REG_RE           ,"num_reg_re"           ,Tspecial_address_t,_param->_size_special_register);

      ALLOC1_INTERFACE_END(_param->_nb_inst_reexecute);
    }

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    ALLOC1(_reexecute_queue         ,std::list<entry_t *>,_param->_nb_bank);

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    ALLOC1(internal_QUEUE_PUSH             ,Tcontrol_t,_param->_nb_bank);
    ALLOC1(internal_QUEUE_NUM_EXECUTE_LOOP ,uint32_t  ,_param->_nb_bank);
    ALLOC1(internal_QUEUE_NUM_INST_EXECUTE ,uint32_t  ,_param->_nb_bank);
    ALLOC1(internal_QUEUE_NUM_INST_COMMIT  ,uint32_t  ,_param->_nb_bank);
    ALLOC1(internal_QUEUE_INFO             ,info_t    ,_param->_nb_bank);
    ALLOC1(internal_SPR_VAL                ,Tcontrol_t,_param->_nb_inst_reexecute);
    ALLOC1(internal_REEXECUTE_ROB_ACK      ,Tcontrol_t,_param->_nb_inst_reexecute);
    ALLOC1(internal_REEXECUTE_VAL          ,Tcontrol_t,_param->_nb_inst_reexecute);
#ifdef STATISTICS
    ALLOC1(internal_COMMIT_VAL             ,Tcontrol_t,_param->_nb_inst_commit);
#endif
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    _priority_execute_loop = new generic::priority::Priority (_name+"_priority_execute_loop",
							      _param->_priority_execute_loop,
							      _param->_load_balancing ,
							      _param->_nb_execute_loop,
							      _param->_nb_inst_execute,
							      _param->_nb_execute_loop_select);

    _priority_queue_in     = new generic::priority::Priority (_name+"_priority_queue_in",
							      _param->_priority_queue_in,
							      _param->_nb_bank);

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
	_component->generate_file();
#endif

    log_end(Reexecute_unit,FUNCTION);
  };

}; // end namespace reexecute_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
