/*
 * $Id: Parameters_print.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Dependency_checking_unit/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace dependency_checking_unit {


#undef  FUNCTION
#define FUNCTION "Dependency_checking_unit::print"
  std::string Parameters::print (uint32_t depth)
  {
    log_printf(FUNC,Dependency_checking_unit,FUNCTION,"Begin");

    XML xml ("dependency_checking_unit");

    xml.balise_open("dependency_checking_unit");
    xml.singleton_begin("nb_front_end       "); xml.attribut("value",toString(_nb_front_end       )); xml.singleton_end();
    xml.singleton_begin("max_nb_context     "); xml.attribut("value",toString(_max_nb_context     )); xml.singleton_end();
    xml.singleton_begin("nb_general_register"); xml.attribut("value",toString(_nb_general_register)); xml.singleton_end();
    xml.singleton_begin("nb_special_register"); xml.attribut("value",toString(_nb_special_register)); xml.singleton_end();
    xml.singleton_begin("nb_inst_insert     "); xml.attribut("value",toString(_nb_inst_insert     )); xml.singleton_end();
    xml.balise_close();

    log_printf(FUNC,Dependency_checking_unit,FUNCTION,"End");
    
    return xml.get_body(depth);
  };

#undef  FUNCTION
#define FUNCTION "Dependency_checking_unit::operator<<"
  std::ostream& operator<< (std::ostream& output_stream ,
			    morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::dependency_checking_unit::Parameters & x)
  {
    log_printf(FUNC,Dependency_checking_unit,FUNCTION,"Begin");

    output_stream << x.print(0);
    
    log_printf(FUNC,Dependency_checking_unit,FUNCTION,"End");

    return output_stream;
  };

}; // end namespace dependency_checking_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
