#ifndef morpheo_behavioural_Parameters_h
#define morpheo_behavioural_Parameters_h

/*
 * $Id: Parameters.h 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Environment.h"
#include "Behavioural/include/Parameters_test.h"
#include "Behavioural/include/Constants.h"
#include "Behavioural/include/Test.h"
#include "Common/include/ErrorMorpheo.h"
#include "Common/include/ToString.h"
#include "Common/include/Log2.h"
#include "Common/include/Debug.h"
#include <stdint.h>
#include <iostream>
#include <math.h>

namespace morpheo     {
namespace behavioural {
  
#ifdef COPY
#error "Need COPY macro"
#endif

#define COPY(param) do {duplicate(param); param->copy();} while (0)

  // Virtual Class - Interface of each component
  class Parameters
  {
  public   :        const std::string _type;

    // -----[ fields ]----------------------------------------------------
  public   : static const uint32_t   _size_instruction              = 32;
  public   : static const uint32_t   _size_spr                      = 32;
  public   : static const uint32_t   _nb_operation                  = MAX_OPERATION;
  public   : static const uint32_t   _nb_type                       = MAX_TYPE;
  public   : static const uint32_t   _size_operation                = SIZE_OPERATION;
  public   : static const uint32_t   _size_type                     = SIZE_TYPE;     
  public   : static const uint32_t   _size_exception                = SIZE_EXCEPTION;
  public   : static const uint32_t   _size_exception_use            = SIZE_EXCEPTION_USE;
  public   : static const uint32_t   _size_exception_memory         = SIZE_EXCEPTION_MEMORY;
  public   : static const uint32_t   _size_exception_custom         = SIZE_EXCEPTION_CUSTOM;
  public   : static const uint32_t   _size_exception_alu            = SIZE_EXCEPTION_ALU   ;
  public   : static const uint32_t   _size_exception_decod          = SIZE_EXCEPTION_DECOD ;
  public   : static const uint32_t   _size_exception_ifetch         = SIZE_EXCEPTION_IFETCH;
  public   : static const uint32_t   _size_icache_type              = SIZE_ICACHE_TYPE;
  public   : static const uint32_t   _size_icache_error             = SIZE_ICACHE_ERROR;
  public   : static const uint32_t   _size_dcache_type              = SIZE_DCACHE_TYPE;
  public   : static const uint32_t   _size_dcache_error             = SIZE_DCACHE_ERROR;
  public   : static const uint32_t   _nb_general_register_logic     = 32;
  public   : static const uint32_t   _nb_special_register_logic     = NB_SPR_LOGIC;
  public   : static const uint32_t   _size_general_register_logic   = 5;
  public   : static const uint32_t   _size_special_register_logic   = LOG2_NB_SPR_LOGIC;
  public   : static const uint32_t   _size_special_address_group    = 5;
  public   : static const uint32_t   _size_special_address_register = 11;
  public   : static const uint32_t   _size_event_state              = SIZE_EVENT_STATE;
  public   : static const uint32_t   _size_event_type               = SIZE_EVENT_TYPE;
  public   : static const uint32_t   _size_branch_state             = SIZE_BRANCH_STATE;
  public   : static const uint32_t   _size_branch_condition         = SIZE_BRANCH_CONDITION;

  public   : static const uint32_t   _shift_spr_num_group           = _size_special_address_register;
  public   : static const uint32_t   _mask_spr_num_group            = 0x1f ; //        1_1111
  public   : static const uint32_t   _mask_spr_num_reg              = 0x7ff; // 111_1111_1111

    // simulation
  public  :               uint64_t   _simulation_nb_cyle                    ;
  public  :               uint64_t   _simulation_nb_instruction             ;

    // parameters depends
  public   :              uint32_t   _size_context_id                       ;
  public   :              bool       _have_port_context_id                  ;

  public   :              uint32_t   _size_front_end_id                     ;
  public   :              bool       _have_port_front_end_id                ;

  public   :              uint32_t   _size_ooo_engine_id                    ;
  public   :              bool       _have_port_ooo_engine_id               ;
                         
  public   :              uint32_t   _size_instruction_address              ;
//public   :              bool       _have_port_instruction_address         ; // always true

  public   :              uint32_t   _size_data_address                     ;
//public   :              bool       _have_port_data_address                ; // always true

  public   :              uint32_t   _size_nb_inst_decod                    ;
//public   :              bool       _have_port_nb_inst_decod               ; // always true

  public   :              uint32_t   _size_nb_inst_commit                   ;
//public   :              bool       _have_port_nb_inst_commit              ; // always true
                         
  public   :              uint32_t   _size_depth                            ;
  public   :              bool       _have_port_depth                       ;
                         
  public   :              uint32_t   _size_ifetch_queue_ptr                 ;
  public   :              bool       _have_port_ifetch_queue_ptr            ;
                         
  public   :              uint32_t   _size_inst_ifetch_ptr                  ; // nb_inst_fetch
  public   :              bool       _have_port_inst_ifetch_ptr             ;
                         
//public   :              uint32_t   _size_branch_update_prediction_id      ; // = size_depth
//public   :              bool       _have_port_branch_update_prediction_id ; // = size_depth

  public   :              uint32_t   _size_rob_ptr                          ;
  public   :              bool       _have_port_rob_ptr                     ;

  public   :              uint32_t   _size_load_queue_ptr                   ;
  public   :              bool       _have_port_load_queue_ptr              ;

  public   :              uint32_t   _size_store_queue_ptr                  ;
//public   :              bool       _have_port_store_queue_ptr             ; // always true (min = 1)

  public   :              uint32_t   _size_general_data                     ;
//public   :              bool       _have_port_general_data                ; // always true
                         
  public   :              uint32_t   _size_special_data                     ;
//public   :              bool       _have_port_special_data                ; // always true
 
  public   :              uint32_t   _size_general_register                 ;
//public   :              bool       _have_port_general_register            ; // always true

  public   :              uint32_t   _size_special_register                 ;
//public   :              bool       _have_port_special_register            ; // always true

    // -----[ methods ]---------------------------------------------------
  public   :                            Parameters (void);
  public   :                            Parameters (std::string type);
  public   : virtual                   ~Parameters ();
	
    // methods to print and test parameters
  public   : virtual std::string        print       (uint32_t depth) = 0;
  public   : virtual Parameters_test    msg_error   (void) = 0;
  public   : virtual std::string        id          (void) const {return "";}

    // methods to copy depends parameters
    // (these parameters can't be static : because can have multi instance of toplevel)
  public   : virtual void               copy        (void) = 0; 
//public   :         void               copy        (Parameters * param);
  public   :         void               duplicate   (Parameters * param);

    // methods to test
  public   :         void               test        (void);
  };
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
