#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_execute_unit_execute_unit_functionnal_unit_Functionnal_unit_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_execute_unit_execute_unit_functionnal_unit_Functionnal_unit_h

/*
 * $Id: Functionnal_unit.h 116 2009-04-30 13:51:41Z moulu $
 *
 * [ Description ]
 * 
 * This functionnal unit can treat an only request. also delay_global = max(latence, delay)
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Identification.h"

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Functionnal_unit/Operation/include/Operation.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Functionnal_unit/include/Types.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Functionnal_unit/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace functionnal_unit {


  class Functionnal_unit 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;

  private   : counter_t                      * _stat_use_functionnal_unit;
  private   : counter_t                      * _stat_average_use_functionnal_unit;
  private   : counter_t                      * _stat_percent_use_functionnal_unit;

  private   : counter_t                      * _stat_sum_delay;
  private   : counter_t                      * _stat_average_delay;

  private   : counter_t                      * _stat_sum_latence;
  private   : counter_t                      * _stat_average_latence;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface "execute_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )    *  in_EXECUTE_IN_VAL            ;
  public    : SC_OUT(Tcontrol_t        )    * out_EXECUTE_IN_ACK            ;
  public    : SC_IN (Tcontext_t        )    *  in_EXECUTE_IN_CONTEXT_ID     ;
  public    : SC_IN (Tcontext_t        )    *  in_EXECUTE_IN_FRONT_END_ID   ;
  public    : SC_IN (Tcontext_t        )    *  in_EXECUTE_IN_OOO_ENGINE_ID  ;
  public    : SC_IN (Tpacket_t         )    *  in_EXECUTE_IN_PACKET_ID      ;
  public    : SC_IN (Toperation_t      )    *  in_EXECUTE_IN_OPERATION      ;
  public    : SC_IN (Ttype_t           )    *  in_EXECUTE_IN_TYPE           ;
  public    : SC_IN (Tlsq_ptr_t        )    *  in_EXECUTE_IN_STORE_QUEUE_PTR_WRITE;
  public    : SC_IN (Tlsq_ptr_t        )    *  in_EXECUTE_IN_LOAD_QUEUE_PTR_WRITE;
  public    : SC_IN (Tcontrol_t        )    *  in_EXECUTE_IN_HAS_IMMEDIAT   ;
  public    : SC_IN (Tgeneral_data_t   )    *  in_EXECUTE_IN_IMMEDIAT       ;
  public    : SC_IN (Tgeneral_data_t   )    *  in_EXECUTE_IN_DATA_RA        ;
  public    : SC_IN (Tgeneral_data_t   )    *  in_EXECUTE_IN_DATA_RB        ;
  public    : SC_IN (Tspecial_data_t   )    *  in_EXECUTE_IN_DATA_RC        ;
  public    : SC_IN (Tcontrol_t        )    *  in_EXECUTE_IN_WRITE_RD       ;
  public    : SC_IN (Tgeneral_address_t)    *  in_EXECUTE_IN_NUM_REG_RD     ;
  public    : SC_IN (Tcontrol_t        )    *  in_EXECUTE_IN_WRITE_RE       ;
  public    : SC_IN (Tspecial_address_t)    *  in_EXECUTE_IN_NUM_REG_RE     ;

    // ~~~~~[ Interface "execute_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t        )    * out_EXECUTE_OUT_VAL            ;
  public    : SC_IN (Tcontrol_t        )    *  in_EXECUTE_OUT_ACK            ;
  public    : SC_OUT(Tcontext_t        )    * out_EXECUTE_OUT_CONTEXT_ID     ;
  public    : SC_OUT(Tcontext_t        )    * out_EXECUTE_OUT_FRONT_END_ID   ;
  public    : SC_OUT(Tcontext_t        )    * out_EXECUTE_OUT_OOO_ENGINE_ID  ;
  public    : SC_OUT(Tpacket_t         )    * out_EXECUTE_OUT_PACKET_ID      ;
//public    : SC_OUT(Toperation_t      )    * out_EXECUTE_OUT_OPERATION      ;
//public    : SC_OUT(Ttype_t           )    * out_EXECUTE_OUT_TYPE           ;
  public    : SC_OUT(Tcontrol_t        )    * out_EXECUTE_OUT_WRITE_RD       ;
  public    : SC_OUT(Tgeneral_address_t)    * out_EXECUTE_OUT_NUM_REG_RD     ;
  public    : SC_OUT(Tgeneral_data_t   )    * out_EXECUTE_OUT_DATA_RD        ;
  public    : SC_OUT(Tcontrol_t        )    * out_EXECUTE_OUT_WRITE_RE       ;
  public    : SC_OUT(Tspecial_address_t)    * out_EXECUTE_OUT_NUM_REG_RE     ;
  public    : SC_OUT(Tspecial_data_t   )    * out_EXECUTE_OUT_DATA_RE        ;
  public    : SC_OUT(Texception_t      )    * out_EXECUTE_OUT_EXCEPTION      ;
  public    : SC_OUT(Tcontrol_t        )    * out_EXECUTE_OUT_NO_SEQUENCE    ;
  public    : SC_OUT(Taddress_t        )    * out_EXECUTE_OUT_ADDRESS        ;

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  private   : Tcontrol_t                      internal_EXECUTE_IN_ACK;
  private   : Tcontrol_t                      internal_EXECUTE_OUT_VAL;
  private   : bool                            reg_BUSY_IN ;
  private   : bool                            reg_BUSY_OUT;

  private   : execute_operation_t           * _execute_operation_in ;
  private   : execute_operation_t           * _execute_operation_out;
  private   : execute_register_t         **** _execute_register;
  private   : execute_param_t               * _execute_param;
  private   : function_execute_t          *** _function_execute;
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Functionnal_unit);
#endif
  public  :          Functionnal_unit              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :             ~Functionnal_unit         (void);
					       
  private : void        allocation                (void);
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC
  public  : void        transition                (void);
  public  : void        genMoore                  (void);
  public  : void        genMealy                  (void);

#endif					       
#ifdef STATISTICS
  public  : void        statistics_declaration    (morpheo::behavioural::Parameters_Statistics * param_statistics);
#endif
					       
#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       
					       
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif

  };

  void operation_unimplemented   (execute_operation_t * op,
				  execute_register_t  * reg);

}; // end namespace functionnal_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
