/*
 * $Id: top.h 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 * Test "Write_queue"
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#define NB_ITERATION  1
#define CYCLE_MAX     (1024*NB_ITERATION)

#include "Common/include/Test.h"
#include "Common/include/Time.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Write_queue/include/Write_queue.h"

using namespace std;
using namespace morpheo;
using namespace morpheo::behavioural;
using namespace morpheo::behavioural::core;
using namespace morpheo::behavioural::core::multi_execute_loop;
using namespace morpheo::behavioural::core::multi_execute_loop::execute_loop;
using namespace morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit;
using namespace morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit;

using namespace morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue;

SC_MODULE(top)
{
#ifdef SYSTEMC
 private: sc_clock               *  in_CLOCK ;
 private: sc_signal<Tcontrol_t>  *  in_NRESET;

  private: sc_signal<Tcontrol_t        >  *  in_WRITE_QUEUE_IN_VAL           ;
  private: sc_signal<Tcontrol_t        >  * out_WRITE_QUEUE_IN_ACK           ;
  private: sc_signal<Tcontext_t        >  *  in_WRITE_QUEUE_IN_CONTEXT_ID    ;
  private: sc_signal<Tcontext_t        >  *  in_WRITE_QUEUE_IN_FRONT_END_ID  ;
  private: sc_signal<Tcontext_t        >  *  in_WRITE_QUEUE_IN_OOO_ENGINE_ID ;
  private: sc_signal<Tpacket_t         >  *  in_WRITE_QUEUE_IN_PACKET_ID     ;
//private: sc_signal<Toperation_t      >  *  in_WRITE_QUEUE_IN_OPERATION     ;
//private: sc_signal<Ttype_t           >  *  in_WRITE_QUEUE_IN_TYPE          ;
  private: sc_signal<Tcontrol_t        >  *  in_WRITE_QUEUE_IN_WRITE_RD      ;
  private: sc_signal<Tgeneral_address_t>  *  in_WRITE_QUEUE_IN_NUM_REG_RD    ;
  private: sc_signal<Tgeneral_data_t   >  *  in_WRITE_QUEUE_IN_DATA_RD       ;
  private: sc_signal<Tcontrol_t        >  *  in_WRITE_QUEUE_IN_WRITE_RE      ;
  private: sc_signal<Tspecial_address_t>  *  in_WRITE_QUEUE_IN_NUM_REG_RE    ;
  private: sc_signal<Tspecial_data_t   >  *  in_WRITE_QUEUE_IN_DATA_RE       ;
  private: sc_signal<Texception_t      >  *  in_WRITE_QUEUE_IN_EXCEPTION     ;
  private: sc_signal<Tcontrol_t        >  *  in_WRITE_QUEUE_IN_NO_SEQUENCE   ;
  private: sc_signal<Taddress_t        >  *  in_WRITE_QUEUE_IN_ADDRESS       ;
  private: sc_signal<Tcontrol_t        >  * out_WRITE_QUEUE_OUT_VAL          ;
  private: sc_signal<Tcontrol_t        >  *  in_WRITE_QUEUE_OUT_ACK          ;
  private: sc_signal<Tcontext_t        >  * out_WRITE_QUEUE_OUT_CONTEXT_ID   ;
  private: sc_signal<Tcontext_t        >  * out_WRITE_QUEUE_OUT_FRONT_END_ID ;
  private: sc_signal<Tcontext_t        >  * out_WRITE_QUEUE_OUT_OOO_ENGINE_ID;
  private: sc_signal<Tpacket_t         >  * out_WRITE_QUEUE_OUT_PACKET_ID    ;
//private: sc_signal<Toperation_t      >  * out_WRITE_QUEUE_OUT_OPERATION    ;
//private: sc_signal<Ttype_t           >  * out_WRITE_QUEUE_OUT_TYPE         ;
  private: sc_signal<Tspecial_data_t   >  * out_WRITE_QUEUE_OUT_FLAGS        ;
  private: sc_signal<Texception_t      >  * out_WRITE_QUEUE_OUT_EXCEPTION    ;
  private: sc_signal<Tcontrol_t        >  * out_WRITE_QUEUE_OUT_NO_SEQUENCE  ;
  private: sc_signal<Tgeneral_data_t   >  * out_WRITE_QUEUE_OUT_ADDRESS      ;
  private: sc_signal<Taddress_t        >  * out_WRITE_QUEUE_OUT_DATA         ;
  private: sc_signal<Tcontrol_t        > ** out_GPR_WRITE_VAL                ;
  private: sc_signal<Tcontrol_t        > **  in_GPR_WRITE_ACK                ;
  private: sc_signal<Tcontext_t        > ** out_GPR_WRITE_OOO_ENGINE_ID      ;
  private: sc_signal<Tgeneral_address_t> ** out_GPR_WRITE_NUM_REG            ;
  private: sc_signal<Tgeneral_data_t   > ** out_GPR_WRITE_DATA               ;
  private: sc_signal<Tcontrol_t        > ** out_SPR_WRITE_VAL                ;
  private: sc_signal<Tcontrol_t        > **  in_SPR_WRITE_ACK                ;
  private: sc_signal<Tcontext_t        > ** out_SPR_WRITE_OOO_ENGINE_ID      ;
  private: sc_signal<Tspecial_address_t> ** out_SPR_WRITE_NUM_REG            ;
  private: sc_signal<Tspecial_data_t   > ** out_SPR_WRITE_DATA               ;
  private: sc_signal<Tcontext_t        > ** out_BYPASS_WRITE_OOO_ENGINE_ID   ;
  private: sc_signal<Tcontrol_t        > ** out_BYPASS_WRITE_GPR_VAL         ;
  private: sc_signal<Tgeneral_address_t> ** out_BYPASS_WRITE_GPR_NUM_REG     ;
  private: sc_signal<Tgeneral_data_t   > ** out_BYPASS_WRITE_GPR_DATA        ;
  private: sc_signal<Tcontrol_t        > ** out_BYPASS_WRITE_SPR_VAL         ;
  private: sc_signal<Tspecial_address_t> ** out_BYPASS_WRITE_SPR_NUM_REG     ;
  private: sc_signal<Tspecial_data_t   > ** out_BYPASS_WRITE_SPR_DATA        ;

#endif

 private: std::string name;
 private: Tusage_t _usage;
 private: morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::Parameters * _param;
#ifdef STATISTICS
 private: morpheo::behavioural::Parameters_Statistics * _param_stat;
#endif
 private: Write_queue * component;

 private: void usage
    (
#ifdef MTI_SYSTEMC
     int argc, const char * const * argv
#else
     int argc, char * argv[]
#endif
     );
 private: void allocation   (void);
 private: void deallocation (void);
 public : void test         (void);

#ifdef MTI_SYSTEMC
  SC_CTOR(top::top);
#else
 public : top (sc_module_name module_name,int argc, char * argv[]);
#endif
 public : ~top(void);
};

  
