/*
 * $Id: Test.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Parameters.h"


namespace morpheo              {
namespace behavioural          {

  bool is_natural            (double  val )  { return ( (val >= 0) && (floor(val) == ceil(val)));};
  bool is_positive           (double  val )  { return ( (val >= 1) && (floor(val) == ceil(val)));};
  bool is_power2             (uint32_t val)  { return is_natural(::log2(static_cast<double>(val)));};
  bool is_multiple           (uint32_t val1,
			      uint32_t val2) { return is_positive((1.0*val1)/(1.0*val2));};
  bool is_between_inclusive  (uint32_t val,
			      uint32_t min,
			      uint32_t max)  { return ((val >= min) && (val <= max));};
  bool is_between_exclusive  (uint32_t val,
			      uint32_t min,
			      uint32_t max)  { return ((val >  min) && (val <  max));};
}; // end namespace behavioural          
}; // end namespace morpheo              
