#include "../include/Environment.h"

namespace environment {

  std::ostream& operator<< (std::ostream& output, Environment &x)
  {
    output << "<" << x.name << ">" << std::endl
	   << " * nb_iport : " << x.param->nb_iport << std::endl
	   << " * nb_dport : " << x.param->nb_dport << std::endl
      ;

    for (uint32_t i=0; i<x.param->nb_entity; i++)
      output << " * iaccess_nb_context       ["<<i<<"] : " << x.param->iaccess_nb_context     [i] << std::endl
	     << " * iaccess_nb_instruction   ["<<i<<"] : " << x.param->iaccess_nb_instruction [i] << std::endl
	     << " * iaccess_nb_packet        ["<<i<<"] : " << x.param->iaccess_nb_packet      [i] << std::endl
	     << " * iaccess_size_address     ["<<i<<"] : " << x.param->iaccess_size_address   [i] << std::endl
	     << " * iaccess_size_instruction ["<<i<<"] : " << x.param->iaccess_size_instruction [i] << std::endl
	;

    for (uint32_t i=0; i<x.param->nb_entity; i++)
      output << " * daccess_nb_context       ["<<i<<"] : " << x.param->daccess_nb_context     [i] << std::endl
	     << " * daccess_nb_packet        ["<<i<<"] : " << x.param->daccess_nb_packet      [i] << std::endl
	     << " * daccess_size_address     ["<<i<<"] : " << x.param->daccess_size_address   [i] << std::endl
	     << " * daccess_size_data        ["<<i<<"] : " << x.param->daccess_size_data      [i] << std::endl
	;

      output << "  -----[ component_data ]-----------------------------------" << std::endl;
      output << *x.component_data << std::endl;
	    
      output << "  -----[ component_cache ]----------------------------------" << std::endl;
      output << *x.component_cache;

      output << "  -----[ component_buffer_irsp ]----------------------------" << std::endl;
      for (uint32_t i = 0; i < x.param->nb_entity; i++)
	output << *x.component_buffer_irsp [i];
      
      output << "  -----[ component_buffer_drsp ]----------------------------" << std::endl;
      for (uint32_t i = 0; i < x.param->nb_entity; i++)
	output << *x.component_buffer_drsp [i];

      output << "  -----[ component_ramlock ]--------------------------------" << std::endl;
      output << "  * nb_component_ramlock : " << x.param->nb_component_ramlock << std::endl;
      for (uint32_t it = 0; it < x.param->nb_component_ramlock; it++)
      	output << *x.component_ramlock [it];      
      
      output << "  -----[ component_tty ]------------------------------------" << std::endl;
      output << "  * nb_component_tty     : " << x.param->nb_component_tty     << std::endl;
      for (uint32_t it = 0; it < x.param->nb_component_tty    ; it++)
      	output << *x.component_tty     [it];
      
      output << *x.component_sim2os;
      
      return output;

  }
};
