#ifndef morpheo_behavioural_core_multi_front_end_front_end_decod_unit_decod_queue_Parameters_h
#define morpheo_behavioural_core_multi_front_end_front_end_decod_unit_decod_queue_Parameters_h

/*
 * $Id: Parameters.h 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod_queue/include/Types.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod_queue {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t              _nb_context             ;
  public : uint32_t              _nb_inst_decod          ;
  public : uint32_t              _size_queue             ;
  public : Tdecod_queue_scheme_t _queue_scheme           ;
//public : uint32_t              _size_general_data      ;
  public : uint32_t            * _nb_branch_speculated   ; //[nb_context]
  public : uint32_t              _nb_instruction_in_queue;
    
  public : uint32_t              _nb_bank;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t              nb_context          ,
			uint32_t              nb_inst_decod       ,
			uint32_t              size_queue          ,
                        Tdecod_queue_scheme_t queue_scheme        ,
			uint32_t              size_general_data   ,
			uint32_t            * nb_branch_speculated,
                        bool                  is_toplevel=false   );
//   public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
					      morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::Parameters & x);
  };

}; // end namespace decod_queue
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
