#ifndef morpheo_behavioural_core_multi_ooo_engine_ooo_engine_reexecute_unit_Reexecute_unit_h
#define morpheo_behavioural_core_multi_ooo_engine_ooo_engine_reexecute_unit_Reexecute_unit_h

/*
 * $Id: Reexecute_unit.h 117 2009-05-16 14:42:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif


#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Reexecute_unit/include/Parameters.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Reexecute_unit/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include "Behavioural/Generic/Priority/include/Priority.h"

#include <iostream>

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace reexecute_unit {


  class Reexecute_unit 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
  private   : counter_t                     ** _stat_bank_nb_inst;
  private   : counter_t                      * _stat_nb_inst_commit;
  private   : counter_t                      * _stat_nb_inst_reexecute;
  private   : counter_t                      * _stat_nb_spr_access;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface "execute_loop" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         ) ***  in_EXECUTE_LOOP_VAL                     ;//[nb_execute_loop][nb_inst_execute]
  public    : SC_OUT(Tcontrol_t         ) *** out_EXECUTE_LOOP_ACK                     ;//[nb_execute_loop][nb_inst_execute]
  public    : SC_IN (Tcontext_t         ) ***  in_EXECUTE_LOOP_CONTEXT_ID              ;//[nb_execute_loop][nb_inst_execute]
  public    : SC_IN (Tcontext_t         ) ***  in_EXECUTE_LOOP_FRONT_END_ID            ;//[nb_execute_loop][nb_inst_execute]
  public    : SC_IN (Tpacket_t          ) ***  in_EXECUTE_LOOP_PACKET_ID               ;//[nb_execute_loop][nb_inst_execute]
//public    : SC_IN (Toperation_t       ) ***  in_EXECUTE_LOOP_OPERATION               ;//[nb_execute_loop][nb_inst_execute]
//public    : SC_IN (Ttype_t            ) ***  in_EXECUTE_LOOP_TYPE                    ;//[nb_execute_loop][nb_inst_execute]
  public    : SC_IN (Tspecial_data_t    ) ***  in_EXECUTE_LOOP_FLAGS                   ;//[nb_execute_loop][nb_inst_execute]
  public    : SC_IN (Texception_t       ) ***  in_EXECUTE_LOOP_EXCEPTION               ;//[nb_execute_loop][nb_inst_execute]
  public    : SC_IN (Tcontrol_t         ) ***  in_EXECUTE_LOOP_NO_SEQUENCE             ;//[nb_execute_loop][nb_inst_execute]
  public    : SC_IN (Taddress_t         ) ***  in_EXECUTE_LOOP_ADDRESS                 ;//[nb_execute_loop][nb_inst_execute]
  public    : SC_IN (Tgeneral_data_t    ) ***  in_EXECUTE_LOOP_DATA                    ;//[nb_execute_loop][nb_inst_execute]

    // ~~~~~[ Interface "commit" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t         )  ** out_COMMIT_VAL                           ;//[nb_inst_commit]
  public    : SC_IN (Tcontrol_t         )  **  in_COMMIT_ACK                           ;//[nb_inst_commit]
  public    : SC_OUT(Tcontrol_t         )  ** out_COMMIT_WEN                           ;//[nb_inst_commit]
//public    : SC_OUT(Tcontext_t         )  ** out_COMMIT_CONTEXT_ID                    ;//[nb_inst_commit]
//public    : SC_OUT(Tcontext_t         )  ** out_COMMIT_FRONT_END_ID                  ;//[nb_inst_commit]
  public    : SC_OUT(Tpacket_t          )  ** out_COMMIT_PACKET_ID                     ;//[nb_inst_commit]
//public    : SC_OUT(Toperation_t       )  ** out_COMMIT_OPERATION                     ;//[nb_inst_commit]
//public    : SC_OUT(Ttype_t            )  ** out_COMMIT_TYPE                          ;//[nb_inst_commit]
  public    : SC_OUT(Tspecial_data_t    )  ** out_COMMIT_FLAGS                         ;//[nb_inst_commit]
  public    : SC_OUT(Texception_t       )  ** out_COMMIT_EXCEPTION                     ;//[nb_inst_commit]
  public    : SC_OUT(Tcontrol_t         )  ** out_COMMIT_NO_SEQUENCE                   ;//[nb_inst_commit]
  public    : SC_OUT(Taddress_t         )  ** out_COMMIT_ADDRESS                       ;//[nb_inst_commit]
  public    : SC_IN (Tgeneral_address_t )  **  in_COMMIT_NUM_REG_RD                    ;//[nb_inst_commit]

    // ~~~~~[ Interface : "spr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t         )  ** out_SPR_VAL                              ;//[nb_inst_reexecute]
  public    : SC_IN (Tcontrol_t         )  **  in_SPR_ACK                              ;//[nb_inst_reexecute]
  public    : SC_OUT(Tcontrol_t         )  ** out_SPR_WEN                              ;//[nb_inst_reexecute]
  public    : SC_OUT(Tcontext_t         )  ** out_SPR_CONTEXT_ID                       ;//[nb_inst_reexecute]
  public    : SC_OUT(Tcontext_t         )  ** out_SPR_FRONT_END_ID                     ;//[nb_inst_reexecute]
  public    : SC_OUT(Tspr_address_t     )  ** out_SPR_NUM_GROUP                        ;//[nb_inst_reexecute]
  public    : SC_OUT(Tspr_address_t     )  ** out_SPR_NUM_REG                          ;//[nb_inst_reexecute]
  public    : SC_OUT(Tspr_t             )  ** out_SPR_WDATA                            ;//[nb_inst_reexecute]
  public    : SC_IN (Tspr_t             )  **  in_SPR_RDATA                            ;//[nb_inst_reexecute]
  public    : SC_IN (Tcontrol_t         )  **  in_SPR_INVALID                          ;//[nb_inst_reexecute]

    // ~~~~~[ Interface : "reexecute_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         )  **  in_REEXECUTE_ROB_VAL                    ;//[nb_inst_reexecute]
  public    : SC_OUT(Tcontrol_t         )  ** out_REEXECUTE_ROB_ACK                    ;//[nb_inst_reexecute]
  public    : SC_IN (Tcontext_t         )  **  in_REEXECUTE_ROB_CONTEXT_ID             ;//[nb_inst_reexecute]
  public    : SC_IN (Tcontext_t         )  **  in_REEXECUTE_ROB_FRONT_END_ID           ;//[nb_inst_reexecute]
  public    : SC_IN (Tpacket_t          )  **  in_REEXECUTE_ROB_PACKET_ID              ;//[nb_inst_reexecute]
  public    : SC_IN (Toperation_t       )  **  in_REEXECUTE_ROB_OPERATION              ;//[nb_inst_reexecute]
  public    : SC_IN (Ttype_t            )  **  in_REEXECUTE_ROB_TYPE                   ;//[nb_inst_reexecute]
  public    : SC_IN (Tlsq_ptr_t         )  **  in_REEXECUTE_ROB_STORE_QUEUE_PTR_WRITE  ;//[nb_inst_reexecute]

    // ~~~~~[ Interface : "reexecute" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t         )  ** out_REEXECUTE_VAL                        ;//[nb_inst_reexecute]
  public    : SC_IN (Tcontrol_t         )  **  in_REEXECUTE_ACK                        ;//[nb_inst_reexecute]
  public    : SC_OUT(Tcontext_t         )  ** out_REEXECUTE_CONTEXT_ID                 ;//[nb_inst_reexecute]
  public    : SC_OUT(Tcontext_t         )  ** out_REEXECUTE_FRONT_END_ID               ;//[nb_inst_reexecute]
  public    : SC_OUT(Tpacket_t          )  ** out_REEXECUTE_PACKET_ID                  ;//[nb_inst_reexecute]
  public    : SC_OUT(Toperation_t       )  ** out_REEXECUTE_OPERATION                  ;//[nb_inst_reexecute]
  public    : SC_OUT(Ttype_t            )  ** out_REEXECUTE_TYPE                       ;//[nb_inst_reexecute]
  public    : SC_OUT(Tlsq_ptr_t         )  ** out_REEXECUTE_STORE_QUEUE_PTR_WRITE      ;//[nb_inst_reexecute]
  public    : SC_OUT(Tlsq_ptr_t         )  ** out_REEXECUTE_LOAD_QUEUE_PTR_WRITE       ;//[nb_inst_reexecute] //*
  public    : SC_OUT(Tcontrol_t         )  ** out_REEXECUTE_HAS_IMMEDIAT               ;//[nb_inst_reexecute]
  public    : SC_OUT(Tgeneral_data_t    )  ** out_REEXECUTE_IMMEDIAT                   ;//[nb_inst_reexecute]
  public    : SC_OUT(Tcontrol_t         )  ** out_REEXECUTE_READ_RA                    ;//[nb_inst_reexecute] //*
  public    : SC_OUT(Tgeneral_address_t )  ** out_REEXECUTE_NUM_REG_RA                 ;//[nb_inst_reexecute] //*
  public    : SC_OUT(Tcontrol_t         )  ** out_REEXECUTE_READ_RB                    ;//[nb_inst_reexecute] //*
  public    : SC_OUT(Tgeneral_address_t )  ** out_REEXECUTE_NUM_REG_RB                 ;//[nb_inst_reexecute] //*
  public    : SC_OUT(Tcontrol_t         )  ** out_REEXECUTE_READ_RC                    ;//[nb_inst_reexecute] //*
  public    : SC_OUT(Tspecial_address_t )  ** out_REEXECUTE_NUM_REG_RC                 ;//[nb_inst_reexecute] //*
  public    : SC_OUT(Tcontrol_t         )  ** out_REEXECUTE_WRITE_RD                   ;//[nb_inst_reexecute]
  public    : SC_OUT(Tgeneral_address_t )  ** out_REEXECUTE_NUM_REG_RD                 ;//[nb_inst_reexecute]
  public    : SC_OUT(Tcontrol_t         )  ** out_REEXECUTE_WRITE_RE                   ;//[nb_inst_reexecute] //*
  public    : SC_OUT(Tspecial_address_t )  ** out_REEXECUTE_NUM_REG_RE                 ;//[nb_inst_reexecute] //*

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : generic::priority::Priority   * _priority_execute_loop;
  private   : generic::priority::Priority   * _priority_queue_in    ;

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : std::list<entry_t *>          * _reexecute_queue                         ;//[nb_bank]

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : Tcontrol_t                    * internal_QUEUE_PUSH                      ;//[nb_bank]
  public    : uint32_t                      * internal_QUEUE_NUM_EXECUTE_LOOP          ;//[nb_bank]
  public    : uint32_t                      * internal_QUEUE_NUM_INST_EXECUTE          ;//[nb_bank]
  public    : uint32_t                      * internal_QUEUE_NUM_INST_COMMIT           ;//[nb_bank]
  public    : info_t                        * internal_QUEUE_INFO                      ;//[nb_bank]
  public    : Tcontrol_t                    * internal_SPR_VAL                         ;//[nb_inst_reexecute]
  public    : Tcontrol_t                    * internal_REEXECUTE_ROB_ACK               ;//[nb_inst_reexecute]
  public    : Tcontrol_t                    * internal_REEXECUTE_VAL                   ;//[nb_inst_reexecute]
#ifdef STATISTICS
  public    : Tcontrol_t                    * internal_COMMIT_VAL                      ;//[nb_inst_commit]
#endif

#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Reexecute_unit);
#endif
  public  :          Reexecute_unit              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Reexecute_unit             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  private : bool        must_reexecute            (Tspr_address_t address, info_t & info);

  public  : void        transition                (void);
  public  : void        genMoore                  (void);
  public  : void        genMealy_reexecute        (void);
  public  : void        genMealy_commit           (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace reexecute_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
