#ifdef SYSTEMC
/*
 * $Id: Register_Address_Translation_unit_genMealy_rename.cpp 100 2009-01-08 13:06:27Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Register_Address_Translation_unit/include/Register_Address_Translation_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace register_address_translation_unit {


#undef  FUNCTION
#define FUNCTION "Register_Address_Translation_unit::genMealy_rename"
  void Register_Address_Translation_unit::genMealy_rename (void)
  {
    log_begin(Register_Address_Translation_unit,FUNCTION);
    log_function(Register_Address_Translation_unit,FUNCTION,_name.c_str());

    for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
      if (PORT_READ(in_RENAME_VAL [i])) // not in sensitive list : it's to have valide value to array access
      {
        log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"  * RENAME [%d]",i);

	Tcontext_t front_end_id = (_param->_have_port_front_end_id)?PORT_READ(in_RENAME_FRONT_END_ID [i]):0;
	Tcontext_t context_id   = (_param->_have_port_context_id  )?PORT_READ(in_RENAME_CONTEXT_ID   [i]):0;

        log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * front_end_id       : %d",front_end_id);
        log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * context_id         : %d",context_id);

        Tgeneral_address_t num_reg_ra_log    = PORT_READ(in_RENAME_NUM_REG_RA_LOG [i]); //%_param->_nb_general_register;
        Tgeneral_address_t num_reg_rb_log    = PORT_READ(in_RENAME_NUM_REG_RB_LOG [i]); //%_param->_nb_general_register;
        Tspecial_address_t num_reg_rc_log    = PORT_READ(in_RENAME_NUM_REG_RC_LOG [i]); //%_param->_nb_special_register;
        Tgeneral_address_t num_reg_rd_log    = PORT_READ(in_RENAME_NUM_REG_RD_LOG [i]); //%_param->_nb_general_register;
        Tspecial_address_t num_reg_re_log    = PORT_READ(in_RENAME_NUM_REG_RE_LOG [i]); //%_param->_nb_special_register;
                                            
        Tgeneral_address_t num_reg_ra_phy    = rat_gpr[front_end_id][context_id][num_reg_ra_log];
        Tgeneral_address_t num_reg_rb_phy    = rat_gpr[front_end_id][context_id][num_reg_rb_log];
        Tspecial_address_t num_reg_rc_phy    = rat_spr[front_end_id][context_id][num_reg_rc_log];
        Tgeneral_address_t num_reg_rd_phy_old= rat_gpr[front_end_id][context_id][num_reg_rd_log];
        Tspecial_address_t num_reg_re_phy_old= rat_spr[front_end_id][context_id][num_reg_re_log];

        log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_ra         : %d -> %d",num_reg_ra_log,num_reg_ra_phy    );
        log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_rb         : %d -> %d",num_reg_rb_log,num_reg_rb_phy    );
        log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_rc         : %d -> %d",num_reg_rc_log,num_reg_rc_phy    );
        log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_rd         : %d -> %d",num_reg_rd_log,num_reg_rd_phy_old);
        log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_re         : %d -> %d",num_reg_re_log,num_reg_re_phy_old);
        

	PORT_WRITE(out_RENAME_NUM_REG_RA_PHY     [i], num_reg_ra_phy    );
	PORT_WRITE(out_RENAME_NUM_REG_RB_PHY     [i], num_reg_rb_phy    );
	PORT_WRITE(out_RENAME_NUM_REG_RC_PHY     [i], num_reg_rc_phy    );
	PORT_WRITE(out_RENAME_NUM_REG_RD_PHY_OLD [i], num_reg_rd_phy_old);
	PORT_WRITE(out_RENAME_NUM_REG_RE_PHY_OLD [i], num_reg_re_phy_old);
      }

    log_end(Register_Address_Translation_unit,FUNCTION);
  };

}; // end namespace register_address_translation_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
