#!/bin/bash

#-----------------------------------------------------------
# $Id: execute_n.sh 112 2009-03-18 22:36:26Z rosiere $
#-----------------------------------------------------------

#-----[ global variable ]-----------------------------------

#-----[ nb_cpu ]--------------------------------------------
function nb_cpu ()
{
    local FILE_CPUINFO=/proc/cpuinfo;
    if test ! -f ${FILE_CPUINFO}; then
	echo "\"${FILE_CPUINFO}\" don't exist."
	usage;
    fi;

    #eval "${1}=`grep -c \"processor\" ${FILE_CPUINFO}`";
    grep -c "processor" ${FILE_CPUINFO};
}

#-----[ execute_n_usage ]-----------------------------------
function execute_n_usage ()
{
    echo "Usage     : ${0} word_dir file [ nb_process ]";
    echo "Arguments : ";
    echo " * work_dir   : directory to execute command";
    echo " * file       : list of command";
    echo " * nb_process : number of process (default (and maximum) is the number of processor)";
    echo "";
    echo "Note      : ";
    echo " * This script, for each command, create a directory : Task_X (X is the number of command), and execute the command in this directory.";
    echo " * Two file is generate : \"output\" is the output of the execution, and \"command\" is the command lunch.";
#   echo " * A command empty (no command on a line of file) is a synchronisation with all process"
    echo " * Don't forgot the final end of line (else the last command is not executed)";
    echo "";
    exit;
}

#-----[ execute_n_test_usage ]------------------------------
function execute_n_test_usage ()
{
    if test ${#} -ne 2 -a ${#} -ne 3; then
	execute_n_usage;
    fi;

    if test ! -d ${1}; then
        echo "Directory ${1} is invalid";
    fi;

    if test -z "${MORPHEO_SCRIPT}"; then
        echo "Environment variable MORPHEO_SCRIPT is not set";
        distexe_usage;
    fi;

    if test ! -f ${2}; then
	echo "File \"${2}\" don't exist";
	execute_n_usage;
    fi;

    if test ! -s ${2}; then
	echo "File \"${2}\" is empty";
	execute_n_usage;
    fi;
}

#-----[ execute_n_main ]------------------------------------
function execute_n ()
{
    local -i NB_PROCESS=$(nb_cpu);
    local -i CPT;
    local    WORK_DIR=${1};
    local    FILE_CMD=${2};
    local    FILE_CPT;
    local    FILE_CPU;
    local    ID="cpu-${HOSTNAME}-$$"

    execute_n_test_usage ${*};

    if test ${#} -eq 2; then
	if test ${3} -lt ${NB_PROCESS}; then
	    NB_PROCESS=${3};
	fi;
    fi;

    FILE_CPT="${WORK_DIR}/control-"$(basename ${FILE_CMD});
    FILE_CPU="${WORK_DIR}/${ID}";

    echo "  * <${HOSTNAME}> ${NB_PROCESS} process";

    local -i IT_NB_PROCESS=1;
    local -i PID=$$;

    echo "${NB_PROCESS}" > ${FILE_CPU};

    # create the same number of thread that processor
    while test ${IT_NB_PROCESS} -le ${NB_PROCESS}; do
	${MORPHEO_SCRIPT}/execute.sh ${WORK_DIR} ${FILE_CMD} ${FILE_CPT} ${FILE_CPU} &
	IT_NB_PROCESS=$((${IT_NB_PROCESS}+1));

	if test "$$" -ne ${PID}; then
	    break;
	fi;
    done
}

#-----[ Corps ]---------------------------------------------
execute_n ${*};
