/*
 * $Id: OOO_Engine_deallocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/include/OOO_Engine.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {


#undef  FUNCTION
#define FUNCTION "OOO_Engine::deallocation"
  void OOO_Engine::deallocation (void)
  {
    log_begin(OOO_Engine,FUNCTION);

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

        DELETE2_SIGNAL( in_RENAME_VAL                       ,_param->_nb_front_end,_param->_nb_inst_decod[it1],1                                    );
        DELETE2_SIGNAL(out_RENAME_ACK                       ,_param->_nb_front_end,_param->_nb_inst_decod[it1],1                                    );
        DELETE2_SIGNAL( in_RENAME_FRONT_END_ID              ,_param->_nb_front_end,_param->_nb_inst_decod[it1],_param->_size_front_end_id           );
        DELETE2_SIGNAL( in_RENAME_CONTEXT_ID                ,_param->_nb_front_end,_param->_nb_inst_decod[it1],_param->_size_context_id             );
        DELETE2_SIGNAL( in_RENAME_DEPTH                     ,_param->_nb_front_end,_param->_nb_inst_decod[it1],_param->_size_depth                  );
        DELETE2_SIGNAL( in_RENAME_TYPE                      ,_param->_nb_front_end,_param->_nb_inst_decod[it1],_param->_size_type                   );
        DELETE2_SIGNAL( in_RENAME_OPERATION                 ,_param->_nb_front_end,_param->_nb_inst_decod[it1],_param->_size_operation              );
        DELETE2_SIGNAL( in_RENAME_NO_EXECUTE                ,_param->_nb_front_end,_param->_nb_inst_decod[it1],1                                    );
        DELETE2_SIGNAL( in_RENAME_IS_DELAY_SLOT             ,_param->_nb_front_end,_param->_nb_inst_decod[it1],1                                    );
#ifdef DEBUG
        DELETE2_SIGNAL( in_RENAME_ADDRESS                   ,_param->_nb_front_end,_param->_nb_inst_decod[it1],_param->_size_instruction_address    );
#endif
        DELETE2_SIGNAL( in_RENAME_ADDRESS_NEXT              ,_param->_nb_front_end,_param->_nb_inst_decod[it1],_param->_size_instruction_address    );
        DELETE2_SIGNAL( in_RENAME_HAS_IMMEDIAT              ,_param->_nb_front_end,_param->_nb_inst_decod[it1],1                                    );
        DELETE2_SIGNAL( in_RENAME_IMMEDIAT                  ,_param->_nb_front_end,_param->_nb_inst_decod[it1],_param->_size_general_data           );
        DELETE2_SIGNAL( in_RENAME_READ_RA                   ,_param->_nb_front_end,_param->_nb_inst_decod[it1],1                                    );
        DELETE2_SIGNAL( in_RENAME_NUM_REG_RA                ,_param->_nb_front_end,_param->_nb_inst_decod[it1],_param->_size_general_register_logic );
        DELETE2_SIGNAL( in_RENAME_READ_RB                   ,_param->_nb_front_end,_param->_nb_inst_decod[it1],1                                    );
        DELETE2_SIGNAL( in_RENAME_NUM_REG_RB                ,_param->_nb_front_end,_param->_nb_inst_decod[it1],_param->_size_general_register_logic );
        DELETE2_SIGNAL( in_RENAME_READ_RC                   ,_param->_nb_front_end,_param->_nb_inst_decod[it1],1                                    );
        DELETE2_SIGNAL( in_RENAME_NUM_REG_RC                ,_param->_nb_front_end,_param->_nb_inst_decod[it1],_param->_size_special_register_logic );
        DELETE2_SIGNAL( in_RENAME_WRITE_RD                  ,_param->_nb_front_end,_param->_nb_inst_decod[it1],1                                    );
        DELETE2_SIGNAL( in_RENAME_NUM_REG_RD                ,_param->_nb_front_end,_param->_nb_inst_decod[it1],_param->_size_general_register_logic );
        DELETE2_SIGNAL( in_RENAME_WRITE_RE                  ,_param->_nb_front_end,_param->_nb_inst_decod[it1],1                                    );
        DELETE2_SIGNAL( in_RENAME_NUM_REG_RE                ,_param->_nb_front_end,_param->_nb_inst_decod[it1],_param->_size_special_register_logic );
        DELETE2_SIGNAL( in_RENAME_EXCEPTION_USE             ,_param->_nb_front_end,_param->_nb_inst_decod[it1],_param->_size_exception_use          );
        DELETE2_SIGNAL( in_RENAME_EXCEPTION                 ,_param->_nb_front_end,_param->_nb_inst_decod[it1],_param->_size_exception              );
        
        DELETE1_SIGNAL(out_ISSUE_VAL                        ,_param->_nb_inst_issue,1                                    );
        DELETE1_SIGNAL( in_ISSUE_ACK                        ,_param->_nb_inst_issue,1                                    );
        DELETE1_SIGNAL(out_ISSUE_FRONT_END_ID               ,_param->_nb_inst_issue,_param->_size_front_end_id           );
        DELETE1_SIGNAL(out_ISSUE_CONTEXT_ID                 ,_param->_nb_inst_issue,_param->_size_context_id             );
        DELETE1_SIGNAL(out_ISSUE_PACKET_ID                  ,_param->_nb_inst_issue,_param->_size_rob_ptr                );
        DELETE1_SIGNAL(out_ISSUE_TYPE                       ,_param->_nb_inst_issue,_param->_size_type                   );
        DELETE1_SIGNAL(out_ISSUE_OPERATION                  ,_param->_nb_inst_issue,_param->_size_operation              );
        DELETE1_SIGNAL(out_ISSUE_STORE_QUEUE_PTR_WRITE      ,_param->_nb_inst_issue,_param->_size_store_queue_ptr        );
        DELETE1_SIGNAL(out_ISSUE_LOAD_QUEUE_PTR_WRITE       ,_param->_nb_inst_issue,_param->_size_load_queue_ptr         );
        DELETE1_SIGNAL(out_ISSUE_HAS_IMMEDIAT               ,_param->_nb_inst_issue,1                                    );
        DELETE1_SIGNAL(out_ISSUE_IMMEDIAT                   ,_param->_nb_inst_issue,_param->_size_general_data           );
        DELETE1_SIGNAL(out_ISSUE_READ_RA                    ,_param->_nb_inst_issue,1                                    );
        DELETE1_SIGNAL(out_ISSUE_NUM_REG_RA                 ,_param->_nb_inst_issue,_param->_size_general_register       );
        DELETE1_SIGNAL(out_ISSUE_READ_RB                    ,_param->_nb_inst_issue,1                                    );
        DELETE1_SIGNAL(out_ISSUE_NUM_REG_RB                 ,_param->_nb_inst_issue,_param->_size_general_register       );
        DELETE1_SIGNAL(out_ISSUE_READ_RC                    ,_param->_nb_inst_issue,1                                    );
        DELETE1_SIGNAL(out_ISSUE_NUM_REG_RC                 ,_param->_nb_inst_issue,_param->_size_special_register       );
        DELETE1_SIGNAL(out_ISSUE_WRITE_RD                   ,_param->_nb_inst_issue,1                                    );
        DELETE1_SIGNAL(out_ISSUE_NUM_REG_RD                 ,_param->_nb_inst_issue,_param->_size_general_register       );
        DELETE1_SIGNAL(out_ISSUE_WRITE_RE                   ,_param->_nb_inst_issue,1                                    );
        DELETE1_SIGNAL(out_ISSUE_NUM_REG_RE                 ,_param->_nb_inst_issue,_param->_size_special_register       );
        
        DELETE2_SIGNAL( in_EXECUTE_LOOP_VAL                 ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1],1                                    );
        DELETE2_SIGNAL(out_EXECUTE_LOOP_ACK                 ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1],1                                    );
        DELETE2_SIGNAL( in_EXECUTE_LOOP_FRONT_END_ID        ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1],_param->_size_front_end_id           );
        DELETE2_SIGNAL( in_EXECUTE_LOOP_CONTEXT_ID          ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1],_param->_size_context_id             );
        DELETE2_SIGNAL( in_EXECUTE_LOOP_PACKET_ID           ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1],_param->_size_rob_ptr                );
//      DELETE2_SIGNAL( in_EXECUTE_LOOP_TYPE                ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1],_param->_size_type                   );
//      DELETE2_SIGNAL( in_EXECUTE_LOOP_OPERATION           ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1],_param->_size_operation              );
        DELETE2_SIGNAL( in_EXECUTE_LOOP_FLAGS               ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1],_param->_size_special_data           );
        DELETE2_SIGNAL( in_EXECUTE_LOOP_EXCEPTION           ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1],_param->_size_exception              );
        DELETE2_SIGNAL( in_EXECUTE_LOOP_NO_SEQUENCE         ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1],1                                    );
        DELETE2_SIGNAL( in_EXECUTE_LOOP_ADDRESS             ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1],_param->_size_instruction_address    );
        DELETE2_SIGNAL( in_EXECUTE_LOOP_DATA                ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1],_param->_size_general_data           );
        
        DELETE1_SIGNAL(out_INSERT_VAL                       ,_param->_sum_inst_insert,1                                    );
        DELETE1_SIGNAL( in_INSERT_ACK                       ,_param->_sum_inst_insert,1                                    );
        DELETE1_SIGNAL(out_INSERT_RD_USE                    ,_param->_sum_inst_insert,1                                    );
        DELETE1_SIGNAL(out_INSERT_RD_NUM_REG                ,_param->_sum_inst_insert,_param->_size_general_register       );
        DELETE1_SIGNAL(out_INSERT_RE_USE                    ,_param->_sum_inst_insert,1                                    );
        DELETE1_SIGNAL(out_INSERT_RE_NUM_REG                ,_param->_sum_inst_insert,_param->_size_special_register       );
        
//         DELETE1_SIGNAL(out_RETIRE_VAL                       ,_param->_sum_inst_retire,1                                    );
//         DELETE1_SIGNAL( in_RETIRE_ACK                       ,_param->_sum_inst_retire,1                                    );
//         DELETE1_SIGNAL(out_RETIRE_RD_OLD_USE                ,_param->_sum_inst_retire,1                                    );
//         DELETE1_SIGNAL(out_RETIRE_RD_OLD_NUM_REG            ,_param->_sum_inst_retire,_param->_size_general_register       );
//         DELETE1_SIGNAL(out_RETIRE_RD_NEW_USE                ,_param->_sum_inst_retire,1                                    );
//         DELETE1_SIGNAL(out_RETIRE_RD_NEW_NUM_REG            ,_param->_sum_inst_retire,_param->_size_general_register       );
//         DELETE1_SIGNAL(out_RETIRE_RE_OLD_USE                ,_param->_sum_inst_retire,1                                    );
//         DELETE1_SIGNAL(out_RETIRE_RE_OLD_NUM_REG            ,_param->_sum_inst_retire,_param->_size_special_register       );
//         DELETE1_SIGNAL(out_RETIRE_RE_NEW_USE                ,_param->_sum_inst_retire,1                                    );
//         DELETE1_SIGNAL(out_RETIRE_RE_NEW_NUM_REG            ,_param->_sum_inst_retire,_param->_size_special_register       );
        
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_VAL              ,_param->_nb_inst_branch_complete,1                         );
        DELETE1_SIGNAL( in_BRANCH_COMPLETE_ACK              ,_param->_nb_inst_branch_complete,1                         );
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_FRONT_END_ID     ,_param->_nb_inst_branch_complete,_param->_size_front_end_id);
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_CONTEXT_ID       ,_param->_nb_inst_branch_complete,_param->_size_context_id  );
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_DEPTH            ,_param->_nb_inst_branch_complete,_param->_size_depth       );
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_ADDRESS          ,_param->_nb_inst_branch_complete,_param->_size_instruction_address);
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_NO_SEQUENCE      ,_param->_nb_inst_branch_complete,1                         );
        DELETE1_SIGNAL( in_BRANCH_COMPLETE_MISS_PREDICTION  ,_param->_nb_inst_branch_complete,1                         );
        
        DELETE0_SIGNAL(out_COMMIT_EVENT_VAL                 , 1);
        DELETE0_SIGNAL( in_COMMIT_EVENT_ACK                 , 1);
        DELETE0_SIGNAL(out_COMMIT_EVENT_FRONT_END_ID        ,_param->_size_front_end_id           );
        DELETE0_SIGNAL(out_COMMIT_EVENT_CONTEXT_ID          ,_param->_size_context_id             );
        DELETE0_SIGNAL(out_COMMIT_EVENT_DEPTH               ,_param->_size_depth                  );
        DELETE0_SIGNAL(out_COMMIT_EVENT_TYPE                ,_param->_size_event_type             );
        DELETE0_SIGNAL(out_COMMIT_EVENT_IS_DELAY_SLOT       ,1                                    );
        DELETE0_SIGNAL(out_COMMIT_EVENT_ADDRESS             ,_param->_size_general_data           );
        DELETE0_SIGNAL(out_COMMIT_EVENT_ADDRESS_EPCR_VAL    ,1                                    );
        DELETE0_SIGNAL(out_COMMIT_EVENT_ADDRESS_EPCR        ,_param->_size_general_data           );
        DELETE0_SIGNAL(out_COMMIT_EVENT_ADDRESS_EEAR_VAL    ,1                                    );
        DELETE0_SIGNAL(out_COMMIT_EVENT_ADDRESS_EEAR        ,_param->_size_general_data           );
        
        DELETE2_SIGNAL( in_EVENT_VAL                        ,_param->_nb_front_end,_param->_nb_context[it1],1                                    );
        DELETE2_SIGNAL(out_EVENT_ACK                        ,_param->_nb_front_end,_param->_nb_context[it1],1                                    );
        DELETE2_SIGNAL( in_EVENT_ADDRESS                    ,_param->_nb_front_end,_param->_nb_context[it1],_param->_size_instruction_address);
        DELETE2_SIGNAL( in_EVENT_ADDRESS_NEXT               ,_param->_nb_front_end,_param->_nb_context[it1],_param->_size_instruction_address); 
        DELETE2_SIGNAL( in_EVENT_ADDRESS_NEXT_VAL           ,_param->_nb_front_end,_param->_nb_context[it1],1                                    );
        DELETE2_SIGNAL( in_EVENT_IS_DS_TAKE                 ,_param->_nb_front_end,_param->_nb_context[it1],1                                    );
        DELETE2_SIGNAL( in_SPR_EVENT_VAL                    ,_param->_nb_front_end,_param->_nb_context[it1],1                                    );
        DELETE2_SIGNAL(out_SPR_EVENT_ACK                    ,_param->_nb_front_end,_param->_nb_context[it1],1                                    );
        DELETE2_SIGNAL( in_SPR_EVENT_EPCR                   ,_param->_nb_front_end,_param->_nb_context[it1],_param->_size_spr                    );
        DELETE2_SIGNAL( in_SPR_EVENT_EEAR_WEN               ,_param->_nb_front_end,_param->_nb_context[it1],1                                    );
        DELETE2_SIGNAL( in_SPR_EVENT_EEAR                   ,_param->_nb_front_end,_param->_nb_context[it1],_param->_size_spr                    );
        DELETE2_SIGNAL( in_SPR_EVENT_SR_DSX                 ,_param->_nb_front_end,_param->_nb_context[it1],1                                    );
        DELETE2_SIGNAL( in_SPR_EVENT_SR_TO_ESR              ,_param->_nb_front_end,_param->_nb_context[it1],1                                    );
        DELETE2_SIGNAL(out_NB_INST_COMMIT_ALL               ,_param->_nb_front_end,_param->_nb_context[it1],_param->_size_nb_inst_commit         );
        DELETE2_SIGNAL(out_NB_INST_COMMIT_MEM               ,_param->_nb_front_end,_param->_nb_context[it1],_param->_size_nb_inst_commit         );
        DELETE2_SIGNAL( in_NB_INST_DECOD_ALL                ,_param->_nb_front_end,_param->_nb_context[it1],_param->_size_nb_inst_decod          );
        DELETE2_SIGNAL( in_DEPTH_MIN                        ,_param->_nb_front_end,_param->_nb_context[it1],_param->_size_depth                  );
        DELETE2_SIGNAL( in_DEPTH_MAX                        ,_param->_nb_front_end,_param->_nb_context[it1],_param->_size_depth                  );
        DELETE2_SIGNAL( in_DEPTH_FULL                       ,_param->_nb_front_end,_param->_nb_context[it1],1                                    );
        DELETE2_SIGNAL(out_SPR_SR_IEE                       ,_param->_nb_front_end,_param->_nb_context[it1],1                                    );
        DELETE2_SIGNAL(out_SPR_SR_EPH                       ,_param->_nb_front_end,_param->_nb_context[it1],1                                    );
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    delete [] _component_rename_unit           ;
    delete    _component_commit_unit           ;
    delete    _component_issue_queue           ;
    delete    _component_reexecute_unit        ;   
    delete    _component_special_register_unit ;
    delete    _component_glue                  ;

    delete    _component;

    log_end(OOO_Engine,FUNCTION);
  };

}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
