/*
 * $Id: Functionnal_unit.cpp 116 2009-04-30 13:51:41Z moulu $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Functionnal_unit/include/Functionnal_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace functionnal_unit {


#undef  FUNCTION
#define FUNCTION "Functionnal_unit::Functionnal_unit"
  Functionnal_unit::Functionnal_unit 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::functionnal_unit::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Functionnal_unit,FUNCTION,"Begin");

    log_printf(INFO,Functionnal_unit,FUNCTION,"Allocation");
    allocation ();

#if DEBUG_Functionnal_unit == true
    log_printf(INFO,Functionnal_unit,FUNCTION,_("<%s> Parameters"),_name.c_str());

    std::cout << *param << std::endl;
#endif    

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Functionnal_unit,FUNCTION,"Allocation of statistics");

	statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Functionnal_unit,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	log_printf(INFO,Functionnal_unit,FUNCTION,"Method - transition");

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Functionnal_unit,FUNCTION,"Method - genMoore");

	SC_METHOD (genMoore);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // use internal register
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Functionnal_unit,FUNCTION,"Method - genMealy");

	SC_METHOD (genMealy);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg()  // use internal register
//                << (*(in_EXECUTE_IN_VAL ))
                  << (*(in_EXECUTE_OUT_ACK));

	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

#endif
      }
    log_printf(FUNC,Functionnal_unit,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Functionnal_unit::~Functionnal_unit"
  Functionnal_unit::~Functionnal_unit (void)
  {
    log_printf(FUNC,Functionnal_unit,FUNCTION,"Begin");

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	log_printf(INFO,Functionnal_unit,FUNCTION,"Generate Statistics file");
	
	delete _stat;
      }
#endif

    log_printf(INFO,Functionnal_unit,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Functionnal_unit,FUNCTION,"End");
  };

}; // end namespace functionnal_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
