#ifndef morpheo_behavioural_core_dcache_access_Parameters_h
#define morpheo_behavioural_core_dcache_access_Parameters_h

/*
 * $Id: Parameters.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Dcache_Access/include/Types.h"
#include "Behavioural/include/Parameters.h"
#include "Common/include/Debug.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace dcache_access {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t             _nb_thread              ;
  public : uint32_t             _nb_execute_loop        ;
  public : uint32_t           * _nb_load_store_unit     ;//[nb_execute_loop]
  public : uint32_t           * _nb_context             ;//[nb_execute_loop]//{nb_front_end + nb_context}
  public : uint32_t          ** _nb_cache_access        ;//[nb_execute_loop][nb_load_store_unit]
  public : uint32_t             _nb_dcache_port         ;
  public : uint32_t             _size_address           ;
  public : uint32_t             _size_data              ;
  public : uint32_t             _size_dcache_thread_id  ;
  public : uint32_t             _size_dcache_packet_id  ;
  public : uint32_t          ** _size_thread_id         ;//[nb_execute_loop][nb_load_store_unit]
  public : uint32_t          ** _size_packet_id         ;//[nb_execute_loop][nb_load_store_unit]
  public : uint32_t         *** _table_routing          ;//[nb_execute_loop][nb_load_store_unit][nb_cache_access]
  public : Tpriority_t          _priority               ;
  public : Tload_balancing_t    _load_balancing         ;
  public : uint32_t         *** _translate_load_store_unit_to_thread; //[nb_execute_loop][nb_load_store_unit][nb_context]

  public : uint32_t             _max_nb_load_store_unit   ;
  public : uint32_t             _max_nb_cache_access      ;
  public : Tcontext_t           _shift_num_cache_access   ;
  public : Tcontext_t           _mask_num_cache_access    ;
  public : Tcontext_t           _mask_num_lsq_packet      ;
  public : uint32_t           * _translate_thread_to_execute_loop   ; //[nb_thread]
  public : uint32_t           * _translate_thread_to_load_store_unit; //[nb_thread]
  public : uint32_t           * _translate_thread_to_context        ; //[nb_thread]
    
  public : bool              ** _have_port_lsq_thread_id   ;//[nb_execute_loop][nb_load_store_unit]
  public : bool              ** _have_port_lsq_packet_id   ;//[nb_execute_loop][nb_load_store_unit]
  public : bool                 _have_port_dcache_thread_id;
  public : bool                 _have_port_dcache_packet_id;
    
    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t             nb_thread              ,
                        uint32_t             nb_execute_loop        ,
			uint32_t           * nb_load_store_unit     ,
			uint32_t           * nb_context             ,
			uint32_t          ** nb_cache_access        ,
			uint32_t             nb_dcache_port         ,
			uint32_t             size_address           ,
			uint32_t             size_data              ,
                        uint32_t             size_dcache_thread_id  ,
                        uint32_t             size_dcache_packet_id  ,
			uint32_t          ** size_thread_id         ,
			uint32_t          ** size_packet_id         ,
			uint32_t         *** table_routing          ,
			Tpriority_t          priority               ,
			Tload_balancing_t    load_balancing         ,
                        uint32_t         *** translate_load_store_unit_to_thread,
                        bool                 is_toplevel=false      );

//   public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
					    morpheo::behavioural::core::dcache_access::Parameters & x);
  };

}; // end namespace dcache_access
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
