/*
 * $Id: Register_unit_allocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Register_unit/include/Register_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace register_unit {

#undef  FUNCTION
#define FUNCTION "Register_unit::allocation"
  void Register_unit::allocation (
#ifdef STATISTICS
				  morpheo::behavioural::Parameters_Statistics * param_statistics
#else
				  void
#endif
				  )
  {
    log_printf(FUNC,Register_unit,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Register_unit"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
						       ,IN
						       ,SOUTH,
						       "Generalist interface"
#endif
						       );

    in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
    in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);

    // ~~~~~[ Interface "gpr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("gpr_read",IN,NORTH,_("Interface to read the register file"),_param->_nb_gpr_read);
      
      ALLOC1_VALACK_IN ( in_GPR_READ_VAL          ,VAL);
      ALLOC1_VALACK_OUT(out_GPR_READ_ACK          ,ACK);
      ALLOC1_SIGNAL_IN ( in_GPR_READ_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id);
      ALLOC1_SIGNAL_IN ( in_GPR_READ_NUM_REG      ,"num_reg"      ,Tgeneral_address_t,_param->_size_gpr_address);
      ALLOC1_SIGNAL_OUT(out_GPR_READ_DATA         ,"data"         ,Tgeneral_data_t   ,_param->_size_general_data);
      ALLOC1_SIGNAL_OUT(out_GPR_READ_DATA_VAL     ,"data_val"     ,Tcontrol_t        ,1);

      ALLOC1_INTERFACE_END(_param->_nb_gpr_read);
    }

    // ~~~~~[ Interface "gpr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("gpr_write",IN,NORTH,_("Interface to write the register file"),_param->_nb_gpr_write);

      ALLOC1_VALACK_IN ( in_GPR_WRITE_VAL          ,VAL);
      ALLOC1_VALACK_OUT(out_GPR_WRITE_ACK          ,ACK);
      ALLOC1_SIGNAL_IN ( in_GPR_WRITE_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id);
      ALLOC1_SIGNAL_IN ( in_GPR_WRITE_NUM_REG      ,"num_reg"      ,Tgeneral_address_t,_param->_size_gpr_address);
      ALLOC1_SIGNAL_IN ( in_GPR_WRITE_DATA         ,"data"         ,Tgeneral_data_t   ,_param->_size_general_data);

      ALLOC1_INTERFACE_END(_param->_nb_gpr_write);
    }

    // ~~~~~[ Interface "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("spr_read",IN,NORTH,_("Interface to read the register file"),_param->_nb_spr_read);
      
      ALLOC1_VALACK_IN ( in_SPR_READ_VAL          ,VAL);
      ALLOC1_VALACK_OUT(out_SPR_READ_ACK          ,ACK);
      ALLOC1_SIGNAL_IN ( in_SPR_READ_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id);
      ALLOC1_SIGNAL_IN ( in_SPR_READ_NUM_REG      ,"num_reg"      ,Tspecial_address_t,_param->_size_spr_address);
      ALLOC1_SIGNAL_OUT(out_SPR_READ_DATA         ,"data"         ,Tspecial_data_t   ,_param->_size_special_data);
      ALLOC1_SIGNAL_OUT(out_SPR_READ_DATA_VAL     ,"data_val"     ,Tcontrol_t        ,1);

      ALLOC1_INTERFACE_END(_param->_nb_spr_read);
    }

    // ~~~~~[ Interface "spr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("spr_write",IN,NORTH,_("Interface to write the register file"),_param->_nb_spr_write);

      ALLOC1_VALACK_IN ( in_SPR_WRITE_VAL          ,VAL);
      ALLOC1_VALACK_OUT(out_SPR_WRITE_ACK          ,ACK);
      ALLOC1_SIGNAL_IN ( in_SPR_WRITE_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id);
      ALLOC1_SIGNAL_IN ( in_SPR_WRITE_NUM_REG      ,"num_reg"      ,Tspecial_address_t,_param->_size_spr_address);
      ALLOC1_SIGNAL_IN ( in_SPR_WRITE_DATA         ,"data"         ,Tspecial_data_t   ,_param->_size_special_data);

      ALLOC1_INTERFACE_END(_param->_nb_spr_write);
    }

    // ~~~~~[Interface "insert_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("insert_rob",IN,WEST,_("Interface to update status (insert)"),_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1]);
      
      _ALLOC2_VALACK_IN ( in_INSERT_ROB_VAL       ,VAL                                                      ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1]);
      _ALLOC2_VALACK_OUT(out_INSERT_ROB_ACK       ,ACK                                                      ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_ROB_RD_USE    ,"rd_use"    ,Tcontrol_t        ,1                        ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_ROB_RD_NUM_REG,"rd_num_reg",Tgeneral_address_t,_param->_size_gpr_address,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_ROB_RE_USE    ,"re_use"    ,Tcontrol_t        ,1                        ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_ROB_RE_NUM_REG,"re_num_reg",Tspecial_address_t,_param->_size_spr_address,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1]);
      
      ALLOC2_INTERFACE_END(_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1]);
    }

//     // ~~~~~[ Interface "retire_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//     in_RETIRE_ROB_VAL            = new SC_IN (Tcontrol_t        )  ** [_param->_nb_ooo_engine];
//     out_RETIRE_ROB_ACK            = new SC_OUT(Tcontrol_t        )  ** [_param->_nb_ooo_engine];
//     in_RETIRE_ROB_RD_OLD_USE     = new SC_IN (Tcontrol_t        )  ** [_param->_nb_ooo_engine];
//     in_RETIRE_ROB_RD_OLD_NUM_REG = new SC_IN (Tgeneral_address_t)  ** [_param->_nb_ooo_engine];
//     in_RETIRE_ROB_RE_OLD_USE     = new SC_IN (Tcontrol_t        )  ** [_param->_nb_ooo_engine];
//     in_RETIRE_ROB_RE_OLD_NUM_REG = new SC_IN (Tspecial_address_t)  ** [_param->_nb_ooo_engine];
//     in_RETIRE_ROB_RD_NEW_USE     = new SC_IN (Tcontrol_t        )  ** [_param->_nb_ooo_engine];
//     in_RETIRE_ROB_RD_NEW_NUM_REG = new SC_IN (Tgeneral_address_t)  ** [_param->_nb_ooo_engine];
//     in_RETIRE_ROB_RE_NEW_USE     = new SC_IN (Tcontrol_t        )  ** [_param->_nb_ooo_engine];
//     in_RETIRE_ROB_RE_NEW_NUM_REG = new SC_IN (Tspecial_address_t)  ** [_param->_nb_ooo_engine];

//     for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
//       {
// 	uint32_t x=_param->_nb_inst_retire_rob [i];

// 	in_RETIRE_ROB_VAL            [i] = new SC_IN (Tcontrol_t        )  * [x];
// 	out_RETIRE_ROB_ACK            [i] = new SC_OUT(Tcontrol_t        )  * [x];
// 	in_RETIRE_ROB_RD_OLD_USE     [i] = new SC_IN (Tcontrol_t        )  * [x];
// 	in_RETIRE_ROB_RD_OLD_NUM_REG [i] = new SC_IN (Tgeneral_address_t)  * [x];
// 	in_RETIRE_ROB_RE_OLD_USE     [i] = new SC_IN (Tcontrol_t        )  * [x];
// 	in_RETIRE_ROB_RE_OLD_NUM_REG [i] = new SC_IN (Tspecial_address_t)  * [x];
// 	in_RETIRE_ROB_RD_NEW_USE     [i] = new SC_IN (Tcontrol_t        )  * [x];
// 	in_RETIRE_ROB_RD_NEW_NUM_REG [i] = new SC_IN (Tgeneral_address_t)  * [x];
// 	in_RETIRE_ROB_RE_NEW_USE     [i] = new SC_IN (Tcontrol_t        )  * [x];
// 	in_RETIRE_ROB_RE_NEW_NUM_REG [i] = new SC_IN (Tspecial_address_t)  * [x];

// 	for (uint32_t j=0; j<x; j++)
// 	  {
// 	    Interface_fifo * interface = _interfaces->set_interface("retire_rob_"+toString(i)+"_"+toString(j)
// #ifdef POSITION
// 								    ,IN
// 								    ,WEST
// 								    ,"Interface to update status (retire)"
// #endif
// 								    );


// 	    in_RETIRE_ROB_VAL            [i][j] = interface->set_signal_valack_in  (VAL);
// 	   out_RETIRE_ROB_ACK            [i][j] = interface->set_signal_valack_out (ACK);
// 	    in_RETIRE_ROB_RD_OLD_USE     [i][j] = interface->set_signal_in <Tcontrol_t        > ("rd_old_use"    , 1);
// 	    in_RETIRE_ROB_RD_OLD_NUM_REG [i][j] = interface->set_signal_in <Tgeneral_address_t> ("rd_old_num_reg", _param->_size_gpr_address);
// 	    in_RETIRE_ROB_RE_OLD_USE     [i][j] = interface->set_signal_in <Tcontrol_t        > ("re_old_use"    , 1);
// 	    in_RETIRE_ROB_RE_OLD_NUM_REG [i][j] = interface->set_signal_in <Tspecial_address_t> ("re_old_num_reg", _param->_size_spr_address);
// 	    in_RETIRE_ROB_RD_NEW_USE     [i][j] = interface->set_signal_in <Tcontrol_t        > ("rd_new_use"    , 1);
// 	    in_RETIRE_ROB_RD_NEW_NUM_REG [i][j] = interface->set_signal_in <Tgeneral_address_t> ("rd_new_num_reg", _param->_size_gpr_address);
// 	    in_RETIRE_ROB_RE_NEW_USE     [i][j] = interface->set_signal_in <Tcontrol_t        > ("re_new_use"    , 1);
// 	    in_RETIRE_ROB_RE_NEW_NUM_REG [i][j] = interface->set_signal_in <Tspecial_address_t> ("re_new_num_reg", _param->_size_spr_address);
// 	  }
//       }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    std::string name;
     
    component_gpr        = new morpheo::behavioural::generic::registerfile::RegisterFile::RegisterFile * [_param->_nb_ooo_engine];
    component_gpr_status = new morpheo::behavioural::generic::registerfile::RegisterFile::RegisterFile * [_param->_nb_ooo_engine];
    component_spr        = new morpheo::behavioural::generic::registerfile::RegisterFile::RegisterFile * [_param->_nb_ooo_engine];
    component_spr_status = new morpheo::behavioural::generic::registerfile::RegisterFile::RegisterFile * [_param->_nb_ooo_engine];
     
    for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
      {
	name = _name+"_gpr_"+toString(i);
        log_printf(INFO,Register_unit,FUNCTION,_("Create   : %s"),name.c_str());

	component_gpr        [i] = new morpheo::behavioural::generic::registerfile::RegisterFile::RegisterFile 
	  (name.c_str()
#ifdef STATISTICS
	   ,param_statistics
#endif
	   ,_param->_param_gpr [i]
	   ,_usage
	   );
	 
	_component->set_component (component_gpr[i]->_component
#ifdef POSITION
				   , 50
				   , 50
				   , 10
				   , 10
#endif
				   );


	name = _name+"_gpr_status_"+toString(i);
        log_printf(INFO,Register_unit,FUNCTION,_("Create   : %s"),name.c_str());

	component_gpr_status [i] = new morpheo::behavioural::generic::registerfile::RegisterFile::RegisterFile
	  (name.c_str()
#ifdef STATISTICS
	   ,param_statistics
#endif
	   ,_param->_param_gpr_status [i]
	   ,_usage
	   );

	_component->set_component (component_gpr_status[i]->_component
#ifdef POSITION
				   , 50
				   , 50
				   , 10
				   , 10
#endif
				   );


	name = _name+"_spr_"+toString(i);
        log_printf(INFO,Register_unit,FUNCTION,_("Create   : %s"),name.c_str());
	 
	component_spr        [i] = new morpheo::behavioural::generic::registerfile::RegisterFile::RegisterFile 
	  (name.c_str()
#ifdef STATISTICS
	   ,param_statistics
#endif
	   ,_param->_param_spr [i]
	   ,_usage
	   );

	_component->set_component (component_spr[i]->_component
#ifdef POSITION
				   , 50
				   , 50
				   , 10
				   , 10
#endif
				   );

	name = _name+"_spr_status_"+toString(i);
        log_printf(INFO,Register_unit,FUNCTION,_("Create   : %s"),name.c_str());

	component_spr_status [i] = new morpheo::behavioural::generic::registerfile::RegisterFile::RegisterFile
	  (name.c_str()
#ifdef STATISTICS
	   ,param_statistics
#endif
	   ,_param->_param_spr_status [i]
	   ,_usage
	   );

	_component->set_component (component_spr_status[i]->_component
#ifdef POSITION
				   , 50
				   , 50
				   , 10
				   , 10
#endif
				   );
      }


    name = _name+"_glue";
    log_printf(INFO,Register_unit,FUNCTION,_("Create   : %s"),name.c_str());
     
    component_glue       = new morpheo::behavioural::core::multi_execute_loop::execute_loop::register_unit::register_unit_glue::Register_unit_Glue::Register_unit_Glue     
      (name.c_str()
#ifdef STATISTICS
       ,param_statistics
#endif
       ,_param->_param_glue
       ,_usage
       );

    _component->set_component (component_glue->_component
#ifdef POSITION
			       , 50
			       , 50
			       , 10
			       , 10
#endif
			       );
     
    // ~~~~~[ Instanciation ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    std::string name_component;
    
    for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
      {
	name_component = _name+"_gpr_"+toString(i);
	
        log_printf(INFO,Register_unit,FUNCTION,_("Instance : %s"),name_component.c_str());
	
#ifdef POSITION
	_component->interface_map (name_component,"",
				   _name         ,"");
#endif
	
	_component->port_map(name_component,"in_CLOCK"   , _name, "in_CLOCK");
	_component->port_map(name_component,"in_NRESET"  , _name, "in_NRESET");

	for (uint32_t j=0; j<_param->_nb_gpr_read; j++)
	  {
	    _component->port_map(name_component,
				 "in_READ_"+toString(j)+"_VAL",
				 _name+"_glue",
				 "out_GPR_READ_REGISTERFILE_"+toString(i)+"_"+toString(j)+"_VAL");
	    _component->port_map(name_component,
				 "out_READ_"+toString(j)+"_ACK",
				 _name+"_glue",
				 "in_GPR_READ_REGISTERFILE_"+toString(i)+"_"+toString(j)+"_ACK");
	    _component->port_map(name_component,
				 "out_READ_"+toString(j)+"_DATA",
				 _name+"_glue",
				 "in_GPR_READ_REGISTERFILE_"+toString(i)+"_"+toString(j)+"_DATA");
	    _component->port_map(name_component,
				 "in_READ_"+toString(j)+"_ADDRESS",
				 _name,
				 "in_GPR_READ_"+toString(j)+"_NUM_REG");
	  }
	for (uint32_t j=0; j<_param->_nb_gpr_write; j++)
	  {
	    _component->port_map(name_component,
				 "in_WRITE_"+toString(j)+"_VAL",
				 _name+"_glue",
				 "out_GPR_WRITE_REGISTERFILE_"+toString(i)+"_"+toString(j)+"_VAL");
	    _component->port_map(name_component,
				 "out_WRITE_"+toString(j)+"_ACK",
				 _name+"_glue",
				 "in_GPR_WRITE_REGISTERFILE_"+toString(i)+"_"+toString(j)+"_ACK");
	    _component->port_map(name_component,
				 "in_WRITE_"+toString(j)+"_ADDRESS",
				 _name,
				 "in_GPR_WRITE_"+toString(j)+"_NUM_REG"
				 );
	    _component->port_map(name_component,
				 "in_WRITE_"+toString(j)+"_DATA",
				 _name,
				 "in_GPR_WRITE_"+toString(j)+"_DATA");
	  }

      }// gpr
    
    {
      for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	{
	  name_component = _name+"_gpr_status_"+toString(i);
	  
	  log_printf(INFO,Register_unit,FUNCTION,_("Instance : %s"),name_component.c_str());
	  
#ifdef POSITION
	  _component->interface_map (name_component,"",
				     _name         ,"");
#endif
	  
	  _component->port_map(name_component,"in_CLOCK" , _name, "in_CLOCK");
	  _component->port_map(name_component,"in_NRESET", _name, "in_NRESET");
	  
	  for (uint32_t j=0; j<_param->_nb_gpr_read; j++)
	    {
	      _component->port_map(name_component,
				   "in_READ_"+toString(j)+"_VAL" ,
				   _name+"_glue",
				   "out_GPR_READ_STATUS_"+toString(i)+"_"+toString(j)+"_VAL"        );
	      _component->port_map(name_component,
				   "out_READ_"+toString(j)+"_ACK",
				   _name+"_glue",
				   "in_GPR_READ_STATUS_"+toString(i)+"_"+toString(j)+"_ACK" );
	      _component->port_map(name_component,
				   "out_READ_"+toString(j)+"_DATA",
				   _name+"_glue",
				   "in_GPR_READ_STATUS_"+toString(i)+"_"+toString(j)+"_DATA_VAL"   );
	      _component->port_map(name_component,
				   "in_READ_"+toString(j)+"_ADDRESS",
				   _name,
				   "in_GPR_READ_"+toString(j)+"_NUM_REG");
	    }

	  uint32_t x=0;
	  for (uint32_t j=0; j<_param->_nb_gpr_write; j++)
	    {
	      _component->port_map(name_component,
				   "in_WRITE_"+toString(x)+"_VAL" ,
				   _name+"_glue",
				   "out_GPR_WRITE_STATUS_"+toString(i)+"_"+toString(j)+"_VAL");
	      _component->port_map(name_component,
				   "out_WRITE_"+toString(x)+"_ACK",
				   _name+"_glue",
				   "in_GPR_WRITE_STATUS_"+toString(i)+"_"+toString(j)+"_ACK" );
	      _component->port_map(name_component,
				   "in_WRITE_"+toString(x)+"_DATA" ,
				   _name+"_glue",
				   "out_CONST_1");

	      _component->port_map(_name+"_glue",
				   "out_CONST_1",
				   name_component,
				   "in_WRITE_"+toString(x)+"_DATA" );


	      _component->port_map(name_component,
				   "in_WRITE_"+toString(x++)+"_ADDRESS",
				   _name,
				   "in_GPR_WRITE_"+toString(j)+"_NUM_REG");
	    }
	  
	  for (uint32_t j=0; j<_param->_nb_inst_insert_rob [i]; j++)
	    {
	      _component->port_map(name_component,
				   "in_WRITE_"+toString(x)+"_VAL" ,
				   _name+"_glue",
				   "out_INSERT_ROB_GPR_STATUS_"+toString(i)+"_"+toString(j)+"_VAL");
	      _component->port_map(name_component,
				   "out_WRITE_"+toString(x)+"_ACK",
				   _name+"_glue",
				   "in_INSERT_ROB_GPR_STATUS_"+toString(i)+"_"+toString(j)+"_ACK" );

	      _component->port_map(name_component,
				   "in_WRITE_"+toString(x)+"_DATA",
				    _name+"_glue",
				   "out_CONST_0"
				   );
	      _component->port_map( _name+"_glue",
				    "out_CONST_0",
				    name_component,
				   "in_WRITE_"+toString(x)+"_DATA");

	      _component->port_map(name_component,
				   "in_WRITE_"+toString(x++)+"_ADDRESS",
				   _name,
				   "in_INSERT_ROB_"+toString(i)+"_"+toString(j)+"_RD_NUM_REG");

	    }

// 	  for (uint32_t j=0; j<_param->_nb_inst_retire_rob [i]; j++)
// 	    {
// 	      _component->port_map(name_component,
// 				   "in_WRITE_"+toString(x)+"_VAL" ,
// 				   _name+"_glue",
// 				   "out_RETIRE_ROB_GPR_STATUS_OLD_"+toString(i)+"_"+toString(j)+"_VAL");
// 	      _component->port_map(name_component,
// 				   "out_WRITE_"+toString(x)+"_ACK",
// 				   _name+"_glue",
// 				   "in_RETIRE_ROB_GPR_STATUS_OLD_"+toString(i)+"_"+toString(j)+"_ACK" );

// 	      _component->port_map(name_component,
// 				   "in_WRITE_"+toString(x)+"_DATA" ,
// 				   _name+"_glue",
// 				   "out_CONST_0");
// 	      _component->port_map(_name+"_glue",
// 				   "out_CONST_0",
// 				   name_component,
// 				   "in_WRITE_"+toString(x)+"_DATA" );

// 	      _component->port_map(name_component,
// 				   "in_WRITE_"+toString(x++)+"_ADDRESS",
// 				   _name,
// 				   "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RD_OLD_NUM_REG");
	      
// 	      _component->port_map(name_component,
// 				   "in_WRITE_"+toString(x)+"_VAL" ,
// 				   _name+"_glue",
// 				   "out_RETIRE_ROB_GPR_STATUS_NEW_"+toString(i)+"_"+toString(j)+"_VAL");
// 	      _component->port_map(name_component,
// 				   "out_WRITE_"+toString(x)+"_ACK",
// 				   _name+"_glue",
// 				   "in_RETIRE_ROB_GPR_STATUS_NEW_"+toString(i)+"_"+toString(j)+"_ACK" );

// 	      _component->port_map(name_component,
// 				   "in_WRITE_"+toString(x)+"_DATA" ,
// 				   _name+"_glue",
// 				   "out_CONST_1"
// 				   );
// 	      _component->port_map(_name+"_glue",
// 				   "out_CONST_1",
// 				   name_component,
// 				   "in_WRITE_"+toString(x)+"_DATA"
// 				   );

// 	      _component->port_map(name_component,
// 				   "in_WRITE_"+toString(x++)+"_ADDRESS",
// 				   _name,
// 				   "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RD_NEW_NUM_REG");
// 	    }

	}
    }// gpr_status

    for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
      {
	name_component = _name+"_spr_"+toString(i);
	
	log_printf(INFO,Register_unit,FUNCTION,_("Instance : %s"),name_component.c_str());
	
#ifdef POSITION
	_component->interface_map (name_component,"",
				   _name         ,"");
#endif
	
	_component->port_map(name_component,"in_CLOCK" , _name, "in_CLOCK");
	_component->port_map(name_component,"in_NRESET", _name, "in_NRESET");

	for (uint32_t j=0; j<_param->_nb_spr_read; j++)
	  {
	    _component->port_map(name_component,
				 "in_READ_"+toString(j)+"_VAL",
				 _name+"_glue",
				 "out_SPR_READ_REGISTERFILE_"+toString(i)+"_"+toString(j)+"_VAL");
	    _component->port_map(name_component,
				 "out_READ_"+toString(j)+"_ACK",
				 _name+"_glue",
				 "in_SPR_READ_REGISTERFILE_"+toString(i)+"_"+toString(j)+"_ACK");
	    _component->port_map(name_component,
				 "out_READ_"+toString(j)+"_DATA",
				 _name+"_glue",
				 "in_SPR_READ_REGISTERFILE_"+toString(i)+"_"+toString(j)+"_DATA");
	    _component->port_map(name_component,
				 "in_READ_"+toString(j)+"_ADDRESS",
				 _name,
				 "in_SPR_READ_"+toString(j)+"_NUM_REG");
	  }
	for (uint32_t j=0; j<_param->_nb_spr_write; j++)
	  {
	    _component->port_map(name_component,
				 "in_WRITE_"+toString(j)+"_VAL",
				 _name+"_glue",
				 "out_SPR_WRITE_REGISTERFILE_"+toString(i)+"_"+toString(j)+"_VAL");
	    _component->port_map(name_component,
				 "out_WRITE_"+toString(j)+"_ACK",
				 _name+"_glue",
				 "in_SPR_WRITE_REGISTERFILE_"+toString(i)+"_"+toString(j)+"_ACK");
	    _component->port_map(name_component,
				 "in_WRITE_"+toString(j)+"_ADDRESS",
				 _name,
				 "in_SPR_WRITE_"+toString(j)+"_NUM_REG"
				 );
	    _component->port_map(name_component,
				 "in_WRITE_"+toString(j)+"_DATA",
				 _name,
				 "in_SPR_WRITE_"+toString(j)+"_DATA");
	  }

      }// spr
    
    {
      for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	{
	  name_component = _name+"_spr_status_"+toString(i);
	  
	  log_printf(INFO,Register_unit,FUNCTION,_("Instance : %s"),name_component.c_str());	
  
#ifdef POSITION
	  _component->interface_map (name_component,"",
				     _name         ,"");
#endif
	  
	  _component->port_map(name_component,"in_CLOCK" , _name, "in_CLOCK");
	  _component->port_map(name_component,"in_NRESET", _name, "in_NRESET");
	  
	  for (uint32_t j=0; j<_param->_nb_spr_read; j++)
	    {
	      _component->port_map(name_component,
				   "in_READ_"+toString(j)+"_VAL" ,
				   _name+"_glue",
				   "out_SPR_READ_STATUS_"+toString(i)+"_"+toString(j)+"_VAL"        );
	      _component->port_map(name_component,
				   "out_READ_"+toString(j)+"_ACK",
				   _name+"_glue",
				   "in_SPR_READ_STATUS_"+toString(i)+"_"+toString(j)+"_ACK" );
	      _component->port_map(name_component,
				   "out_READ_"+toString(j)+"_DATA",
				   _name+"_glue",
				   "in_SPR_READ_STATUS_"+toString(i)+"_"+toString(j)+"_DATA_VAL"   );
	      _component->port_map(name_component,
				   "in_READ_"+toString(j)+"_ADDRESS",
				   _name,
				   "in_SPR_READ_"+toString(j)+"_NUM_REG");
	    }

	  uint32_t x=0;
	  for (uint32_t j=0; j<_param->_nb_spr_write; j++)
	    {
	      _component->port_map(name_component,
				   "in_WRITE_"+toString(x)+"_VAL" ,
				   _name+"_glue",
				   "out_SPR_WRITE_STATUS_"+toString(i)+"_"+toString(j)+"_VAL");
	      _component->port_map(name_component,
				   "out_WRITE_"+toString(x)+"_ACK",
				   _name+"_glue",
				   "in_SPR_WRITE_STATUS_"+toString(i)+"_"+toString(j)+"_ACK" );
	      _component->port_map(name_component,
				   "in_WRITE_"+toString(x)+"_DATA" ,
				   _name+"_glue",
				   "out_CONST_1");
	      _component->port_map(_name+"_glue",
				   "out_CONST_1",
				   name_component,
				   "in_WRITE_"+toString(x)+"_DATA"
				   );

	      _component->port_map(name_component,
				   "in_WRITE_"+toString(x++)+"_ADDRESS",
				   _name,
				   "in_SPR_WRITE_"+toString(j)+"_NUM_REG");
	    }
	  
	  for (uint32_t j=0; j<_param->_nb_inst_insert_rob [i]; j++)
	    {
	      _component->port_map(name_component,
				   "in_WRITE_"+toString(x)+"_VAL" ,
				   _name+"_glue",
				   "out_INSERT_ROB_SPR_STATUS_"+toString(i)+"_"+toString(j)+"_VAL");
	      _component->port_map(name_component,
				   "out_WRITE_"+toString(x)+"_ACK",
				   _name+"_glue",
				   "in_INSERT_ROB_SPR_STATUS_"+toString(i)+"_"+toString(j)+"_ACK" );

	      _component->port_map(name_component,
				   "in_WRITE_"+toString(x)+"_DATA",
				    _name+"_glue",
				   "out_CONST_0"
				   );
	      _component->port_map( _name+"_glue",
				    "out_CONST_0",
				   name_component,
				   "in_WRITE_"+toString(x)+"_DATA"
				   );

	      _component->port_map(name_component,
				   "in_WRITE_"+toString(x++)+"_ADDRESS",
				   _name,
				   "in_INSERT_ROB_"+toString(i)+"_"+toString(j)+"_RE_NUM_REG");

	    }

// 	  for (uint32_t j=0; j<_param->_nb_inst_retire_rob [i]; j++)
// 	    {
// 	      _component->port_map(name_component,
// 				   "in_WRITE_"+toString(x)+"_VAL" ,
// 				   _name+"_glue",
// 				   "out_RETIRE_ROB_SPR_STATUS_OLD_"+toString(i)+"_"+toString(j)+"_VAL");
// 	      _component->port_map(name_component,
// 				   "out_WRITE_"+toString(x)+"_ACK",
// 				   _name+"_glue",
// 				   "in_RETIRE_ROB_SPR_STATUS_OLD_"+toString(i)+"_"+toString(j)+"_ACK" );

// 	      _component->port_map(name_component,
// 				   "in_WRITE_"+toString(x)+"_DATA" ,
// 				   _name+"_glue",
// 				   "out_CONST_0");
// 	      _component->port_map(_name+"_glue",
// 				   "out_CONST_0",
// 				   name_component,
// 				   "in_WRITE_"+toString(x)+"_DATA"
// 				   );

// 	      _component->port_map(name_component,
// 				   "in_WRITE_"+toString(x++)+"_ADDRESS",
// 				   _name,
// 				   "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RE_OLD_NUM_REG");
	      
// 	      _component->port_map(name_component,
// 				   "in_WRITE_"+toString(x)+"_VAL" ,
// 				   _name+"_glue",
// 				   "out_RETIRE_ROB_SPR_STATUS_NEW_"+toString(i)+"_"+toString(j)+"_VAL");
// 	      _component->port_map(name_component,
// 				   "out_WRITE_"+toString(x)+"_ACK",
// 				   _name+"_glue",
// 				   "in_RETIRE_ROB_SPR_STATUS_NEW_"+toString(i)+"_"+toString(j)+"_ACK" );

// 	      _component->port_map(name_component,
// 				   "in_WRITE_"+toString(x)+"_DATA" ,
// 				   _name+"_glue",
// 				   "out_CONST_1"
// 				   );
// 	      _component->port_map(_name+"_glue",
// 				   "out_CONST_1",
// 				   name_component,
// 				   "in_WRITE_"+toString(x)+"_DATA"
// 				   );

// 	      _component->port_map(name_component,
// 				   "in_WRITE_"+toString(x++)+"_ADDRESS",
// 				   _name,
// 				   "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RE_NEW_NUM_REG");
// 	    }

	}
    }// spr_status

    {
      name_component = _name+"_glue";
     
      log_printf(INFO,Register_unit,FUNCTION,_("Instance : %s"),name_component.c_str());  
   
#ifdef POSITION
      _component->interface_map (name_component,"",
				 _name         ,"");
#endif
    
      _component->port_map(name_component,"in_CLOCK" , _name, "in_CLOCK" );
      _component->port_map(name_component,"in_NRESET", _name, "in_NRESET");
//       _component->port_map(name_component,"out_CONST_0",_name,"out_CONST_0");
//       _component->port_map(name_component,"out_CONST_1",_name,"out_CONST_1");

      for (uint32_t j=0; j<_param->_nb_gpr_read; j++)
	{
	  _component->port_map(name_component,
			       "in_GPR_READ_"+toString(j)+"_VAL",
			       _name, 
			       "in_GPR_READ_"+toString(j)+"_VAL");
	  _component->port_map(name_component,
			       "out_GPR_READ_"+toString(j)+"_ACK",
			       _name,
			       "out_GPR_READ_"+toString(j)+"_ACK"           );
	  if (_param->_have_port_ooo_engine_id == true)
	    _component->port_map(name_component,
				 "in_GPR_READ_"+toString(j)+"_OOO_ENGINE_ID" , 
				 _name,
				 "in_GPR_READ_"+toString(j)+"_OOO_ENGINE_ID");
	  _component->port_map(name_component,
			       "out_GPR_READ_"+toString(j)+"_DATA"          , 
			       _name,
			       "out_GPR_READ_"+toString(j)+"_DATA");
	  _component->port_map(name_component,
			       "out_GPR_READ_"+toString(j)+"_DATA_VAL"      , 
			       _name,
			       "out_GPR_READ_"+toString(j)+"_DATA_VAL");

	  for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	    {
	      _component->port_map(name_component ,
				   "out_GPR_READ_REGISTERFILE_"+toString(i)+"_"+toString(j)+"_VAL",
				   _name+"_gpr_"+toString(i),
				   "in_READ_"+toString(j)+"_VAL"  );
	      _component->port_map(name_component,
				   "in_GPR_READ_REGISTERFILE_"+toString(i)+"_"+toString(j)+"_ACK"  ,
				   _name+"_gpr_"+toString(i),
				   "out_READ_"+toString(j)+"_ACK" );
	      _component->port_map(name_component,
				   "in_GPR_READ_REGISTERFILE_"+toString(i)+"_"+toString(j)+"_DATA" ,
				   _name+"_gpr_"+toString(i),
				   "out_READ_"+toString(j)+"_DATA");
	      _component->port_map(name_component,
				   "out_GPR_READ_STATUS_"+toString(i)+"_"+toString(j)+"_VAL"        ,
				   _name+"_gpr_status_"+toString(i),
				   "in_READ_"+toString(j)+"_VAL" );
	      _component->port_map(name_component,
				   "in_GPR_READ_STATUS_"+toString(i)+"_"+toString(j)+"_ACK" ,
				   _name+"_gpr_status_"+toString(i),
				   "out_READ_"+toString(j)+"_ACK");
	      _component->port_map(name_component,
				   "in_GPR_READ_STATUS_"+toString(i)+"_"+toString(j)+"_DATA_VAL"   ,
				   _name+"_gpr_status_"+toString(i),
				   "out_READ_"+toString(j)+"_DATA");
	    }
	}

      for (uint32_t j=0; j<_param->_nb_gpr_write; j++)
	{
	  _component->port_map(name_component,
			       "in_GPR_WRITE_"+toString(j)+"_VAL",
			       _name, 
			       "in_GPR_WRITE_"+toString(j)+"_VAL"           );
	  _component->port_map(name_component,
			       "out_GPR_WRITE_"+toString(j)+"_ACK", 
			       _name,
			       "out_GPR_WRITE_"+toString(j)+"_ACK"           );
	  if (_param->_have_port_ooo_engine_id == true)
	    _component->port_map(name_component,
				 "in_GPR_WRITE_"+toString(j)+"_OOO_ENGINE_ID", 
				 _name,
				 "in_GPR_WRITE_"+toString(j)+"_OOO_ENGINE_ID" );
	  
	  for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	    {
	      _component->port_map(name_component,
				   "out_GPR_WRITE_REGISTERFILE_"+toString(i)+"_"+toString(j)+"_VAL"  ,
				   _name+"_gpr_"+toString(i),
				   "in_WRITE_"+toString(j)+"_VAL" );
	      _component->port_map(name_component,
				   "in_GPR_WRITE_REGISTERFILE_"+toString(i)+"_"+toString(j)+"_ACK"  ,
				   _name+"_gpr_"+toString(i),
				   "out_WRITE_"+toString(j)+"_ACK" );
	      _component->port_map(name_component,
				   "out_GPR_WRITE_STATUS_"+toString(i)+"_"+toString(j)+"_VAL"        ,
				   _name+"_gpr_status_"+toString(i),
				   "in_WRITE_"+toString(j)+"_VAL" );
	      _component->port_map(name_component,
				   "in_GPR_WRITE_STATUS_"+toString(i)+"_"+toString(j)+"_ACK"        ,
				   _name+"_gpr_status_"+toString(i),
				   "out_WRITE_"+toString(j)+"_ACK" );
	    }
	}
      
      for (uint32_t j=0; j<_param->_nb_spr_read; j++)
	{
	  _component->port_map(name_component,
			       "in_SPR_READ_"+toString(j)+"_VAL",
			       _name, 
			       "in_SPR_READ_"+toString(j)+"_VAL");
	  _component->port_map(name_component,
			       "out_SPR_READ_"+toString(j)+"_ACK",
			       _name,
			       "out_SPR_READ_"+toString(j)+"_ACK"           );
	  if (_param->_have_port_ooo_engine_id == true)
	    _component->port_map(name_component,
				 "in_SPR_READ_"+toString(j)+"_OOO_ENGINE_ID" , 
				 _name,
				 "in_SPR_READ_"+toString(j)+"_OOO_ENGINE_ID");
	  _component->port_map(name_component,
			       "out_SPR_READ_"+toString(j)+"_DATA"          , 
			       _name,
			       "out_SPR_READ_"+toString(j)+"_DATA");
	  _component->port_map(name_component,
			       "out_SPR_READ_"+toString(j)+"_DATA_VAL"      , 
			       _name,
			       "out_SPR_READ_"+toString(j)+"_DATA_VAL");

	  for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	    {
	      _component->port_map(name_component ,
				   "out_SPR_READ_REGISTERFILE_"+toString(i)+"_"+toString(j)+"_VAL",
				   _name+"_spr_"+toString(i),
				   "in_READ_"+toString(j)+"_VAL"  );
	      _component->port_map(name_component,
				   "in_SPR_READ_REGISTERFILE_"+toString(i)+"_"+toString(j)+"_ACK"  ,
				   _name+"_spr_"+toString(i),
				   "out_READ_"+toString(j)+"_ACK" );
	      _component->port_map(name_component,
				   "in_SPR_READ_REGISTERFILE_"+toString(i)+"_"+toString(j)+"_DATA" ,
				   _name+"_spr_"+toString(i),
				   "out_READ_"+toString(j)+"_DATA");
	      _component->port_map(name_component,
				   "out_SPR_READ_STATUS_"+toString(i)+"_"+toString(j)+"_VAL"        ,
				   _name+"_spr_status_"+toString(i),
				   "in_READ_"+toString(j)+"_VAL" );
	      _component->port_map(name_component,
				   "in_SPR_READ_STATUS_"+toString(i)+"_"+toString(j)+"_ACK" ,
				   _name+"_spr_status_"+toString(i),
				   "out_READ_"+toString(j)+"_ACK");
	      _component->port_map(name_component,
				   "in_SPR_READ_STATUS_"+toString(i)+"_"+toString(j)+"_DATA_VAL"   ,
				   _name+"_spr_status_"+toString(i),
				   "out_READ_"+toString(j)+"_DATA");
	    }
	}

      for (uint32_t j=0; j<_param->_nb_spr_write; j++)
	{
	  _component->port_map(name_component,
			       "in_SPR_WRITE_"+toString(j)+"_VAL",
			       _name, 
			       "in_SPR_WRITE_"+toString(j)+"_VAL"           );
	  _component->port_map(name_component,
			       "out_SPR_WRITE_"+toString(j)+"_ACK", 
			       _name,
			       "out_SPR_WRITE_"+toString(j)+"_ACK"           );
	  if (_param->_have_port_ooo_engine_id == true)
	    _component->port_map(name_component,
				 "in_SPR_WRITE_"+toString(j)+"_OOO_ENGINE_ID", 
				 _name,
				 "in_SPR_WRITE_"+toString(j)+"_OOO_ENGINE_ID" );
	  
	  for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	    {
	      _component->port_map(name_component,
				   "out_SPR_WRITE_REGISTERFILE_"+toString(i)+"_"+toString(j)+"_VAL"  ,
				   _name+"_spr_"+toString(i),
				   "in_WRITE_"+toString(j)+"_VAL" );
	      _component->port_map(name_component,
				   "in_SPR_WRITE_REGISTERFILE_"+toString(i)+"_"+toString(j)+"_ACK"  ,
				   _name+"_spr_"+toString(i),
				   "out_WRITE_"+toString(j)+"_ACK" );
	      _component->port_map(name_component,
				   "out_SPR_WRITE_STATUS_"+toString(i)+"_"+toString(j)+"_VAL"        ,
				   _name+"_spr_status_"+toString(i),
				   "in_WRITE_"+toString(j)+"_VAL" );
	      _component->port_map(name_component,
				   "in_SPR_WRITE_STATUS_"+toString(i)+"_"+toString(j)+"_ACK"        ,
				   _name+"_spr_status_"+toString(i),
				   "out_WRITE_"+toString(j)+"_ACK" );
	    }
	}

      for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	{
	  uint32_t x     =_param->_nb_inst_insert_rob [i];
	  uint32_t gpr_j = _param->_nb_gpr_write;
	  uint32_t spr_j = _param->_nb_spr_write;

	  for (uint32_t j=0; j<x; j++)
	    {
	      _component->port_map(name_component,
				   "in_INSERT_ROB_"+toString(i)+"_"+toString(j)+"_VAL",
				   _name,
				   "in_INSERT_ROB_"+toString(i)+"_"+toString(j)+"_VAL");
	      _component->port_map(name_component,
				   "out_INSERT_ROB_"+toString(i)+"_"+toString(j)+"_ACK",
				   _name,
				   "out_INSERT_ROB_"+toString(i)+"_"+toString(j)+"_ACK");
	      _component->port_map(name_component,
				   "in_INSERT_ROB_"+toString(i)+"_"+toString(j)+"_RD_USE",
				   _name,
				   "in_INSERT_ROB_"+toString(i)+"_"+toString(j)+"_RD_USE");
	      _component->port_map(name_component,
				   "in_INSERT_ROB_"+toString(i)+"_"+toString(j)+"_RE_USE",
				   _name,
				   "in_INSERT_ROB_"+toString(i)+"_"+toString(j)+"_RE_USE");
	      _component->port_map(name_component,
				   "out_INSERT_ROB_GPR_STATUS_"+toString(i)+"_"+toString(j)+"_VAL",
				   _name+"_gpr_status_"+toString(i),
				   "in_WRITE_"+toString(gpr_j)+"_VAL");
	      _component->port_map(name_component,
				   "in_INSERT_ROB_GPR_STATUS_"+toString(i)+"_"+toString(j)+"_ACK",
				   _name+"_gpr_status_"+toString(i),
				   "out_WRITE_"+toString(gpr_j++)+"_ACK");
	      _component->port_map(name_component,
				   "out_INSERT_ROB_SPR_STATUS_"+toString(i)+"_"+toString(j)+"_VAL",
				   _name+"_spr_status_"+toString(i),
				   "in_WRITE_"+toString(spr_j)+"_VAL");
	      _component->port_map(name_component,
				   "in_INSERT_ROB_SPR_STATUS_"+toString(i)+"_"+toString(j)+"_ACK",
				   _name+"_spr_status_"+toString(i),
				   "out_WRITE_"+toString(spr_j++)+"_ACK");
	    }
	}

//       for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
// 	{
// 	  uint32_t x     =_param->_nb_inst_retire_rob [i];
// 	  uint32_t gpr_j = _param->_nb_gpr_write + _param->_nb_inst_insert_rob [i];
// 	  uint32_t spr_j = _param->_nb_spr_write + _param->_nb_inst_insert_rob [i];

// 	  for (uint32_t j=0; j<x; j++)
// 	    {
// 	      _component->port_map(name_component,
// 				   "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_VAL",
// 				   _name,
// 				   "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_VAL");
// 	      _component->port_map(name_component,
// 				   "out_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_ACK",
// 				   _name,
// 				   "out_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_ACK");
// 	      _component->port_map(name_component,
// 				   "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RD_OLD_USE",
// 				   _name,
// 				   "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RD_OLD_USE");
// 	      _component->port_map(name_component,
// 				   "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RD_NEW_USE",
// 				   _name,
// 				   "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RD_NEW_USE");
// 	      _component->port_map(name_component,
// 				   "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RE_OLD_USE",
// 				   _name, 
// 				   "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RE_OLD_USE");
// 	      _component->port_map(name_component,
// 				   "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RE_NEW_USE",
// 				   _name,
// 				   "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RE_NEW_USE");
	    
// 	      _component->port_map(name_component,
// 				   "out_RETIRE_ROB_GPR_STATUS_OLD_"+toString(i)+"_"+toString(j)+"_VAL",
// 				   _name+"_gpr_status_"+toString(i),
// 				   "in_WRITE_"+toString(gpr_j)+"_VAL");
// 	      _component->port_map(name_component,
// 				   "in_RETIRE_ROB_GPR_STATUS_OLD_"+toString(i)+"_"+toString(j)+"_ACK",
// 				   _name+"_gpr_status_"+toString(i),
// 				   "out_WRITE_"+toString(gpr_j++)+"_ACK");
// 	      _component->port_map(name_component,
// 				   "out_RETIRE_ROB_GPR_STATUS_NEW_"+toString(i)+"_"+toString(j)+"_VAL",
// 				   _name+"_gpr_status_"+toString(i),
// 				   "in_WRITE_"+toString(gpr_j)+"_VAL");
// 	      _component->port_map(name_component,
// 				   "in_RETIRE_ROB_GPR_STATUS_NEW_"+toString(i)+"_"+toString(j)+"_ACK",
// 				   _name+"_gpr_status_"+toString(i),
// 				   "out_WRITE_"+toString(gpr_j++)+"_ACK");
// 	      _component->port_map(name_component,
// 				   "out_RETIRE_ROB_SPR_STATUS_OLD_"+toString(i)+"_"+toString(j)+"_VAL",
// 				   _name+"_spr_status_"+toString(i),
// 				   "in_WRITE_"+toString(spr_j)+"_VAL");
// 	      _component->port_map(name_component,
// 				   "in_RETIRE_ROB_SPR_STATUS_OLD_"+toString(i)+"_"+toString(j)+"_ACK",
// 				   _name+"_spr_status_"+toString(i),
// 				   "out_WRITE_"+toString(spr_j++)+"_ACK");
// 	      _component->port_map(name_component,
// 				   "out_RETIRE_ROB_SPR_STATUS_NEW_"+toString(i)+"_"+toString(j)+"_VAL",
// 				   _name+"_spr_status_"+toString(i),
// 				   "in_WRITE_"+toString(spr_j)+"_VAL");
// 	      _component->port_map(name_component,
// 				   "in_RETIRE_ROB_SPR_STATUS_NEW_"+toString(i)+"_"+toString(j)+"_ACK",
// 				   _name+"_spr_status_"+toString(i),
// 				   "out_WRITE_"+toString(spr_j++)+"_ACK");
// 	    }
// 	}
    }// glue

#if DEBUG_Register_unit == true
    _component->test_map ();
#endif

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
      _component->generate_file();
#endif

//     std::cout << *_component << std::endl;

    log_printf(FUNC,Register_unit,FUNCTION,"End");
  };

}; // end namespace register_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
