/*
 * $Id: Parameter_definition_test.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Configuration/include/Parameter_definition.h"
#include "Behavioural/include/Stat_binary_tree.h"
#include "Common/include/FromString.h"

namespace morpheo {
namespace behavioural {
namespace configuration {

#undef  FUNCTION
#define FUNCTION "Parameter_definition::test"
  void Parameter_definition::test (std::string x)
  {
    log_begin(Configuration,FUNCTION);

    std::map<std::string, counter_t*> * operand = new std::map<std::string, counter_t*>;

    std::string expr = _step+" "+_name;
    std::string expr_str = _name + "(n+1) = "+_step+" "+_name+"(n)";

    counter_t value;
    (*operand)[_name] = &value;

    Stat_binary_tree * tree;
    try
      {
        tree = new Stat_binary_tree(expr,operand);
      }
    catch (morpheo::ErrorMorpheo & error)
      {
        throw (ERRORMORPHEO (FUNCTION,toString(_("step make an invalid infix expression : \"%s\"\n"),expr_str.c_str())));
      }
    
    counter_t min = fromString<counter_t>(_min);
    counter_t max = fromString<counter_t>(_max);

    value = min;
    while ((value != fromString<counter_t>(x)) and (value <= max))
      {
        counter_t tmp = tree->eval();

        // warning, can have infinite loop
        value = (tmp == value)?(max+1):tmp; 
      }

    if (value > max)
      {
        throw (ERRORMORPHEO (FUNCTION,toString(_("With the expression \"%s\" and \"%s(0) = %s\" and value between [%s:%s], \"%s(n) = %s\" is not a valid value.\n"),expr_str.c_str(),_name.c_str(),_min.c_str(),_min.c_str(),_max.c_str(),_name.c_str(),x.c_str())));
      }
    
    delete tree;
    
    log_end(Configuration,FUNCTION);
  };

}; // end namespace configuration
}; // end namespace behavioural
}; // end namespace morpheo              
