/*
 * $Id: Parameters_print.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Execute_loop_Glue/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace execute_loop_glue {


#undef  FUNCTION
#define FUNCTION "Execute_loop_Glue::print"
  std::string Parameters::print (uint32_t depth)
  {
    log_begin(Execute_loop_Glue,FUNCTION);

    XML xml ("execute_loop_glue");

    xml.balise_open("execute_loop_glue");
    xml.singleton_begin("nb_gpr_write         "); xml.attribut("value",toString(_nb_gpr_write         )); xml.singleton_end();
    xml.singleton_begin("nb_spr_write         "); xml.attribut("value",toString(_nb_spr_write         )); xml.singleton_end();
    xml.singleton_begin("size_ooo_engine_id   "); xml.attribut("value",toString(_size_ooo_engine_id   )); xml.singleton_end();
    xml.singleton_begin("size_general_register"); xml.attribut("value",toString(_size_general_register)); xml.singleton_end();
    xml.singleton_begin("size_special_register"); xml.attribut("value",toString(_size_special_register)); xml.singleton_end();
    xml.singleton_begin("size_general_data    "); xml.attribut("value",toString(_size_general_data    )); xml.singleton_end();
    xml.singleton_begin("size_special_data    "); xml.attribut("value",toString(_size_special_data    )); xml.singleton_end();
    xml.balise_close();

    log_end(Execute_loop_Glue,FUNCTION);
    
    return xml.get_body(depth);
  };

#undef  FUNCTION
#define FUNCTION "Execute_loop_Glue::operator<<"
  std::ostream& operator<< (std::ostream& output_stream ,
			    morpheo::behavioural::core::multi_execute_loop::execute_loop::execute_loop_glue::Parameters & x)
  {
    log_begin(Execute_loop_Glue,FUNCTION);

    output_stream << x.print(0);
    
    log_end(Execute_loop_Glue,FUNCTION);

    return output_stream;
  };

}; // end namespace execute_loop_glue
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
