/*
 * $Id: Read_unit_deallocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/include/Read_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {


#undef  FUNCTION
#define FUNCTION "Read_unit::deallocation"
  void Read_unit::deallocation (void)
  {
    log_printf(FUNC,Read_unit,FUNCTION,"Begin");

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete     in_CLOCK ;
	delete     in_NRESET;

        DELETE0_SIGNAL( in_READ_UNIT_IN_VAL                  ,1);
        DELETE0_SIGNAL(out_READ_UNIT_IN_ACK                  ,1);
        DELETE0_SIGNAL( in_READ_UNIT_IN_CONTEXT_ID           ,_param->_size_context_id   );
        DELETE0_SIGNAL( in_READ_UNIT_IN_FRONT_END_ID         ,_param->_size_front_end_id );
        DELETE0_SIGNAL( in_READ_UNIT_IN_OOO_ENGINE_ID        ,_param->_size_ooo_engine_id);
        DELETE0_SIGNAL( in_READ_UNIT_IN_PACKET_ID            ,_param->_size_rob_ptr    );
        DELETE0_SIGNAL( in_READ_UNIT_IN_OPERATION            ,_param->_size_operation    );
        DELETE0_SIGNAL( in_READ_UNIT_IN_TYPE                 ,_param->_size_type         );
        DELETE0_SIGNAL( in_READ_UNIT_IN_STORE_QUEUE_PTR_WRITE,_param->_size_store_queue_ptr);
        DELETE0_SIGNAL( in_READ_UNIT_IN_LOAD_QUEUE_PTR_WRITE ,_param->_size_load_queue_ptr);
        DELETE0_SIGNAL( in_READ_UNIT_IN_HAS_IMMEDIAT         ,1);
        DELETE0_SIGNAL( in_READ_UNIT_IN_IMMEDIAT             ,_param->_size_general_data);
        DELETE0_SIGNAL( in_READ_UNIT_IN_READ_RA              ,1);
        DELETE0_SIGNAL( in_READ_UNIT_IN_NUM_REG_RA           ,_param->_size_general_register);
        DELETE0_SIGNAL( in_READ_UNIT_IN_READ_RB              ,1);
        DELETE0_SIGNAL( in_READ_UNIT_IN_NUM_REG_RB           ,_param->_size_general_register);
        DELETE0_SIGNAL( in_READ_UNIT_IN_READ_RC              ,1);
        DELETE0_SIGNAL( in_READ_UNIT_IN_NUM_REG_RC           ,_param->_size_special_register);
        DELETE0_SIGNAL( in_READ_UNIT_IN_WRITE_RD             ,1);
        DELETE0_SIGNAL( in_READ_UNIT_IN_NUM_REG_RD           ,_param->_size_general_register);
        DELETE0_SIGNAL( in_READ_UNIT_IN_WRITE_RE             ,1);
        DELETE0_SIGNAL( in_READ_UNIT_IN_NUM_REG_RE           ,_param->_size_special_register);

        DELETE1_SIGNAL(out_READ_UNIT_OUT_VAL                  ,_param->_nb_inst_retire,1);
        DELETE1_SIGNAL( in_READ_UNIT_OUT_ACK                  ,_param->_nb_inst_retire,1);
        DELETE1_SIGNAL(out_READ_UNIT_OUT_CONTEXT_ID           ,_param->_nb_inst_retire,_param->_size_context_id      );
        DELETE1_SIGNAL(out_READ_UNIT_OUT_FRONT_END_ID         ,_param->_nb_inst_retire,_param->_size_front_end_id    );
        DELETE1_SIGNAL(out_READ_UNIT_OUT_OOO_ENGINE_ID        ,_param->_nb_inst_retire,_param->_size_ooo_engine_id   );
        DELETE1_SIGNAL(out_READ_UNIT_OUT_PACKET_ID            ,_param->_nb_inst_retire,_param->_size_rob_ptr       );
        DELETE1_SIGNAL(out_READ_UNIT_OUT_OPERATION            ,_param->_nb_inst_retire,_param->_size_operation       );
        DELETE1_SIGNAL(out_READ_UNIT_OUT_TYPE                 ,_param->_nb_inst_retire,_param->_size_type            );
        DELETE1_SIGNAL(out_READ_UNIT_OUT_STORE_QUEUE_PTR_WRITE,_param->_nb_inst_retire,_param->_size_store_queue_ptr);
        DELETE1_SIGNAL(out_READ_UNIT_OUT_LOAD_QUEUE_PTR_WRITE ,_param->_nb_inst_retire,_param->_size_load_queue_ptr);
        DELETE1_SIGNAL(out_READ_UNIT_OUT_HAS_IMMEDIAT         ,_param->_nb_inst_retire,1                             );
        DELETE1_SIGNAL(out_READ_UNIT_OUT_IMMEDIAT             ,_param->_nb_inst_retire,_param->_size_general_data    );
        DELETE1_SIGNAL(out_READ_UNIT_OUT_DATA_RA              ,_param->_nb_inst_retire,_param->_size_general_data    );
        DELETE1_SIGNAL(out_READ_UNIT_OUT_DATA_RB              ,_param->_nb_inst_retire,_param->_size_general_data    );
        DELETE1_SIGNAL(out_READ_UNIT_OUT_DATA_RC              ,_param->_nb_inst_retire,_param->_size_special_data    );
        DELETE1_SIGNAL(out_READ_UNIT_OUT_WRITE_RD             ,_param->_nb_inst_retire,1                             );
        DELETE1_SIGNAL(out_READ_UNIT_OUT_NUM_REG_RD           ,_param->_nb_inst_retire,_param->_size_general_register);
        DELETE1_SIGNAL(out_READ_UNIT_OUT_WRITE_RE             ,_param->_nb_inst_retire,1                             );
        DELETE1_SIGNAL(out_READ_UNIT_OUT_NUM_REG_RE           ,_param->_nb_inst_retire,_param->_size_special_register);

        DELETE1_SIGNAL(out_GPR_READ_VAL          , _param->_nb_gpr_read,1);
        DELETE1_SIGNAL( in_GPR_READ_ACK          , _param->_nb_gpr_read,1);
        DELETE1_SIGNAL(out_GPR_READ_OOO_ENGINE_ID, _param->_nb_gpr_read,_param->_size_ooo_engine_id   );
        DELETE1_SIGNAL(out_GPR_READ_NUM_REG      , _param->_nb_gpr_read,_param->_size_general_register);
        DELETE1_SIGNAL( in_GPR_READ_DATA         , _param->_nb_gpr_read,_param->_size_general_data    );
        DELETE1_SIGNAL( in_GPR_READ_DATA_VAL     , _param->_nb_gpr_read,1);

        DELETE1_SIGNAL(out_SPR_READ_VAL          , _param->_nb_spr_read,1);
        DELETE1_SIGNAL( in_SPR_READ_ACK          , _param->_nb_spr_read,1);
        DELETE1_SIGNAL(out_SPR_READ_OOO_ENGINE_ID, _param->_nb_spr_read,_param->_size_ooo_engine_id   );
        DELETE1_SIGNAL(out_SPR_READ_NUM_REG      , _param->_nb_spr_read,_param->_size_special_register);
        DELETE1_SIGNAL( in_SPR_READ_DATA         , _param->_nb_spr_read,_param->_size_special_data    );
        DELETE1_SIGNAL( in_SPR_READ_DATA_VAL     , _param->_nb_spr_read,1);

        DELETE1_SIGNAL( in_GPR_WRITE_VAL          , _param->_nb_gpr_write,1);
        DELETE1_SIGNAL( in_GPR_WRITE_OOO_ENGINE_ID, _param->_nb_gpr_write,_param->_size_ooo_engine_id   );
        DELETE1_SIGNAL( in_GPR_WRITE_NUM_REG      , _param->_nb_gpr_write,_param->_size_general_register);
        DELETE1_SIGNAL( in_GPR_WRITE_DATA         , _param->_nb_gpr_write,_param->_size_general_data);

        DELETE1_SIGNAL( in_SPR_WRITE_VAL          , _param->_nb_spr_write,1);
        DELETE1_SIGNAL( in_SPR_WRITE_OOO_ENGINE_ID, _param->_nb_spr_write,_param->_size_ooo_engine_id   );
        DELETE1_SIGNAL( in_SPR_WRITE_NUM_REG      , _param->_nb_spr_write,_param->_size_special_register);
        DELETE1_SIGNAL( in_SPR_WRITE_DATA         , _param->_nb_spr_write,_param->_size_special_data);

        DELETE1_SIGNAL( in_BYPASS_WRITE_OOO_ENGINE_ID, _param->_nb_bypass_write,_param->_size_ooo_engine_id   );
        DELETE1_SIGNAL( in_BYPASS_WRITE_GPR_VAL      , _param->_nb_bypass_write,1);
        DELETE1_SIGNAL( in_BYPASS_WRITE_GPR_NUM_REG  , _param->_nb_bypass_write,_param->_size_general_register);
        DELETE1_SIGNAL( in_BYPASS_WRITE_GPR_DATA     , _param->_nb_bypass_write,_param->_size_general_data    );
        DELETE1_SIGNAL( in_BYPASS_WRITE_SPR_VAL      , _param->_nb_bypass_write,1);
        DELETE1_SIGNAL( in_BYPASS_WRITE_SPR_NUM_REG  , _param->_nb_bypass_write,_param->_size_special_register);
        DELETE1_SIGNAL( in_BYPASS_WRITE_SPR_DATA     , _param->_nb_bypass_write,_param->_size_special_data    );

        DELETE1_SIGNAL( in_BYPASS_MEMORY_VAL          , _param->_nb_bypass_memory,1);
        DELETE1_SIGNAL( in_BYPASS_MEMORY_OOO_ENGINE_ID, _param->_nb_bypass_memory,_param->_size_ooo_engine_id   );
        DELETE1_SIGNAL( in_BYPASS_MEMORY_NUM_REG      , _param->_nb_bypass_memory,_param->_size_general_register);
        DELETE1_SIGNAL( in_BYPASS_MEMORY_DATA         , _param->_nb_bypass_memory,_param->_size_general_data    );
      }
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    delete _component_read_queue;
    delete _component_reservation_station;
    delete _component;

    log_printf(FUNC,Read_unit,FUNCTION,"End");
  };

}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
