/*
 * $Id: test.cpp 119 2009-05-25 17:40:26Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Front_end_Glue/SelfTest/include/test.h"
#include "Behavioural/include/Allocation.h"

void test (string name,
	   morpheo::behavioural::core::multi_front_end::front_end::front_end_glue::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,CYCLE_MAX);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Front_end_Glue * _Front_end_Glue = new Front_end_Glue 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC2_SC_SIGNAL(out_IFETCH_DECOD_UNIT_CONTEXT_ID                   ,"out_IFETCH_DECOD_UNIT_CONTEXT_ID                   ",Tcontext_t,_param->_nb_decod_unit,_param->_decod_unit_nb_context [it1]);

  ALLOC2_SC_SIGNAL(out_DECOD_CONTEXT_ID                               ,"out_DECOD_CONTEXT_ID                               ",Tcontext_t,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_DECOD_DECOD_UNIT_CONTEXT_ID                    ," in_DECOD_DECOD_UNIT_CONTEXT_ID                    ",Tcontext_t,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);

  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_VAL                            ," in_BRANCH_COMPLETE_VAL                            ",Tcontrol_t,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_ACK                            ,"out_BRANCH_COMPLETE_ACK                            ",Tcontrol_t,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_MISS_PREDICTION                ,"out_BRANCH_COMPLETE_MISS_PREDICTION                ",Tcontrol_t,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_PREDICTION_UNIT_VAL            ,"out_BRANCH_COMPLETE_PREDICTION_UNIT_VAL            ",Tcontrol_t,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_PREDICTION_UNIT_ACK            ," in_BRANCH_COMPLETE_PREDICTION_UNIT_ACK            ",Tcontrol_t,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_PREDICTION_UNIT_MISS_PREDICTION," in_BRANCH_COMPLETE_PREDICTION_UNIT_MISS_PREDICTION",Tcontrol_t,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_CONTEXT_STATE_VAL              ,"out_BRANCH_COMPLETE_CONTEXT_STATE_VAL              ",Tcontrol_t,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_CONTEXT_STATE_ACK              ," in_BRANCH_COMPLETE_CONTEXT_STATE_ACK              ",Tcontrol_t,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_CONTEXT_STATE_MISS_PREDICTION  ,"out_BRANCH_COMPLETE_CONTEXT_STATE_MISS_PREDICTION  ",Tcontrol_t,_param->_nb_inst_branch_complete);

  ALLOC1_SC_SIGNAL(out_EVENT_VAL                                      ,"out_EVENT_VAL                                      ",Tcontrol_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_EVENT_ACK                                      ," in_EVENT_ACK                                      ",Tcontrol_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_EVENT_ADDRESS                                  ,"out_EVENT_ADDRESS                                  ",Taddress_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_EVENT_ADDRESS_NEXT                             ,"out_EVENT_ADDRESS_NEXT                             ",Taddress_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_EVENT_ADDRESS_NEXT_VAL                         ,"out_EVENT_ADDRESS_NEXT_VAL                         ",Tcontrol_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_EVENT_IS_DS_TAKE                               ,"out_EVENT_IS_DS_TAKE                               ",Tcontrol_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_EVENT_IFETCH_UNIT_VAL                          ,"out_EVENT_IFETCH_UNIT_VAL                          ",Tcontrol_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_EVENT_IFETCH_UNIT_ACK                          ," in_EVENT_IFETCH_UNIT_ACK                          ",Tcontrol_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_EVENT_IFETCH_UNIT_ADDRESS                      ,"out_EVENT_IFETCH_UNIT_ADDRESS                      ",Taddress_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_EVENT_IFETCH_UNIT_ADDRESS_NEXT                 ,"out_EVENT_IFETCH_UNIT_ADDRESS_NEXT                 ",Taddress_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_EVENT_IFETCH_UNIT_ADDRESS_NEXT_VAL             ,"out_EVENT_IFETCH_UNIT_ADDRESS_NEXT_VAL             ",Tcontrol_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_EVENT_IFETCH_UNIT_IS_DS_TAKE                   ,"out_EVENT_IFETCH_UNIT_IS_DS_TAKE                   ",Tcontrol_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_EVENT_PREDICTION_UNIT_VAL                      ,"out_EVENT_PREDICTION_UNIT_VAL                      ",Tcontrol_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_EVENT_PREDICTION_UNIT_ACK                      ," in_EVENT_PREDICTION_UNIT_ACK                      ",Tcontrol_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_EVENT_PREDICTION_UNIT_TYPE                     ,"out_EVENT_PREDICTION_UNIT_TYPE                     ",Tevent_type_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_EVENT_PREDICTION_UNIT_DEPTH                    ,"out_EVENT_PREDICTION_UNIT_DEPTH                    ",Tdepth_t  ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_EVENT_CONTEXT_STATE_VAL                        ," in_EVENT_CONTEXT_STATE_VAL                        ",Tcontrol_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_EVENT_CONTEXT_STATE_ACK                        ,"out_EVENT_CONTEXT_STATE_ACK                        ",Tcontrol_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_EVENT_CONTEXT_STATE_ADDRESS                    ," in_EVENT_CONTEXT_STATE_ADDRESS                    ",Taddress_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_EVENT_CONTEXT_STATE_ADDRESS_NEXT               ," in_EVENT_CONTEXT_STATE_ADDRESS_NEXT               ",Taddress_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_EVENT_CONTEXT_STATE_ADDRESS_NEXT_VAL           ," in_EVENT_CONTEXT_STATE_ADDRESS_NEXT_VAL           ",Tcontrol_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_EVENT_CONTEXT_STATE_IS_DS_TAKE                 ," in_EVENT_CONTEXT_STATE_IS_DS_TAKE                 ",Tcontrol_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_EVENT_CONTEXT_STATE_TYPE                       ," in_EVENT_CONTEXT_STATE_TYPE                       ",Tevent_type_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_EVENT_CONTEXT_STATE_DEPTH                      ," in_EVENT_CONTEXT_STATE_DEPTH                      ",Tdepth_t  ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_EVENT_CONTEXT_STATE_FLUSH_ONLY                 ," in_EVENT_CONTEXT_STATE_FLUSH_ONLY                 ",Tcontrol_t,_param->_nb_context);

  ALLOC1_SC_SIGNAL(out_DEPTH_CURRENT                                  ,"out_DEPTH_CURRENT                                  ",Tdepth_t  ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_DEPTH_MIN                                      ,"out_DEPTH_MIN                                      ",Tdepth_t  ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_DEPTH_MAX                                      ,"out_DEPTH_MAX                                      ",Tdepth_t  ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_DEPTH_FULL                                     ,"out_DEPTH_FULL                                     ",Tcontrol_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_DEPTH_PREDICTION_UNIT_VAL                      ," in_DEPTH_PREDICTION_UNIT_VAL                      ",Tcontrol_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_DEPTH_PREDICTION_UNIT_CURRENT                  ," in_DEPTH_PREDICTION_UNIT_CURRENT                  ",Tdepth_t  ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_DEPTH_PREDICTION_UNIT_MIN                      ," in_DEPTH_PREDICTION_UNIT_MIN                      ",Tdepth_t  ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_DEPTH_PREDICTION_UNIT_MAX                      ," in_DEPTH_PREDICTION_UNIT_MAX                      ",Tdepth_t  ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_DEPTH_PREDICTION_UNIT_FULL                     ," in_DEPTH_PREDICTION_UNIT_FULL                     ",Tcontrol_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_DEPTH_CONTEXT_STATE_MIN                        ,"out_DEPTH_CONTEXT_STATE_MIN                        ",Tdepth_t  ,_param->_nb_context);
  ALLOC2_SC_SIGNAL(out_DEPTH_DECOD_UNIT_MIN                           ,"out_DEPTH_DECOD_UNIT_MIN                           ",Tdepth_t  ,_param->_nb_decod_unit,_param->_decod_unit_nb_context [it1]);
  ALLOC2_SC_SIGNAL(out_DEPTH_DECOD_UNIT_MAX                           ,"out_DEPTH_DECOD_UNIT_MAX                           ",Tdepth_t  ,_param->_nb_decod_unit,_param->_decod_unit_nb_context [it1]);
  ALLOC2_SC_SIGNAL(out_DEPTH_DECOD_UNIT_FULL                          ,"out_DEPTH_DECOD_UNIT_FULL                          ",Tcontrol_t,_param->_nb_decod_unit,_param->_decod_unit_nb_context [it1]);

  ALLOC2_SC_SIGNAL(out_CONTEXT_DECOD_UNIT_DEPTH_VAL                   ,"out_CONTEXT_DECOD_UNIT_DEPTH_VAL                   ",Tcontrol_t,_param->_nb_decod_unit,_param->_decod_unit_nb_context [it1]);
  ALLOC2_SC_SIGNAL(out_CONTEXT_DECOD_UNIT_DEPTH                       ,"out_CONTEXT_DECOD_UNIT_DEPTH                       ",Tdepth_t  ,_param->_nb_decod_unit,_param->_decod_unit_nb_context [it1]);

  ALLOC1_SC_SIGNAL(out_NB_INST_DECOD_ALL                              ,"out_NB_INST_DECOD_ALL                              ",Tcounter_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_NB_INST_DECOD_UNIT_DECOD_ALL                   ," in_NB_INST_DECOD_UNIT_DECOD_ALL                   ",Tcounter_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_NB_INST_CONTEXT_STATE_DECOD_ALL                ,"out_NB_INST_CONTEXT_STATE_DECOD_ALL                ",Tcounter_t,_param->_nb_context);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Front_end_Glue.\n"),name.c_str());

  (*(_Front_end_Glue->in_CLOCK))        (*(in_CLOCK));
  (*(_Front_end_Glue->in_NRESET))       (*(in_NRESET));

  if (_param->_have_port_context_id)
  INSTANCE2_SC_SIGNAL(_Front_end_Glue,out_IFETCH_DECOD_UNIT_CONTEXT_ID                     ,_param->_nb_decod_unit,_param->_decod_unit_nb_context [it1]);
  if (_param->_have_port_context_id)
  INSTANCE2_SC_SIGNAL(_Front_end_Glue,out_DECOD_CONTEXT_ID                                 ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  if (_param->_have_port_context_id)
  INSTANCE2_SC_SIGNAL(_Front_end_Glue, in_DECOD_DECOD_UNIT_CONTEXT_ID                      ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);

  INSTANCE1_SC_SIGNAL(_Front_end_Glue, in_BRANCH_COMPLETE_VAL                              ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue,out_BRANCH_COMPLETE_ACK                              ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue,out_BRANCH_COMPLETE_MISS_PREDICTION                  ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue,out_BRANCH_COMPLETE_PREDICTION_UNIT_VAL              ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue, in_BRANCH_COMPLETE_PREDICTION_UNIT_ACK              ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue, in_BRANCH_COMPLETE_PREDICTION_UNIT_MISS_PREDICTION  ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue,out_BRANCH_COMPLETE_CONTEXT_STATE_VAL                ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue, in_BRANCH_COMPLETE_CONTEXT_STATE_ACK                ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue,out_BRANCH_COMPLETE_CONTEXT_STATE_MISS_PREDICTION    ,_param->_nb_inst_branch_complete);

  INSTANCE1_SC_SIGNAL(_Front_end_Glue,out_EVENT_VAL                                        ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue, in_EVENT_ACK                                        ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue,out_EVENT_ADDRESS                                    ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue,out_EVENT_ADDRESS_NEXT                               ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue,out_EVENT_ADDRESS_NEXT_VAL                           ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue,out_EVENT_IS_DS_TAKE                                 ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue,out_EVENT_IFETCH_UNIT_VAL                            ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue, in_EVENT_IFETCH_UNIT_ACK                            ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue,out_EVENT_IFETCH_UNIT_ADDRESS                        ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue,out_EVENT_IFETCH_UNIT_ADDRESS_NEXT                   ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue,out_EVENT_IFETCH_UNIT_ADDRESS_NEXT_VAL               ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue,out_EVENT_IFETCH_UNIT_IS_DS_TAKE                     ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue,out_EVENT_PREDICTION_UNIT_VAL                        ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue, in_EVENT_PREDICTION_UNIT_ACK                        ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue,out_EVENT_PREDICTION_UNIT_TYPE                       ,_param->_nb_context);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Front_end_Glue,out_EVENT_PREDICTION_UNIT_DEPTH                      ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue, in_EVENT_CONTEXT_STATE_VAL                          ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue,out_EVENT_CONTEXT_STATE_ACK                          ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue, in_EVENT_CONTEXT_STATE_ADDRESS                      ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue, in_EVENT_CONTEXT_STATE_ADDRESS_NEXT                 ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue, in_EVENT_CONTEXT_STATE_ADDRESS_NEXT_VAL             ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue, in_EVENT_CONTEXT_STATE_IS_DS_TAKE                   ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue, in_EVENT_CONTEXT_STATE_TYPE                         ,_param->_nb_context);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Front_end_Glue, in_EVENT_CONTEXT_STATE_DEPTH                        ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue, in_EVENT_CONTEXT_STATE_FLUSH_ONLY                   ,_param->_nb_context);

  INSTANCE1_SC_SIGNAL(_Front_end_Glue, in_DEPTH_PREDICTION_UNIT_VAL                        ,_param->_nb_context);
  if (_param->_have_port_depth)
    {
  INSTANCE1_SC_SIGNAL(_Front_end_Glue,out_DEPTH_MIN                                        ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue, in_DEPTH_PREDICTION_UNIT_CURRENT                    ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue, in_DEPTH_PREDICTION_UNIT_MIN                        ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue,out_DEPTH_CONTEXT_STATE_MIN                          ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue,out_DEPTH_MAX                                        ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue, in_DEPTH_PREDICTION_UNIT_MAX                        ,_param->_nb_context);
  INSTANCE2_SC_SIGNAL(_Front_end_Glue,out_DEPTH_DECOD_UNIT_MAX                             ,_param->_nb_decod_unit,_param->_decod_unit_nb_context [it1]);
    }
  INSTANCE1_SC_SIGNAL(_Front_end_Glue,out_DEPTH_FULL                                       ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue, in_DEPTH_PREDICTION_UNIT_FULL                       ,_param->_nb_context);
  INSTANCE2_SC_SIGNAL(_Front_end_Glue,out_DEPTH_DECOD_UNIT_FULL                            ,_param->_nb_decod_unit,_param->_decod_unit_nb_context [it1]);

  INSTANCE2_SC_SIGNAL(_Front_end_Glue,out_CONTEXT_DECOD_UNIT_DEPTH_VAL                     ,_param->_nb_decod_unit,_param->_decod_unit_nb_context [it1]);
  for (uint32_t i=0; i<_param->_nb_decod_unit; ++i)
    for (uint32_t j=0; j<_param->_decod_unit_nb_context [i]; ++j)
      if (_param->_have_port_depth)
        {
          INSTANCE0_SC_SIGNAL(_Front_end_Glue,out_DEPTH_DECOD_UNIT_MIN  [i][j]);
          INSTANCE0_SC_SIGNAL(_Front_end_Glue,out_CONTEXT_DECOD_UNIT_DEPTH [i][j]);
        }

  INSTANCE1_SC_SIGNAL(_Front_end_Glue,out_NB_INST_DECOD_ALL                                ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue, in_NB_INST_DECOD_UNIT_DECOD_ALL                     ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end_Glue,out_NB_INST_CONTEXT_STATE_DECOD_ALL                  ,_param->_nb_context);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  DELETE2_SC_SIGNAL(out_IFETCH_DECOD_UNIT_CONTEXT_ID                     ,_param->_nb_decod_unit,_param->_decod_unit_nb_context [it1]);

  DELETE2_SC_SIGNAL(out_DECOD_CONTEXT_ID                                 ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_DECOD_DECOD_UNIT_CONTEXT_ID                      ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);

  DELETE1_SC_SIGNAL( in_BRANCH_COMPLETE_VAL                              ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL(out_BRANCH_COMPLETE_ACK                              ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL(out_BRANCH_COMPLETE_MISS_PREDICTION                  ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL(out_BRANCH_COMPLETE_PREDICTION_UNIT_VAL              ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL( in_BRANCH_COMPLETE_PREDICTION_UNIT_ACK              ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL( in_BRANCH_COMPLETE_PREDICTION_UNIT_MISS_PREDICTION  ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL(out_BRANCH_COMPLETE_CONTEXT_STATE_VAL                ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL( in_BRANCH_COMPLETE_CONTEXT_STATE_ACK                ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL(out_BRANCH_COMPLETE_CONTEXT_STATE_MISS_PREDICTION    ,_param->_nb_inst_branch_complete);

  DELETE1_SC_SIGNAL(out_EVENT_VAL                                        ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_EVENT_ACK                                        ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_EVENT_ADDRESS                                    ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_EVENT_ADDRESS_NEXT                               ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_EVENT_ADDRESS_NEXT_VAL                           ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_EVENT_IS_DS_TAKE                                 ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_EVENT_IFETCH_UNIT_VAL                            ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_EVENT_IFETCH_UNIT_ACK                            ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_EVENT_IFETCH_UNIT_ADDRESS                        ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_EVENT_IFETCH_UNIT_ADDRESS_NEXT                   ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_EVENT_IFETCH_UNIT_ADDRESS_NEXT_VAL               ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_EVENT_IFETCH_UNIT_IS_DS_TAKE                     ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_EVENT_PREDICTION_UNIT_VAL                        ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_EVENT_PREDICTION_UNIT_ACK                        ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_EVENT_PREDICTION_UNIT_TYPE                       ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_EVENT_PREDICTION_UNIT_DEPTH                      ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_EVENT_CONTEXT_STATE_VAL                          ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_EVENT_CONTEXT_STATE_ACK                          ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_EVENT_CONTEXT_STATE_ADDRESS                      ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_EVENT_CONTEXT_STATE_ADDRESS_NEXT                 ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_EVENT_CONTEXT_STATE_ADDRESS_NEXT_VAL             ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_EVENT_CONTEXT_STATE_IS_DS_TAKE                   ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_EVENT_CONTEXT_STATE_TYPE                         ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_EVENT_CONTEXT_STATE_DEPTH                        ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_EVENT_CONTEXT_STATE_FLUSH_ONLY                   ,_param->_nb_context);

  DELETE1_SC_SIGNAL(out_DEPTH_MIN                                        ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_DEPTH_MAX                                        ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_DEPTH_FULL                                       ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_DEPTH_PREDICTION_UNIT_VAL                        ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_DEPTH_PREDICTION_UNIT_CURRENT                    ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_DEPTH_PREDICTION_UNIT_MIN                        ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_DEPTH_PREDICTION_UNIT_MAX                        ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_DEPTH_PREDICTION_UNIT_FULL                       ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_DEPTH_CONTEXT_STATE_MIN                          ,_param->_nb_context);

  DELETE2_SC_SIGNAL(out_DEPTH_DECOD_UNIT_MIN                             ,_param->_nb_decod_unit,_param->_decod_unit_nb_context [it1]);
  DELETE2_SC_SIGNAL(out_DEPTH_DECOD_UNIT_MAX                             ,_param->_nb_decod_unit,_param->_decod_unit_nb_context [it1]);
  DELETE2_SC_SIGNAL(out_DEPTH_DECOD_UNIT_FULL                            ,_param->_nb_decod_unit,_param->_decod_unit_nb_context [it1]);

  DELETE2_SC_SIGNAL(out_CONTEXT_DECOD_UNIT_DEPTH_VAL                     ,_param->_nb_decod_unit,_param->_decod_unit_nb_context [it1]);
  DELETE2_SC_SIGNAL(out_CONTEXT_DECOD_UNIT_DEPTH                         ,_param->_nb_decod_unit,_param->_decod_unit_nb_context [it1]);

  DELETE1_SC_SIGNAL(out_NB_INST_DECOD_ALL                                ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_NB_INST_DECOD_UNIT_DECOD_ALL                     ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_NB_INST_CONTEXT_STATE_DECOD_ALL                  ,_param->_nb_context);
    }
#endif

  delete _Front_end_Glue;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
