/*
 * $Id: Ifetch_queue.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_queue/include/Ifetch_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace ifetch_queue {


#undef  FUNCTION
#define FUNCTION "Ifetch_queue::Ifetch_queue"
  Ifetch_queue::Ifetch_queue 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Ifetch_queue,FUNCTION,"Begin");

#if DEBUG_Ifetch_queue == true
    log_printf(INFO,Ifetch_queue,FUNCTION,_("<%s> Parameters"),_name.c_str());

    std::cout << *param << std::endl;
#endif    

    log_printf(INFO,Ifetch_queue,FUNCTION,_("<%s> Allocation"),_name.c_str());

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Ifetch_queue,FUNCTION,_("<%s> Allocation of statistics"),_name.c_str());

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Ifetch_queue,FUNCTION,_("<%s> Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	// constant output
	internal_ICACHE_RSP_ACK  = 1;
	internal_EVENT_RESET_ACK = 1;

	PORT_WRITE(out_ICACHE_RSP_ACK , internal_ICACHE_RSP_ACK );
	PORT_WRITE(out_EVENT_RESET_ACK, internal_EVENT_RESET_ACK);

	log_printf(INFO,Ifetch_queue,FUNCTION,_("<%s> Method - transition"),_name.c_str());

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Ifetch_queue,FUNCTION,_("<%s> Method - genMoore"),_name.c_str());

	SC_METHOD (genMoore);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // use internal register
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
	
#endif
      }
    log_printf(FUNC,Ifetch_queue,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Ifetch_queue::~Ifetch_queue"
  Ifetch_queue::~Ifetch_queue (void)
  {
    log_printf(FUNC,Ifetch_queue,FUNCTION,"Begin");

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Ifetch_queue,FUNCTION,_("<%s> Deallocation"),_name.c_str());
    deallocation ();

    log_printf(FUNC,Ifetch_queue,FUNCTION,"End");
  };

}; // end namespace ifetch_queue
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
