#ifdef SYSTEMC
/*
 * $Id: Rename_unit_Glue_genMealy_retire_valack.cpp 110 2009-02-19 16:31:47Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Rename_unit_Glue/include/Rename_unit_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace rename_unit_glue {


#undef  FUNCTION
#define FUNCTION "Rename_unit_Glue::genMealy_retire_valack"
  void Rename_unit_Glue::genMealy_retire_valack (void)
  {
    log_begin(Rename_unit_Glue,FUNCTION);
    log_function(Rename_unit_Glue,FUNCTION,_name.c_str());

    // Transaction must be in-order - made in commit_unit
//     Tcontrol_t previous_transaction = true;
    
    for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
      {
	Tcontrol_t VAL                          = PORT_READ(in_RETIRE_VAL                          [i]);
	Tcontrol_t LOAD_STORE_QUEUE_POINTER_ACK = PORT_READ(in_RETIRE_LOAD_STORE_QUEUE_POINTER_ACK [i]);
	Tcontrol_t REGISTER_TRANSLATION_ACK     = PORT_READ(in_RETIRE_REGISTER_TRANSLATION_ACK     [i]);

	Tcontrol_t ACK                          = (// previous_transaction         and
						   LOAD_STORE_QUEUE_POINTER_ACK and
						   REGISTER_TRANSLATION_ACK     );
	Tcontrol_t LOAD_STORE_QUEUE_POINTER_VAL = (// previous_transaction         and
						   VAL                          and
						   REGISTER_TRANSLATION_ACK     );
	Tcontrol_t REGISTER_TRANSLATION_VAL     = (// previous_transaction         and
						   VAL                          and
						   LOAD_STORE_QUEUE_POINTER_ACK );
	
	PORT_WRITE(out_RETIRE_ACK                          [i], ACK                         );
	PORT_WRITE(out_RETIRE_LOAD_STORE_QUEUE_POINTER_VAL [i], LOAD_STORE_QUEUE_POINTER_VAL);
	PORT_WRITE(out_RETIRE_REGISTER_TRANSLATION_VAL     [i], REGISTER_TRANSLATION_VAL    );

// 	previous_transaction = VAL and ACK;

        log_printf(TRACE,Rename_unit_Glue,FUNCTION,"  * retire [%d]",i);
        log_printf(TRACE,Rename_unit_Glue,FUNCTION,"    * val (commit_unit)            (r) : %d",VAL                         );
        log_printf(TRACE,Rename_unit_Glue,FUNCTION,"    * ack (commit_unit)            (w) : %d",ACK                         );
        log_printf(TRACE,Rename_unit_Glue,FUNCTION,"    * register_translation_val     (w) : %d",REGISTER_TRANSLATION_VAL    );
        log_printf(TRACE,Rename_unit_Glue,FUNCTION,"    * register_translation_ack     (r) : %d",REGISTER_TRANSLATION_ACK    );
        log_printf(TRACE,Rename_unit_Glue,FUNCTION,"    * load_store_queue_pointer_val (w) : %d",LOAD_STORE_QUEUE_POINTER_VAL);
        log_printf(TRACE,Rename_unit_Glue,FUNCTION,"    * load_store_queue_pointer_ack (r) : %d",LOAD_STORE_QUEUE_POINTER_ACK);
      }

    log_end(Rename_unit_Glue,FUNCTION);
  };

}; // end namespace rename_unit_glue
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
