#ifndef morpheo_behavioural_Usage_h
#define morpheo_behavioural_Usage_h

#include "Common/include/Environment.h"
#include <stdint.h>

namespace morpheo {
namespace behavioural {

  typedef uint16_t Tusage_t;

#  define USE_SYSTEMC               0x003
#  define USE_SYSTEMC_INTERFACE     0x001
#  define USE_SYSTEMC_BODY          0x002
#  define USE_VHDL                  0x004
#  define USE_VHDL_TESTBENCH        0x008
#  define USE_VHDL_TESTBENCH_ASSERT 0x010
#  define USE_POSITION              0x020
#  define USE_STATISTICS            0x040
//#define USE_INFORMATION           0x080
#  define USE_HEADER                0x100
#  define USE_COSIMULATION          0x200
//#define USE_                      0x400

#  define USE_NONE                  0x00
#  define USE_ALL                   usage_all()

#ifdef MODELSIM_COSIMULATION
  Tusage_t usage_cosimulation(Tusage_t usage);
#endif
  Tusage_t usage_set         (Tusage_t usage, Tusage_t flag);
  Tusage_t usage_unset       (Tusage_t usage, Tusage_t flag);
  bool     usage_is_set      (Tusage_t usage, Tusage_t flag);
  Tusage_t usage_environment (Tusage_t usage);
  Tusage_t usage_all         (void);

}; // end namespace behavioural
}; // end namespace morpheo              

#endif

