#ifdef VHDL_TESTBENCH
/*
 * $Id: Signal_testbench_body.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Signal.h"

namespace morpheo              {
namespace behavioural          {

  void Signal::testbench_body (Vhdl * & vhdl,
			       std::string   counter_name,
			       std::string   reset_name  )
  {
    log_printf(FUNC,Behavioural,"testbench_body","Begin");

    // _list_value is empty if we don't trace

    if ((_presence_port == PORT_VHDL_YES_TESTBENCH_YES) or
	(_presence_port == PORT_VHDL_NO_TESTBENCH_YES ))
      if (_list_value->empty()== false)
	{
	  std::string separator;
	  if (get_size() == 1)
	    separator = "\'";
	  else
	    separator = "\"";
	  
	  std::string signame = (_direction==OUT)?(_name+"_test"):_name;
	  
	  vhdl->set_body ("");
	  vhdl->set_body ("with "+counter_name+" select");
	  vhdl->set_body ("\t"+signame+" <=");
	  
	  uint32_t cpt = 0;
	  std::list<std::string>::iterator i = _list_value->begin();
	  
	  while (i != _list_value->end())
	    {
	      std::list<std::string>::iterator j = i;
	      
	      ++i;
	      
	      vhdl->set_body ("\t"+separator+*j+separator+" when "+toString(cpt++)+",");
	    }
	  
	  if (get_size() == 1)
	    vhdl->set_body ("\t'0' when others;");
	  else
	    vhdl->set_body ("\t(others => '0') when others;");
	}
  
    log_printf(FUNC,Behavioural,"testbench_body","End");
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
