#ifdef STATISTICS
#include "Behavioural/include/Stat.h"

namespace morpheo {
namespace behavioural {

#undef FUNCTION
#define FUNCTION "Stat::alloc_operand"
  counter_t * Stat::alloc_operand (counter_type_t type, std::string varname, std::string unit, std::string description)
  {
    if (not is_valid_var (varname))
      throw(ERRORMORPHEO(FUNCTION,toString(_("<%s> : Variable \"%s\" is not valid."),_name_instance.c_str(),varname.c_str())));

    counter_t * counter = new counter_t;
    var_t       var;

    var.counter     = counter;
    var.type        = type;
    var.name        = varname;
    var.unit        = unit;
    var.description = description;

    // insertion dans la table
    (*_list_operand) [varname] = var;

    *counter        = 0;
    
    return counter;
  }
};
};
#endif
