/*
 * $Id: test.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Execute_loop_Glue/SelfTest/include/test.h"
#include "Behavioural/include/Allocation.h"

void test (string name,
	   morpheo::behavioural::core::multi_execute_loop::execute_loop::execute_loop_glue::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,CYCLE_MAX);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Execute_loop_Glue * _Execute_loop_Glue = new Execute_loop_Glue 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");
  
  sc_signal<Tcontrol_t        > **  in_GPR_WRITE_WRITE_UNIT_VAL               ;
  sc_signal<Tcontrol_t        > ** out_GPR_WRITE_WRITE_UNIT_ACK               ;
  sc_signal<Tcontext_t        > **  in_GPR_WRITE_WRITE_UNIT_OOO_ENGINE_ID     ;
  sc_signal<Tgeneral_address_t> **  in_GPR_WRITE_WRITE_UNIT_NUM_REG           ;
  sc_signal<Tgeneral_data_t   > **  in_GPR_WRITE_WRITE_UNIT_DATA              ;
  sc_signal<Tcontrol_t        > ** out_GPR_WRITE_REGISTER_FILE_VAL            ;
  sc_signal<Tcontrol_t        > **  in_GPR_WRITE_REGISTER_FILE_ACK            ;
  sc_signal<Tcontext_t        > ** out_GPR_WRITE_REGISTER_FILE_OOO_ENGINE_ID  ;
  sc_signal<Tgeneral_address_t> ** out_GPR_WRITE_REGISTER_FILE_NUM_REG        ;
  sc_signal<Tgeneral_data_t   > ** out_GPR_WRITE_REGISTER_FILE_DATA           ;
  sc_signal<Tcontrol_t        > ** out_GPR_WRITE_READ_UNIT_VAL                ;
  sc_signal<Tcontext_t        > ** out_GPR_WRITE_READ_UNIT_OOO_ENGINE_ID      ;
  sc_signal<Tgeneral_address_t> ** out_GPR_WRITE_READ_UNIT_NUM_REG            ;
  sc_signal<Tgeneral_data_t   > ** out_GPR_WRITE_READ_UNIT_DATA               ;
  sc_signal<Tcontrol_t        > **  in_SPR_WRITE_WRITE_UNIT_VAL               ;
  sc_signal<Tcontrol_t        > ** out_SPR_WRITE_WRITE_UNIT_ACK               ;
  sc_signal<Tcontext_t        > **  in_SPR_WRITE_WRITE_UNIT_OOO_ENGINE_ID     ;
  sc_signal<Tspecial_address_t> **  in_SPR_WRITE_WRITE_UNIT_NUM_REG           ;
  sc_signal<Tspecial_data_t   > **  in_SPR_WRITE_WRITE_UNIT_DATA              ;
  sc_signal<Tcontrol_t        > ** out_SPR_WRITE_REGISTER_FILE_VAL            ;
  sc_signal<Tcontrol_t        > **  in_SPR_WRITE_REGISTER_FILE_ACK            ;
  sc_signal<Tcontext_t        > ** out_SPR_WRITE_REGISTER_FILE_OOO_ENGINE_ID  ;
  sc_signal<Tspecial_address_t> ** out_SPR_WRITE_REGISTER_FILE_NUM_REG        ;
  sc_signal<Tspecial_data_t   > ** out_SPR_WRITE_REGISTER_FILE_DATA           ;
  sc_signal<Tcontrol_t        > ** out_SPR_WRITE_READ_UNIT_VAL                ;
  sc_signal<Tcontext_t        > ** out_SPR_WRITE_READ_UNIT_OOO_ENGINE_ID      ;
  sc_signal<Tspecial_address_t> ** out_SPR_WRITE_READ_UNIT_NUM_REG            ;
  sc_signal<Tspecial_data_t   > ** out_SPR_WRITE_READ_UNIT_DATA               ;

  ALLOC1_SC_SIGNAL( in_GPR_WRITE_WRITE_UNIT_VAL               ," in_GPR_WRITE_WRITE_UNIT_VAL             ",Tcontrol_t        ,_param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL(out_GPR_WRITE_WRITE_UNIT_ACK               ,"out_GPR_WRITE_WRITE_UNIT_ACK             ",Tcontrol_t        ,_param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL( in_GPR_WRITE_WRITE_UNIT_OOO_ENGINE_ID     ," in_GPR_WRITE_WRITE_UNIT_OOO_ENGINE_ID   ",Tcontext_t        ,_param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL( in_GPR_WRITE_WRITE_UNIT_NUM_REG           ," in_GPR_WRITE_WRITE_UNIT_NUM_REG         ",Tgeneral_address_t,_param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL( in_GPR_WRITE_WRITE_UNIT_DATA              ," in_GPR_WRITE_WRITE_UNIT_DATA            ",Tgeneral_data_t   ,_param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL(out_GPR_WRITE_REGISTER_FILE_VAL            ,"out_GPR_WRITE_REGISTER_FILE_VAL          ",Tcontrol_t        ,_param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL( in_GPR_WRITE_REGISTER_FILE_ACK            ," in_GPR_WRITE_REGISTER_FILE_ACK          ",Tcontrol_t        ,_param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL(out_GPR_WRITE_REGISTER_FILE_OOO_ENGINE_ID  ,"out_GPR_WRITE_REGISTER_FILE_OOO_ENGINE_ID",Tcontext_t        ,_param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL(out_GPR_WRITE_REGISTER_FILE_NUM_REG        ,"out_GPR_WRITE_REGISTER_FILE_NUM_REG      ",Tgeneral_address_t,_param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL(out_GPR_WRITE_REGISTER_FILE_DATA           ,"out_GPR_WRITE_REGISTER_FILE_DATA         ",Tgeneral_data_t   ,_param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL(out_GPR_WRITE_READ_UNIT_VAL                ,"out_GPR_WRITE_READ_UNIT_VAL              ",Tcontrol_t        ,_param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL(out_GPR_WRITE_READ_UNIT_OOO_ENGINE_ID      ,"out_GPR_WRITE_READ_UNIT_OOO_ENGINE_ID    ",Tcontext_t        ,_param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL(out_GPR_WRITE_READ_UNIT_NUM_REG            ,"out_GPR_WRITE_READ_UNIT_NUM_REG          ",Tgeneral_address_t,_param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL(out_GPR_WRITE_READ_UNIT_DATA               ,"out_GPR_WRITE_READ_UNIT_DATA             ",Tgeneral_data_t   ,_param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL( in_SPR_WRITE_WRITE_UNIT_VAL               ," in_SPR_WRITE_WRITE_UNIT_VAL             ",Tcontrol_t        ,_param->_nb_spr_write);
  ALLOC1_SC_SIGNAL(out_SPR_WRITE_WRITE_UNIT_ACK               ,"out_SPR_WRITE_WRITE_UNIT_ACK             ",Tcontrol_t        ,_param->_nb_spr_write);
  ALLOC1_SC_SIGNAL( in_SPR_WRITE_WRITE_UNIT_OOO_ENGINE_ID     ," in_SPR_WRITE_WRITE_UNIT_OOO_ENGINE_ID   ",Tcontext_t        ,_param->_nb_spr_write);
  ALLOC1_SC_SIGNAL( in_SPR_WRITE_WRITE_UNIT_NUM_REG           ," in_SPR_WRITE_WRITE_UNIT_NUM_REG         ",Tspecial_address_t,_param->_nb_spr_write);
  ALLOC1_SC_SIGNAL( in_SPR_WRITE_WRITE_UNIT_DATA              ," in_SPR_WRITE_WRITE_UNIT_DATA            ",Tspecial_data_t   ,_param->_nb_spr_write);
  ALLOC1_SC_SIGNAL(out_SPR_WRITE_REGISTER_FILE_VAL            ,"out_SPR_WRITE_REGISTER_FILE_VAL          ",Tcontrol_t        ,_param->_nb_spr_write);
  ALLOC1_SC_SIGNAL( in_SPR_WRITE_REGISTER_FILE_ACK            ," in_SPR_WRITE_REGISTER_FILE_ACK          ",Tcontrol_t        ,_param->_nb_spr_write);
  ALLOC1_SC_SIGNAL(out_SPR_WRITE_REGISTER_FILE_OOO_ENGINE_ID  ,"out_SPR_WRITE_REGISTER_FILE_OOO_ENGINE_ID",Tcontext_t        ,_param->_nb_spr_write);
  ALLOC1_SC_SIGNAL(out_SPR_WRITE_REGISTER_FILE_NUM_REG        ,"out_SPR_WRITE_REGISTER_FILE_NUM_REG      ",Tspecial_address_t,_param->_nb_spr_write);
  ALLOC1_SC_SIGNAL(out_SPR_WRITE_REGISTER_FILE_DATA           ,"out_SPR_WRITE_REGISTER_FILE_DATA         ",Tspecial_data_t   ,_param->_nb_spr_write);
  ALLOC1_SC_SIGNAL(out_SPR_WRITE_READ_UNIT_VAL                ,"out_SPR_WRITE_READ_UNIT_VAL              ",Tcontrol_t        ,_param->_nb_spr_write);
  ALLOC1_SC_SIGNAL(out_SPR_WRITE_READ_UNIT_OOO_ENGINE_ID      ,"out_SPR_WRITE_READ_UNIT_OOO_ENGINE_ID    ",Tcontext_t        ,_param->_nb_spr_write);
  ALLOC1_SC_SIGNAL(out_SPR_WRITE_READ_UNIT_NUM_REG            ,"out_SPR_WRITE_READ_UNIT_NUM_REG          ",Tspecial_address_t,_param->_nb_spr_write);
  ALLOC1_SC_SIGNAL(out_SPR_WRITE_READ_UNIT_DATA               ,"out_SPR_WRITE_READ_UNIT_DATA             ",Tspecial_data_t   ,_param->_nb_spr_write);

  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Execute_loop_Glue.\n"),name.c_str());

  (*(_Execute_loop_Glue->in_CLOCK))        (*(in_CLOCK));
  (*(_Execute_loop_Glue->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue, in_GPR_WRITE_WRITE_UNIT_VAL               ,_param->_nb_gpr_write);
  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue,out_GPR_WRITE_WRITE_UNIT_ACK               ,_param->_nb_gpr_write);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue, in_GPR_WRITE_WRITE_UNIT_OOO_ENGINE_ID     ,_param->_nb_gpr_write);
  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue, in_GPR_WRITE_WRITE_UNIT_NUM_REG           ,_param->_nb_gpr_write);
  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue, in_GPR_WRITE_WRITE_UNIT_DATA              ,_param->_nb_gpr_write);

  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue,out_GPR_WRITE_REGISTER_FILE_VAL            ,_param->_nb_gpr_write);
  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue, in_GPR_WRITE_REGISTER_FILE_ACK            ,_param->_nb_gpr_write);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue,out_GPR_WRITE_REGISTER_FILE_OOO_ENGINE_ID  ,_param->_nb_gpr_write);
  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue,out_GPR_WRITE_REGISTER_FILE_NUM_REG        ,_param->_nb_gpr_write);
  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue,out_GPR_WRITE_REGISTER_FILE_DATA           ,_param->_nb_gpr_write);

  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue,out_GPR_WRITE_READ_UNIT_VAL                ,_param->_nb_gpr_write);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue,out_GPR_WRITE_READ_UNIT_OOO_ENGINE_ID      ,_param->_nb_gpr_write);
  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue,out_GPR_WRITE_READ_UNIT_NUM_REG            ,_param->_nb_gpr_write);
  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue,out_GPR_WRITE_READ_UNIT_DATA               ,_param->_nb_gpr_write);

  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue, in_SPR_WRITE_WRITE_UNIT_VAL               ,_param->_nb_spr_write);
  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue,out_SPR_WRITE_WRITE_UNIT_ACK               ,_param->_nb_spr_write);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue, in_SPR_WRITE_WRITE_UNIT_OOO_ENGINE_ID     ,_param->_nb_spr_write);
  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue, in_SPR_WRITE_WRITE_UNIT_NUM_REG           ,_param->_nb_spr_write);
  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue, in_SPR_WRITE_WRITE_UNIT_DATA              ,_param->_nb_spr_write);

  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue,out_SPR_WRITE_REGISTER_FILE_VAL            ,_param->_nb_spr_write);
  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue, in_SPR_WRITE_REGISTER_FILE_ACK            ,_param->_nb_spr_write);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue,out_SPR_WRITE_REGISTER_FILE_OOO_ENGINE_ID  ,_param->_nb_spr_write);
  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue,out_SPR_WRITE_REGISTER_FILE_NUM_REG        ,_param->_nb_spr_write);
  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue,out_SPR_WRITE_REGISTER_FILE_DATA           ,_param->_nb_spr_write);

  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue,out_SPR_WRITE_READ_UNIT_VAL                ,_param->_nb_spr_write);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue,out_SPR_WRITE_READ_UNIT_OOO_ENGINE_ID      ,_param->_nb_spr_write);
  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue,out_SPR_WRITE_READ_UNIT_NUM_REG            ,_param->_nb_spr_write);
  INSTANCE1_SC_SIGNAL(_Execute_loop_Glue,out_SPR_WRITE_READ_UNIT_DATA               ,_param->_nb_spr_write);


  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  DELETE1_SC_SIGNAL( in_GPR_WRITE_WRITE_UNIT_VAL               ,_param->_nb_gpr_write);
  DELETE1_SC_SIGNAL(out_GPR_WRITE_WRITE_UNIT_ACK               ,_param->_nb_gpr_write);
  DELETE1_SC_SIGNAL( in_GPR_WRITE_WRITE_UNIT_OOO_ENGINE_ID     ,_param->_nb_gpr_write);
  DELETE1_SC_SIGNAL( in_GPR_WRITE_WRITE_UNIT_NUM_REG           ,_param->_nb_gpr_write);
  DELETE1_SC_SIGNAL( in_GPR_WRITE_WRITE_UNIT_DATA              ,_param->_nb_gpr_write);

  DELETE1_SC_SIGNAL(out_GPR_WRITE_REGISTER_FILE_VAL            ,_param->_nb_gpr_write);
  DELETE1_SC_SIGNAL( in_GPR_WRITE_REGISTER_FILE_ACK            ,_param->_nb_gpr_write);
  DELETE1_SC_SIGNAL(out_GPR_WRITE_REGISTER_FILE_OOO_ENGINE_ID  ,_param->_nb_gpr_write);
  DELETE1_SC_SIGNAL(out_GPR_WRITE_REGISTER_FILE_NUM_REG        ,_param->_nb_gpr_write);
  DELETE1_SC_SIGNAL(out_GPR_WRITE_REGISTER_FILE_DATA           ,_param->_nb_gpr_write);

  DELETE1_SC_SIGNAL(out_GPR_WRITE_READ_UNIT_VAL                ,_param->_nb_gpr_write);
  DELETE1_SC_SIGNAL(out_GPR_WRITE_READ_UNIT_OOO_ENGINE_ID      ,_param->_nb_gpr_write);
  DELETE1_SC_SIGNAL(out_GPR_WRITE_READ_UNIT_NUM_REG            ,_param->_nb_gpr_write);
  DELETE1_SC_SIGNAL(out_GPR_WRITE_READ_UNIT_DATA               ,_param->_nb_gpr_write);

  DELETE1_SC_SIGNAL( in_SPR_WRITE_WRITE_UNIT_VAL               ,_param->_nb_spr_write);
  DELETE1_SC_SIGNAL(out_SPR_WRITE_WRITE_UNIT_ACK               ,_param->_nb_spr_write);
  DELETE1_SC_SIGNAL( in_SPR_WRITE_WRITE_UNIT_OOO_ENGINE_ID     ,_param->_nb_spr_write);
  DELETE1_SC_SIGNAL( in_SPR_WRITE_WRITE_UNIT_NUM_REG           ,_param->_nb_spr_write);
  DELETE1_SC_SIGNAL( in_SPR_WRITE_WRITE_UNIT_DATA              ,_param->_nb_spr_write);

  DELETE1_SC_SIGNAL(out_SPR_WRITE_REGISTER_FILE_VAL            ,_param->_nb_spr_write);
  DELETE1_SC_SIGNAL( in_SPR_WRITE_REGISTER_FILE_ACK            ,_param->_nb_spr_write);
  DELETE1_SC_SIGNAL(out_SPR_WRITE_REGISTER_FILE_OOO_ENGINE_ID  ,_param->_nb_spr_write);
  DELETE1_SC_SIGNAL(out_SPR_WRITE_REGISTER_FILE_NUM_REG        ,_param->_nb_spr_write);
  DELETE1_SC_SIGNAL(out_SPR_WRITE_REGISTER_FILE_DATA           ,_param->_nb_spr_write);

  DELETE1_SC_SIGNAL(out_SPR_WRITE_READ_UNIT_VAL                ,_param->_nb_spr_write);
  DELETE1_SC_SIGNAL(out_SPR_WRITE_READ_UNIT_OOO_ENGINE_ID      ,_param->_nb_spr_write);
  DELETE1_SC_SIGNAL(out_SPR_WRITE_READ_UNIT_NUM_REG            ,_param->_nb_spr_write);
  DELETE1_SC_SIGNAL(out_SPR_WRITE_READ_UNIT_DATA               ,_param->_nb_spr_write);
    }
#endif

  delete _Execute_loop_Glue;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
