#ifdef SYSTEMC
//#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
/*
 * $Id: Load_store_unit_function_speculative_load_commit_genMealy_insert.cpp 101 2009-01-15 17:19:08Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Load_store_unit/include/Load_store_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace load_store_unit {


#undef  FUNCTION
#define FUNCTION "Load_store_unit::function_speculative_load_commit_genMealy_insert"
  void Load_store_unit::function_speculative_load_commit_genMealy_insert (void)
  {
    log_begin(Load_store_unit,FUNCTION);
    log_function(Load_store_unit,FUNCTION,_name.c_str());

    // ~~~~~[ Output "memory_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    
    // Initialisation
    internal_MEMORY_IN_PORT = 0;
    Tcontrol_t ack [_param->_nb_inst_memory];
    for (uint32_t i=0; i<_param->_nb_inst_memory; i++)
      ack [i] = 0;

    // find first valid entry
    // store queue is never full (pointer is manage by rename stage)
    for (uint32_t i=0; i<_param->_nb_inst_memory; i++)
      if (PORT_READ(in_MEMORY_IN_VAL [i]))
	{
	  internal_MEMORY_IN_ACK = is_operation_memory_store(PORT_READ(in_MEMORY_IN_OPERATION [i])) or not _speculative_access_queue_control->full();

	  if (internal_MEMORY_IN_ACK)
	    {
	      ack [i] = 1;
	      internal_MEMORY_IN_PORT = i;
	      break; // end
	    }
	}

    for (uint32_t i=0; i<_param->_nb_inst_memory; i++)
      PORT_WRITE(out_MEMORY_IN_ACK [i], ack [i]);

    log_end(Load_store_unit,FUNCTION);
  };

}; // end namespace load_store_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
//#endif
