/*
 * $Id: Parameters_msg_error.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Dcache_Access/include/Parameters.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace dcache_access {


#undef  FUNCTION
#define FUNCTION "Dcache_Access::msg_error"
  Parameters_test Parameters::msg_error(void)
  {
    log_begin(Dcache_Access,FUNCTION);

    Parameters_test test ("Dcache_Access");

    bool have_link [_nb_dcache_port];
    for (uint32_t i=0; i<_nb_dcache_port; i++)
      have_link [i] = 0;
    
    for (uint32_t i=0; i<_nb_execute_loop; i++)
      for (uint32_t j=0; j<_nb_load_store_unit [i]; ++j)
	for (uint32_t k=0; k<_nb_cache_access [i][j]; ++k)
	  if (_table_routing [i][j][k] >= _nb_dcache_port)
	    test.error(toString(_("table_routing [%d][%d][%d] : invalid value, must be < nb_dcache_port.\n"),i,j,k));
	  else
	    have_link [_table_routing [i][j][k]] = true;
    
    for (uint32_t i=0; i<_nb_dcache_port; i++)
      if (not have_link [i])
	test.error(toString(_("Port[%d] is not linked.\n"),i));

    bool thread_link [_nb_thread];
    for (uint32_t i=0; i<_nb_thread; ++i)
      thread_link [i] = false;
    
    for (uint32_t i=0; i<_nb_execute_loop; i++)
      for (uint32_t j=0; j<_nb_load_store_unit [i]; j++)
        for (uint32_t k=0; k<_nb_context[i]; k++)
          {
            uint32_t num_thread = _translate_load_store_unit_to_thread [i][j][k];
            if (num_thread >= _nb_thread)
              test.error(toString(_("Context [%d][%d][%d] is linked with an invalid thread id.\n"),i,j,k));
            else
              if (thread_link [num_thread] == true)
                test.error(toString(_("Context [%d][%d][%d] is linked with an already used thread id.\n"),i,j,k));
              else
                thread_link [num_thread] = true;
          }

    for (uint32_t i=0; i<_nb_thread; ++i)
      if (not thread_link [i])
        test.error(toString(_("Thread [%d] is not linked.\n"),i));

    log_end(Dcache_Access,FUNCTION);

    return test;
  };

}; // end namespace dcache_access
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
