/*
 * $Id: test.cpp 117 2009-05-16 14:42:39Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#define NB_ITERATION  1
#define CYCLE_MAX     (10240*NB_ITERATION)

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/SelfTest/include/test.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod/SelfTest/include/Decod_request.h"
#include "Common/include/Test.h"
#include "Behavioural/include/Allocation.h"

void test (string name,
	   morpheo::behavioural::core::multi_front_end::front_end::decod_unit::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,CYCLE_MAX);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Decod_unit * _Decod_unit = new Decod_unit 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  sc_signal<Tcontrol_t         > ***  in_IFETCH_VAL                         ;
  sc_signal<Tcontrol_t         > *** out_IFETCH_ACK                         ;
  sc_signal<Tinstruction_t     > ***  in_IFETCH_INSTRUCTION                 ;

  sc_signal<Tcontext_t         >  **  in_IFETCH_CONTEXT_ID                  ;
  sc_signal<Tgeneral_address_t >  **  in_IFETCH_ADDRESS                     ;
//sc_signal<Tgeneral_address_t >  **  in_IFETCH_ADDRESS_NEXT                ;
  sc_signal<Tinst_ifetch_ptr_t >  **  in_IFETCH_INST_IFETCH_PTR             ;
  sc_signal<Tbranch_state_t    >  **  in_IFETCH_BRANCH_STATE                ;
  sc_signal<Tprediction_ptr_t  >  **  in_IFETCH_BRANCH_UPDATE_PREDICTION_ID ;
  sc_signal<Texception_t       >  **  in_IFETCH_EXCEPTION                   ;

  sc_signal<Tcontrol_t         >  ** out_DECOD_VAL                          ;
  sc_signal<Tcontrol_t         >  **  in_DECOD_ACK                          ;
  sc_signal<Tcontext_t         >  ** out_DECOD_CONTEXT_ID                   ;
  sc_signal<Tdepth_t           >  ** out_DECOD_DEPTH                        ;
  sc_signal<Ttype_t            >  ** out_DECOD_TYPE                         ;
  sc_signal<Toperation_t       >  ** out_DECOD_OPERATION                    ;
  sc_signal<Tcontrol_t         >  ** out_DECOD_NO_EXECUTE                   ;
  sc_signal<Tcontrol_t         >  ** out_DECOD_IS_DELAY_SLOT                ;
  sc_signal<Tgeneral_data_t    >  ** out_DECOD_ADDRESS                      ;

  sc_signal<Tgeneral_data_t    >  ** out_DECOD_ADDRESS_NEXT                 ;
  sc_signal<Tcontrol_t         >  ** out_DECOD_HAS_IMMEDIAT                 ;
  sc_signal<Tgeneral_data_t    >  ** out_DECOD_IMMEDIAT                     ;
  sc_signal<Tcontrol_t         >  ** out_DECOD_READ_RA                      ;
  sc_signal<Tgeneral_address_t >  ** out_DECOD_NUM_REG_RA                   ;
  sc_signal<Tcontrol_t         >  ** out_DECOD_READ_RB                      ;
  sc_signal<Tgeneral_address_t >  ** out_DECOD_NUM_REG_RB                   ;
  sc_signal<Tcontrol_t         >  ** out_DECOD_READ_RC                      ;
  sc_signal<Tspecial_address_t >  ** out_DECOD_NUM_REG_RC                   ;
  sc_signal<Tcontrol_t         >  ** out_DECOD_WRITE_RD                     ;
  sc_signal<Tgeneral_address_t >  ** out_DECOD_NUM_REG_RD                   ;
  sc_signal<Tcontrol_t         >  ** out_DECOD_WRITE_RE                     ;
  sc_signal<Tspecial_address_t >  ** out_DECOD_NUM_REG_RE                   ;
  sc_signal<Texception_t       >  ** out_DECOD_EXCEPTION_USE                ;
  sc_signal<Texception_t       >  ** out_DECOD_EXCEPTION                    ;

  sc_signal<Tcontrol_t         >  ** out_PREDICT_VAL                        ;
  sc_signal<Tcontrol_t         >  **  in_PREDICT_ACK                        ;
  sc_signal<Tcontext_t         >  ** out_PREDICT_CONTEXT_ID                 ;
  sc_signal<Tcontrol_t         >  ** out_PREDICT_MATCH_INST_IFETCH_PTR      ;
  sc_signal<Tbranch_state_t    >  ** out_PREDICT_BRANCH_STATE               ;
  sc_signal<Tprediction_ptr_t  >  ** out_PREDICT_BRANCH_UPDATE_PREDICTION_ID;
  sc_signal<Tbranch_condition_t>  ** out_PREDICT_BRANCH_CONDITION           ;
//sc_signal<Tcontrol_t         >  ** out_PREDICT_BRANCH_STACK_WRITE         ;
  sc_signal<Tcontrol_t         >  ** out_PREDICT_BRANCH_DIRECTION           ;
  sc_signal<Tgeneral_data_t    >  ** out_PREDICT_ADDRESS_SRC                ;
  sc_signal<Tgeneral_data_t    >  ** out_PREDICT_ADDRESS_DEST               ;
  sc_signal<Tcontrol_t         >  **  in_PREDICT_CAN_CONTINUE               ;

  sc_signal<Tdepth_t           >  **  in_DEPTH_MIN                          ;
  sc_signal<Tdepth_t           >  **  in_DEPTH_MAX                          ;
  sc_signal<Tcontrol_t         >  **  in_DEPTH_FULL                         ;

  sc_signal<Tcounter_t         >  ** out_NB_INST_DECOD_ALL                  ;

  sc_signal<Tcontrol_t         >  **  in_CONTEXT_DECOD_ENABLE               ;
  sc_signal<Tcontrol_t         >  **  in_CONTEXT_DEPTH_VAL                  ;
  sc_signal<Tdepth_t           >  **  in_CONTEXT_DEPTH                      ;

  sc_signal<Tcontrol_t         >   * out_CONTEXT_EVENT_VAL                  ;
  sc_signal<Tcontrol_t         >   *  in_CONTEXT_EVENT_ACK                  ;
  sc_signal<Tcontext_t         >   * out_CONTEXT_EVENT_CONTEXT_ID           ;
  sc_signal<Tdepth_t           >   * out_CONTEXT_EVENT_DEPTH                ;
  sc_signal<Tevent_type_t      >   * out_CONTEXT_EVENT_TYPE                 ;
  sc_signal<Tcontrol_t         >   * out_CONTEXT_EVENT_IS_DELAY_SLOT        ;
  sc_signal<Tgeneral_data_t    >   * out_CONTEXT_EVENT_ADDRESS              ;
  sc_signal<Tgeneral_data_t    >   * out_CONTEXT_EVENT_ADDRESS_EPCR         ;



  ALLOC2_SC_SIGNAL( in_IFETCH_VAL                         ," in_IFETCH_VAL                         ",Tcontrol_t         ,_param->_nb_context, _param->_nb_inst_fetch[it1]);
  ALLOC2_SC_SIGNAL(out_IFETCH_ACK                         ,"out_IFETCH_ACK                         ",Tcontrol_t         ,_param->_nb_context, _param->_nb_inst_fetch[it1]);
  ALLOC2_SC_SIGNAL( in_IFETCH_INSTRUCTION                 ," in_IFETCH_INSTRUCTION                 ",Tinstruction_t     ,_param->_nb_context, _param->_nb_inst_fetch[it1]);

  ALLOC1_SC_SIGNAL(in_IFETCH_CONTEXT_ID                   ,"in_IFETCH_CONTEXT_ID                   ",Tcontext_t         ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(in_IFETCH_ADDRESS                      ,"in_IFETCH_ADDRESS                      ",Tgeneral_address_t ,_param->_nb_context);
//ALLOC1_SC_SIGNAL(in_IFETCH_ADDRESS_NEXT                 ,"in_IFETCH_ADDRESS_NEXT                 ",Tgeneral_address_t ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(in_IFETCH_INST_IFETCH_PTR              ,"in_IFETCH_INST_IFETCH_PTR              ",Tinst_ifetch_ptr_t ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(in_IFETCH_BRANCH_STATE                 ,"in_IFETCH_BRANCH_STATE                 ",Tbranch_state_t    ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(in_IFETCH_BRANCH_UPDATE_PREDICTION_ID  ,"in_IFETCH_BRANCH_UPDATE_PREDICTION_ID  ",Tprediction_ptr_t  ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(in_IFETCH_EXCEPTION                    ,"in_IFETCH_EXCEPTION                    ",Texception_t       ,_param->_nb_context);

  ALLOC1_SC_SIGNAL(out_DECOD_VAL                          ,"out_DECOD_VAL                          ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_ACK                          ," in_DECOD_ACK                          ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_CONTEXT_ID                   ,"out_DECOD_CONTEXT_ID                   ",Tcontext_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_DEPTH                        ,"out_DECOD_DEPTH                        ",Tdepth_t           ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_TYPE                         ,"out_DECOD_TYPE                         ",Ttype_t            ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_OPERATION                    ,"out_DECOD_OPERATION                    ",Toperation_t       ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_NO_EXECUTE                   ,"out_DECOD_NO_EXECUTE                   ",Tcontrol_t         ,_param->_nb_inst_decod); 
  ALLOC1_SC_SIGNAL(out_DECOD_IS_DELAY_SLOT                ,"out_DECOD_IS_DELAY_SLOT                ",Tcontrol_t         ,_param->_nb_inst_decod);
#ifdef DEBUG
  ALLOC1_SC_SIGNAL(out_DECOD_ADDRESS                      ,"out_DECOD_ADDRESS                      ",Tgeneral_data_t    ,_param->_nb_inst_decod);
#endif
  ALLOC1_SC_SIGNAL(out_DECOD_ADDRESS_NEXT                 ,"out_DECOD_ADDRESS_NEXT                 ",Tgeneral_data_t    ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_HAS_IMMEDIAT                 ,"out_DECOD_HAS_IMMEDIAT                 ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_IMMEDIAT                     ,"out_DECOD_IMMEDIAT                     ",Tgeneral_data_t    ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_READ_RA                      ,"out_DECOD_READ_RA                      ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_NUM_REG_RA                   ,"out_DECOD_NUM_REG_RA                   ",Tgeneral_address_t ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_READ_RB                      ,"out_DECOD_READ_RB                      ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_NUM_REG_RB                   ,"out_DECOD_NUM_REG_RB                   ",Tgeneral_address_t ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_READ_RC                      ,"out_DECOD_READ_RC                      ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_NUM_REG_RC                   ,"out_DECOD_NUM_REG_RC                   ",Tspecial_address_t ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_WRITE_RD                     ,"out_DECOD_WRITE_RD                     ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_NUM_REG_RD                   ,"out_DECOD_NUM_REG_RD                   ",Tgeneral_address_t ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_WRITE_RE                     ,"out_DECOD_WRITE_RE                     ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_NUM_REG_RE                   ,"out_DECOD_NUM_REG_RE                   ",Tspecial_address_t ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_EXCEPTION_USE                ,"out_DECOD_EXCEPTION_USE                ",Texception_t       ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_EXCEPTION                    ,"out_DECOD_EXCEPTION                    ",Texception_t       ,_param->_nb_inst_decod);

  ALLOC1_SC_SIGNAL(out_PREDICT_VAL                        ,"out_PREDICT_VAL                        ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_PREDICT_ACK                        ," in_PREDICT_ACK                        ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_PREDICT_CONTEXT_ID                 ,"out_PREDICT_CONTEXT_ID                 ",Tcontext_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_PREDICT_MATCH_INST_IFETCH_PTR      ,"out_PREDICT_MATCH_INST_IFETCH_PTR      ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_PREDICT_BRANCH_STATE               ,"out_PREDICT_BRANCH_STATE               ",Tbranch_state_t    ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID,"out_PREDICT_BRANCH_UPDATE_PREDICTION_ID",Tprediction_ptr_t  ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_PREDICT_BRANCH_CONDITION           ,"out_PREDICT_BRANCH_CONDITION           ",Tbranch_condition_t,_param->_nb_inst_decod);
//ALLOC1_SC_SIGNAL(out_PREDICT_BRANCH_STACK_WRITE         ,"out_PREDICT_BRANCH_STACK_WRITE         ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_PREDICT_BRANCH_DIRECTION           ,"out_PREDICT_BRANCH_DIRECTION           ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_PREDICT_ADDRESS_SRC                ,"out_PREDICT_ADDRESS_SRC                ",Tgeneral_data_t    ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_PREDICT_ADDRESS_DEST               ,"out_PREDICT_ADDRESS_DEST               ",Tgeneral_data_t    ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_PREDICT_CAN_CONTINUE               ," in_PREDICT_CAN_CONTINUE               ",Tcontrol_t         ,_param->_nb_inst_decod);

  ALLOC1_SC_SIGNAL( in_DEPTH_MIN                          ," in_DEPTH_MIN                          ",Tdepth_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_DEPTH_MAX                          ," in_DEPTH_MAX                          ",Tdepth_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_DEPTH_FULL                         ," in_DEPTH_FULL                         ",Tcontrol_t         ,_param->_nb_context);

  ALLOC1_SC_SIGNAL(out_NB_INST_DECOD_ALL                  ,"out_NB_INST_DECOD_ALL                  ",Tcounter_t         ,_param->_nb_context);

  ALLOC1_SC_SIGNAL( in_CONTEXT_DECOD_ENABLE               ," in_CONTEXT_DECOD_ENABLE               ",Tcontrol_t         ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_CONTEXT_DEPTH_VAL                  ," in_CONTEXT_DEPTH_VAL                  ",Tcontrol_t         ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_CONTEXT_DEPTH                      ," in_CONTEXT_DEPTH                      ",Tdepth_t           ,_param->_nb_context);

  ALLOC0_SC_SIGNAL( out_CONTEXT_EVENT_VAL                  ,"out_CONTEXT_EVENT_VAL                  ",Tcontrol_t         );
  ALLOC0_SC_SIGNAL(  in_CONTEXT_EVENT_ACK                  ," in_CONTEXT_EVENT_ACK                  ",Tcontrol_t         );
  ALLOC0_SC_SIGNAL( out_CONTEXT_EVENT_CONTEXT_ID           ,"out_CONTEXT_EVENT_CONTEXT_ID           ",Tcontext_t         );
  ALLOC0_SC_SIGNAL( out_CONTEXT_EVENT_DEPTH                ,"out_CONTEXT_EVENT_DEPTH                ",Tdepth_t           );
  ALLOC0_SC_SIGNAL( out_CONTEXT_EVENT_TYPE                 ,"out_CONTEXT_EVENT_TYPE                 ",Tevent_type_t      );
  ALLOC0_SC_SIGNAL( out_CONTEXT_EVENT_IS_DELAY_SLOT        ,"out_CONTEXT_EVENT_IS_DELAY_SLOT        ",Tcontrol_t         );
  ALLOC0_SC_SIGNAL( out_CONTEXT_EVENT_ADDRESS              ,"out_CONTEXT_EVENT_ADDRESS              ",Tgeneral_data_t    );
  ALLOC0_SC_SIGNAL( out_CONTEXT_EVENT_ADDRESS_EPCR         ,"out_CONTEXT_EVENT_ADDRESS_EPCR         ",Tgeneral_data_t    );
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Decod_unit.\n"),name.c_str());

  (*(_Decod_unit->in_CLOCK))        (*(in_CLOCK));
  (*(_Decod_unit->in_NRESET))       (*(in_NRESET));

  INSTANCE2_SC_SIGNAL(_Decod_unit, in_IFETCH_VAL                         ,_param->_nb_context, _param->_nb_inst_fetch[it1]);
  INSTANCE2_SC_SIGNAL(_Decod_unit,out_IFETCH_ACK                         ,_param->_nb_context, _param->_nb_inst_fetch[it1]);
  INSTANCE2_SC_SIGNAL(_Decod_unit, in_IFETCH_INSTRUCTION                 ,_param->_nb_context, _param->_nb_inst_fetch[it1]);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Decod_unit,in_IFETCH_CONTEXT_ID                   ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Decod_unit,in_IFETCH_ADDRESS                      ,_param->_nb_context);
//INSTANCE1_SC_SIGNAL(_Decod_unit,in_IFETCH_ADDRESS_NEXT                 ,_param->_nb_context);

  for (uint32_t i=0; i<_param->_nb_context; ++i)
    {
      if (_param->_have_port_inst_ifetch_ptr)
        INSTANCE0_SC_SIGNAL(_Decod_unit,in_IFETCH_INST_IFETCH_PTR[i]);
      if (_param->_have_port_depth)
        INSTANCE0_SC_SIGNAL(_Decod_unit,in_IFETCH_BRANCH_UPDATE_PREDICTION_ID [i]);
    }

  INSTANCE1_SC_SIGNAL(_Decod_unit,in_IFETCH_BRANCH_STATE                 ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Decod_unit,in_IFETCH_EXCEPTION                    ,_param->_nb_context);

  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_VAL                          ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit, in_DECOD_ACK                          ,_param->_nb_inst_decod);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_CONTEXT_ID                   ,_param->_nb_inst_decod);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_DEPTH                        ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_TYPE                         ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_OPERATION                    ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_NO_EXECUTE                   ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_IS_DELAY_SLOT                ,_param->_nb_inst_decod);
#ifdef DEBUG
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_ADDRESS                      ,_param->_nb_inst_decod);
#endif
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_ADDRESS_NEXT                 ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_HAS_IMMEDIAT                 ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_IMMEDIAT                     ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_READ_RA                      ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_NUM_REG_RA                   ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_READ_RB                      ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_NUM_REG_RB                   ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_READ_RC                      ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_NUM_REG_RC                   ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_WRITE_RD                     ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_NUM_REG_RD                   ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_WRITE_RE                     ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_NUM_REG_RE                   ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_EXCEPTION_USE                ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_DECOD_EXCEPTION                    ,_param->_nb_inst_decod);

  INSTANCE1_SC_SIGNAL(_Decod_unit,out_PREDICT_VAL                        ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit, in_PREDICT_ACK                        ,_param->_nb_inst_decod);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_PREDICT_CONTEXT_ID                 ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_PREDICT_MATCH_INST_IFETCH_PTR      ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_PREDICT_BRANCH_STATE               ,_param->_nb_inst_decod);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_PREDICT_BRANCH_UPDATE_PREDICTION_ID,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_PREDICT_BRANCH_CONDITION           ,_param->_nb_inst_decod);
//INSTANCE1_SC_SIGNAL(_Decod_unit,out_PREDICT_BRANCH_STACK_WRITE         ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_PREDICT_BRANCH_DIRECTION           ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_PREDICT_ADDRESS_SRC                ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_PREDICT_ADDRESS_DEST               ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_unit, in_PREDICT_CAN_CONTINUE               ,_param->_nb_inst_decod);

  if (_param->_have_port_depth)
    {
  INSTANCE1_SC_SIGNAL(_Decod_unit, in_DEPTH_MIN                          ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Decod_unit, in_DEPTH_MAX                          ,_param->_nb_context);
    }
  INSTANCE1_SC_SIGNAL(_Decod_unit, in_DEPTH_FULL                         ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Decod_unit,out_NB_INST_DECOD_ALL                  ,_param->_nb_context);

  INSTANCE1_SC_SIGNAL(_Decod_unit, in_CONTEXT_DECOD_ENABLE               ,_param->_nb_context);

  INSTANCE1_SC_SIGNAL(_Decod_unit, in_CONTEXT_DEPTH_VAL                  ,_param->_nb_context);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Decod_unit, in_CONTEXT_DEPTH                      ,_param->_nb_context);

  INSTANCE0_SC_SIGNAL( _Decod_unit,out_CONTEXT_EVENT_VAL                  );
  INSTANCE0_SC_SIGNAL( _Decod_unit, in_CONTEXT_EVENT_ACK                  );
  if (_param->_have_port_context_id)
  INSTANCE0_SC_SIGNAL( _Decod_unit,out_CONTEXT_EVENT_CONTEXT_ID           );
  if (_param->_have_port_depth)
  INSTANCE0_SC_SIGNAL( _Decod_unit,out_CONTEXT_EVENT_DEPTH                );
  INSTANCE0_SC_SIGNAL( _Decod_unit,out_CONTEXT_EVENT_TYPE                 );
  INSTANCE0_SC_SIGNAL( _Decod_unit,out_CONTEXT_EVENT_IS_DELAY_SLOT        );
  INSTANCE0_SC_SIGNAL( _Decod_unit,out_CONTEXT_EVENT_ADDRESS              );
  INSTANCE0_SC_SIGNAL( _Decod_unit,out_CONTEXT_EVENT_ADDRESS_EPCR         );

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  const  int32_t percent_transaction_ifetch  = 100;
  const  int32_t percent_transaction_decod   = 100;
  const  int32_t percent_transaction_predict = 100;
  const  int32_t percent_transaction_event   = 100;

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  for (uint32_t i=0; i<_param->_nb_context; i++)
    in_CONTEXT_DEPTH_VAL [i]->write(1);

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      Decod_request request [_param->_nb_context];
      list<entry_t> respons [_param->_nb_context];

      uint32_t nb_request  = 0;

      uint32_t delay_slot_previous [_param->_nb_context];
      uint32_t delay_slot_current  [_param->_nb_context];
      uint32_t delay_slot_next     [_param->_nb_context];

      for (uint32_t i=0; i<_param->_nb_context; i++)
	{
	  nb_request += request[i].size();
	  delay_slot_current  [i] = false;
	  delay_slot_next     [i] = false;

	  in_DEPTH_MIN       [i]->write(0);
	  in_DEPTH_MAX       [i]->write(0);
	  in_CONTEXT_DEPTH   [i]->write(0);
	}

      while (nb_request > 0)
	{
	  for (uint32_t i=0; i<_param->_nb_context; i++)
	    {
	      delay_slot_previous  [i] = false;
	      
	      in_CONTEXT_DECOD_ENABLE [i]->write((rand()%100)<percent_transaction_decod);

	      for (uint32_t j=0; j<_param->_nb_inst_fetch[i]; j++)
		in_IFETCH_VAL [i][j]->write(0);
		  
	      if ((rand()%100)<percent_transaction_ifetch)
		{
		  list<entry_t>::iterator it = request[i].begin();
		  
		  if (it!=request [i].end())
		    {
		      uint32_t lsb = it->_address%_param->_nb_inst_fetch[i];
		      
		      in_IFETCH_ADDRESS         [i]->write(it->_address-lsb);
		      in_IFETCH_BRANCH_STATE    [i]->write(BRANCH_STATE_NONE);
		      if (_param->_have_port_inst_ifetch_ptr)
		      in_IFETCH_INST_IFETCH_PTR [i]->write(0);

		      // Alignement
		      for (uint32_t j=lsb; j<_param->_nb_inst_fetch[i]; j++)
			{
			  in_IFETCH_VAL                         [i][j]->write(1);
			  in_IFETCH_INSTRUCTION                 [i][j]->write(it->_instruction);
// 			  in_IFETCH_ADDRESS_NEXT                [i]->write(it->_address_next);
			  if (it->_type == TYPE_BRANCH)
			  in_IFETCH_BRANCH_STATE                [i]->write(it->_branch_state);
			  in_IFETCH_BRANCH_UPDATE_PREDICTION_ID [i]->write(it->_branch_update_prediction_id);
			  in_IFETCH_EXCEPTION                   [i]->write(it->_exception_ifetch);
			  
			  if ((it->_is_delay_slot) or
			      ((++it)==request [i].end()))
			    break;
			}
		    }
		}
	    }
	  
	  {
	    bool previous_ack = true;
	      
	    for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	      {
		bool ack = previous_ack and ((rand()%100)<percent_transaction_decod);
		in_DECOD_ACK [i]->write(ack);
		
		previous_ack = ack;

		in_PREDICT_ACK          [i]->write((rand()%100)<percent_transaction_predict);
 		in_PREDICT_CAN_CONTINUE [i]->write(0);
	      }
	  }

	  in_CONTEXT_EVENT_ACK->write((rand()%100)<percent_transaction_event);

	  SC_START(0);

	  uint32_t find_event = false;
	  for (uint32_t i=0; i<_param->_nb_context; i++)
	    for (uint32_t j=0; j<_param->_nb_inst_fetch[i]; j++)
	      if (in_IFETCH_VAL[i][j]->read() and out_IFETCH_ACK[i][j]->read())
		{
		  LABEL("IFETCH      [%d][%d] : transaction",i,j);
		 
		  entry_t entry = request [i].front();
		  LABEL("  * address 0x%x",entry._address);
		  
		  respons [i].push_back(entry);
		  request [i].pop_front();
 
		  if (entry._type == TYPE_BRANCH)
		    {
		      delay_slot_next     [i] = true;
		      
		      // find good decod
		      uint32_t x;

		      for (x=0; x<=_param->_nb_inst_decod; x++)
			{
			  if (x==_param->_nb_inst_decod)
			    TEST_KO("No find predict transaction");

			  Tcontext_t ctxt = (_param->_have_port_context_id)?out_PREDICT_CONTEXT_ID[x]->read():0;

			  if ((ctxt == i) and
			      (out_PREDICT_VAL [x]->read() and in_PREDICT_ACK [x]->read()))
			    break;
			}

		      LABEL("PREDICT     [%d]    : transaction",x  );
		      
		      
		      TEST(Tcontrol_t         , out_PREDICT_MATCH_INST_IFETCH_PTR       [x]->read(),((entry._address)%_param->_nb_inst_fetch[i]) == 0);
		      TEST(Tbranch_state_t    , out_PREDICT_BRANCH_STATE                [x]->read(), entry._branch_state               );
		      if (_param->_have_port_depth)
		      TEST(Tprediction_ptr_t  , out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [x]->read(), entry._branch_update_prediction_id);
		      TEST(Tbranch_condition_t, out_PREDICT_BRANCH_CONDITION            [x]->read(), entry._branch_condition           );
// 		      TEST(Tcontrol_t         , out_PREDICT_BRANCH_STACK_WRITE          [x]->read(), entry._branch_stack_write         );
		      TEST(Tcontrol_t         , out_PREDICT_BRANCH_DIRECTION            [x]->read(), entry._branch_direction           );
		      TEST(Tgeneral_data_t    , out_PREDICT_ADDRESS_SRC                 [x]->read(), entry._address                    );
		      TEST(Tgeneral_data_t    , out_PREDICT_ADDRESS_DEST                [x]->read(), entry._branch_address_dest        );
		    }
		  
// 		  TEST(bool, find_event, false); // can continue decod after event
		  if (entry._context_event_type != EVENT_TYPE_NONE)
		    {
		      find_event = true;
		      
		      LABEL("CONTEXT_EVENT      : transaction");
		      
		      if (_param->_have_port_context_id)
	              TEST(Tcontext_t     ,out_CONTEXT_EVENT_CONTEXT_ID   ->read(), i);
		      if (_param->_have_port_depth)
                      TEST(Tcontext_t     ,out_CONTEXT_EVENT_DEPTH        ->read(), entry._depth);
		      TEST(Tevent_type_t  ,out_CONTEXT_EVENT_TYPE         ->read(), entry._context_event_type);
		      TEST(Tcontrol_t     ,out_CONTEXT_EVENT_IS_DELAY_SLOT->read(), entry._is_delay_slot);
		      TEST(Tgeneral_data_t,out_CONTEXT_EVENT_ADDRESS      ->read(), entry._address      );
		      TEST(Tgeneral_data_t,out_CONTEXT_EVENT_ADDRESS_EPCR ->read(), entry._address_next );
		    }
		  
		  TEST(bool, delay_slot_previous [i], false); // can't continue
		  delay_slot_previous [i] = delay_slot_current  [i];
		  delay_slot_current  [i] = delay_slot_next     [i];
		  delay_slot_next     [i] = false;
		}

	  for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	    if (out_DECOD_VAL[i]->read() and in_DECOD_ACK[i]->read())
	      {
		Tcontext_t context = (_param->_have_port_context_id)?out_DECOD_CONTEXT_ID[i]->read():0;

		LABEL("DECOD       [%d]    : transaction",i  );

		TEST(bool              ,respons [context].empty(), false);

		LABEL(" * context         : %d",context);
		LABEL(" * instruction     : 0x%x",respons [context].front()._instruction);

		if (_param->_have_port_depth)
		TEST(Tdepth_t          ,  out_DECOD_DEPTH         [i]->read(), respons [context].front()._depth        );
		TEST(Ttype_t           ,  out_DECOD_TYPE          [i]->read(), respons [context].front()._type         );
		TEST(Toperation_t      ,  out_DECOD_OPERATION     [i]->read(), respons [context].front()._operation    );
// 		TEST(Tcontrol_t        ,  out_DECOD_NO_EXECUTE    [i]->read(), respons [context].front()._no_execute   );
		TEST(Tcontrol_t        ,  out_DECOD_IS_DELAY_SLOT [i]->read(), respons [context].front()._is_delay_slot);
// 		TEST(Tgeneral_data_t   ,  out_DECOD_ADDRESS_NEXT  [i]->read(), respons [context].front()._address_next );
		TEST(Tcontrol_t        ,  out_DECOD_HAS_IMMEDIAT  [i]->read(), respons [context].front()._has_immediat );
		if (respons [context].front()._has_immediat)
		TEST(Tgeneral_data_t   ,  out_DECOD_IMMEDIAT      [i]->read(), respons [context].front()._immediat     );
		TEST(Tcontrol_t        ,  out_DECOD_READ_RA       [i]->read(), respons [context].front()._read_ra      );
		if (respons [context].front()._read_ra)
		TEST(Tgeneral_address_t,  out_DECOD_NUM_REG_RA    [i]->read(), respons [context].front()._num_reg_ra   );
		TEST(Tcontrol_t        ,  out_DECOD_READ_RB       [i]->read(), respons [context].front()._read_rb      );
		if (respons [context].front()._read_rb)
		TEST(Tgeneral_address_t,  out_DECOD_NUM_REG_RB    [i]->read(), respons [context].front()._num_reg_rb   );
		TEST(Tcontrol_t        ,  out_DECOD_READ_RC       [i]->read(), respons [context].front()._read_rc      );
		if (respons [context].front()._read_rc)
		TEST(Tspecial_address_t,  out_DECOD_NUM_REG_RC    [i]->read(), respons [context].front()._num_reg_rc   );
		TEST(Tcontrol_t        ,  out_DECOD_WRITE_RD      [i]->read(), respons [context].front()._write_rd     );
		if (respons [context].front()._write_rd)
		TEST(Tgeneral_address_t,  out_DECOD_NUM_REG_RD    [i]->read(), respons [context].front()._num_reg_rd   );
		TEST(Tcontrol_t        ,  out_DECOD_WRITE_RE      [i]->read(), respons [context].front()._write_re     );
		if (respons [context].front()._write_re)
		TEST(Tspecial_address_t,  out_DECOD_NUM_REG_RE    [i]->read(), respons [context].front()._num_reg_re   );
		TEST(Texception_t      ,  out_DECOD_EXCEPTION_USE [i]->read(), respons [context].front()._exception_use);
// 		TEST(Texception_t      ,  out_DECOD_EXCEPTION     [i]->read(), respons [context].front()._exception    );

		respons [context].pop_front();
		nb_request --;
	      }

	  TEST(bool, (out_CONTEXT_EVENT_VAL->read() and in_CONTEXT_EVENT_ACK->read()), find_event);

	  SC_START(1);
	}

      for (uint32_t i=0; i<_param->_nb_context; i++)
	{
	  TEST(Tcounter_t,out_NB_INST_DECOD_ALL [i]->read(), respons[i].size());
	  
	}
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  DELETE2_SC_SIGNAL( in_IFETCH_VAL                         ,_param->_nb_context, _param->_nb_inst_fetch[it1]);
  DELETE2_SC_SIGNAL(out_IFETCH_ACK                         ,_param->_nb_context, _param->_nb_inst_fetch[it1]);
  DELETE2_SC_SIGNAL( in_IFETCH_INSTRUCTION                 ,_param->_nb_context, _param->_nb_inst_fetch[it1]);
  DELETE1_SC_SIGNAL(in_IFETCH_CONTEXT_ID                   ,_param->_nb_context);
  DELETE1_SC_SIGNAL(in_IFETCH_ADDRESS                      ,_param->_nb_context);
//DELETE1_SC_SIGNAL(in_IFETCH_ADDRESS_NEXT                 ,_param->_nb_context);
  DELETE1_SC_SIGNAL(in_IFETCH_INST_IFETCH_PTR              ,_param->_nb_context);
  DELETE1_SC_SIGNAL(in_IFETCH_BRANCH_STATE                 ,_param->_nb_context);
  DELETE1_SC_SIGNAL(in_IFETCH_BRANCH_UPDATE_PREDICTION_ID  ,_param->_nb_context);
  DELETE1_SC_SIGNAL(in_IFETCH_EXCEPTION                    ,_param->_nb_context);

  DELETE1_SC_SIGNAL(out_DECOD_VAL                          ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_DECOD_ACK                          ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_CONTEXT_ID                   ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_DEPTH                        ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_TYPE                         ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_OPERATION                    ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_NO_EXECUTE                   ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_IS_DELAY_SLOT                ,_param->_nb_inst_decod);
#ifdef DEBUG
  DELETE1_SC_SIGNAL(out_DECOD_ADDRESS                      ,_param->_nb_inst_decod);
#endif
  DELETE1_SC_SIGNAL(out_DECOD_ADDRESS_NEXT                 ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_HAS_IMMEDIAT                 ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_IMMEDIAT                     ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_READ_RA                      ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_NUM_REG_RA                   ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_READ_RB                      ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_NUM_REG_RB                   ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_READ_RC                      ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_NUM_REG_RC                   ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_WRITE_RD                     ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_NUM_REG_RD                   ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_WRITE_RE                     ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_NUM_REG_RE                   ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_EXCEPTION_USE                ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_EXCEPTION                    ,_param->_nb_inst_decod);

  DELETE1_SC_SIGNAL(out_PREDICT_VAL                        ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_PREDICT_ACK                        ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_PREDICT_CONTEXT_ID                 ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_PREDICT_MATCH_INST_IFETCH_PTR      ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_PREDICT_BRANCH_STATE               ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_PREDICT_BRANCH_CONDITION           ,_param->_nb_inst_decod);
//DELETE1_SC_SIGNAL(out_PREDICT_BRANCH_STACK_WRITE         ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_PREDICT_BRANCH_DIRECTION           ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_PREDICT_ADDRESS_SRC                ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_PREDICT_ADDRESS_DEST               ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_PREDICT_CAN_CONTINUE               ,_param->_nb_inst_decod);

  DELETE1_SC_SIGNAL( in_DEPTH_MIN                          ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_DEPTH_MAX                          ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_DEPTH_FULL                         ,_param->_nb_context);

  DELETE1_SC_SIGNAL(out_NB_INST_DECOD_ALL                  ,_param->_nb_context);

  DELETE1_SC_SIGNAL( in_CONTEXT_DECOD_ENABLE               ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_CONTEXT_DEPTH_VAL                  ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_CONTEXT_DEPTH                      ,_param->_nb_context);

  DELETE0_SC_SIGNAL(out_CONTEXT_EVENT_VAL                  );
  DELETE0_SC_SIGNAL( in_CONTEXT_EVENT_ACK                  );
  DELETE0_SC_SIGNAL(out_CONTEXT_EVENT_CONTEXT_ID           );
  DELETE0_SC_SIGNAL(out_CONTEXT_EVENT_DEPTH                );
  DELETE0_SC_SIGNAL(out_CONTEXT_EVENT_TYPE                 );
  DELETE0_SC_SIGNAL(out_CONTEXT_EVENT_IS_DELAY_SLOT        );
  DELETE0_SC_SIGNAL(out_CONTEXT_EVENT_ADDRESS              );
  DELETE0_SC_SIGNAL(out_CONTEXT_EVENT_ADDRESS_EPCR         );
    }
#endif

  delete _Decod_unit;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
